/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.capability.drag.LaneResizeCapability;
import oracle.bpm.designer.capability.edit.ElementEditCapability;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.LaneController;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class LaneColumnController
extends FlowElementControllerImpl<LaneImpl> {
    private final LaneController laneController;
    private static final long serialVersionUID = 2964436791689306747L;

    protected LaneColumnController(@NotNull LaneController laneController) {
        super(laneController.getContainer(), laneController.getDrawableLane().getDrawableLaneColumn());
        this.laneController = laneController;
        this.install(new ElementEditCapability(this));
        this.install(new LaneResizeCapability(this));
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        DrawContext context = this.getDrawContext();
        return context.isHorizontalDrawing() ? Cursor.NS_RESIZE_CURSOR : Cursor.WE_RESIZE_CURSOR;
    }

    @Override
    public String getTooltipMessage() {
        return ((LaneImpl)this.getModelObject()).getDefaultLabel();
    }

    @Override
    public void editProperties() {
        this.getLaneController().editProperties();
    }

    @Override
    public void remove() {
        this.getLaneController().remove();
        super.remove();
    }

    private LaneController getLaneController() {
        return this.laneController;
    }
}

