/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import fuego.simulation.SimulationFlowNodeImpl;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActivitySimulationInterface;
import oracle.bpm.designer.DomainStateManager;
import oracle.bpm.designer.capability.drag.NodeMoveCapability;
import oracle.bpm.designer.capability.edit.ElementEditCapability;
import oracle.bpm.designer.capability.selection.ElementPopUpCapability;
import oracle.bpm.designer.capability.selection.ElementSelectionCapability;
import oracle.bpm.designer.controller.ConnectionController;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.simulation.ActivitySimulationDelegated;
import oracle.bpm.designer.simulation.ActivitySimulationInfoDialog;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.designer.subcontroller.LoopCharacteristicSubcontroller;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.draw.renderer.Renderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Str;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.compile.exceptions.NoRoleActivityLocationException;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowNodeControllerImpl<T extends FlowNode>
extends FlowElementControllerImpl<T>
implements FlowNodeController<T>,
ActivitySimulationInterface {
    private final ToConnectionControllerMapper mapper;
    private ActivitySimulationDelegated simulation;

    protected FlowNodeControllerImpl(NodeContainerController container, @NotNull DrawableFlowNode<T> drawable) {
        super((Controller)container, drawable);
        this.install(new ElementEditCapability(this));
        this.install(new ElementSelectionCapability(this));
        this.install(new ElementPopUpCapability(this));
        this.installMoveCapability();
        ExpandCollapseSubcontroller.appendTo(this);
        LoopCharacteristicSubcontroller.appendTo(this);
        HighlightSubcontroller.appendTo(this);
        this.mapper = new ToConnectionControllerMapper(container);
        this.simulation = new ActivitySimulationDelegated(this);
    }

    @Deprecated
    public static Lane checkValidLocation(@NotNull FlowNode node, @NotNull Point point) throws ProjectException {
        DomainStateManager.checkDropLocation(point, (FlowElement)node);
        LaneImpl rx = (LaneImpl)LaneUtils.getLane((Process)node.getProcess(), (Point)point);
        if (rx == null) {
            throw new NoRoleActivityLocationException((FlowElement)node);
        }
        if (ModelUtils.hasLane((FlowNode)node) && rx.isAutomatic()) {
            throw new NoRoleActivityLocationException((FlowElement)node);
        }
        return rx;
    }

    @Override
    @NotNull
    public NodeContainerController getContainer() {
        return (NodeContainerController)super.getContainer();
    }

    @NotNull
    public final DrawableNodeContainer<?> getDrawableContainer() {
        return this.getDrawableNode().getContainer();
    }

    @Override
    public void editProperties() {
        FlowNode flowNode = (FlowNode)this.getModelObject();
        if (AbstractStudioWorkbench.getInstance().isSimulating()) {
            ActivitySimulationInfoDialog dialog = new ActivitySimulationInfoDialog(this.getDomain().getCanvas().getOwnerWindow(), flowNode);
            dialog.setVisible(true);
        } else {
            FlowNodePropertiesDialog.editProperties(flowNode);
        }
        this.getDomain().getCanvas().repaint();
    }

    @Override
    public String getTooltipMessage() {
        FlowNode node = (FlowNode)this.getModelObject();
        String documentation = node.getDocumentationMap().getString();
        if (!Str.isEmpty(documentation)) {
            return documentation.trim();
        }
        String description = node.getDefaultDescription();
        if (!Str.isEmpty(description)) {
            return description;
        }
        String typeString = ((FlowNode)this.getModelObject()).getBpmnType().getString() + ": ";
        String titleName = node.getDefaultLabel();
        return (titleName + ": " + typeString).trim();
    }

    @Override
    @NotNull
    public DrawableFlowNode<T> getDrawableNode() {
        return (DrawableFlowNode)this.getDrawableObject();
    }

    @Override
    @NotNull
    public Sequence<ConnectionController> getOutgoingConnections() {
        return ((FlowNode)this.getModelObject()).getOutgoingSequenceFlows().map(this.mapper);
    }

    @Override
    @NotNull
    public Sequence<ConnectionController> getIncomingConnections() {
        return ((FlowNode)this.getModelObject()).getIncomingSequenceFlows().map(this.mapper);
    }

    @Override
    public void drawSimulation(Graphics g) {
        this.simulation.drawSimulation(g);
    }

    @Override
    public FlowNode getActivity() {
        return (FlowNode)this.getModelObject();
    }

    @Override
    public SimulationFlowNodeImpl getSimulationInfo() {
        return this.simulation.getSimulationInfo();
    }

    @Override
    public void resetSimulation() {
        this.simulation.resetSimulation();
    }

    @Override
    public void updateSimulationValues() {
        this.simulation.updateSimulationValues();
    }

    @Override
    protected void refreshDrawable(@Nullable ProjectEvent event) {
        super.refreshDrawable(event);
        this.refreshConnections();
    }

    protected void refreshConnections() {
        for (ConnectionController connection : this.getIncomingConnections()) {
            connection.refresh();
        }
        for (ConnectionController connection : this.getOutgoingConnections()) {
            connection.refresh();
        }
    }

    @Deprecated
    protected void installMoveCapability() {
        this.install(new NodeMoveCapability(this));
    }

    private void refreshLocationAndSize() {
        DrawableFlowNode<T> drawableNode = this.getDrawableNode();
        drawableNode.setLocation(((FlowNode)this.getModelObject()).getLocation());
        Renderer renderer = drawableNode.getRenderer();
        if (renderer instanceof FlowElementRenderer) {
            Dimension size = ((FlowElementRenderer)renderer).getRenderDimension(this.getDrawContext());
            drawableNode.setWidth(this.getDrawContext(), size.getWidth());
            drawableNode.setHeight(this.getDrawContext(), size.getHeight());
        }
    }

    static class ToConnectionControllerMapper
    implements Function<SequenceFlow, ConnectionController> {
        private final NodeContainerController container;

        ToConnectionControllerMapper(@NotNull NodeContainerController container) {
            this.container = container;
        }

        @Override
        public ConnectionController eval(@NotNull SequenceFlow sequenceFlow) {
            ConnectionController result = null;
            if (this.container.contains((FlowElement)sequenceFlow)) {
                result = (ConnectionController)((Object)this.container.asController((FlowElement)sequenceFlow));
            }
            return result;
        }
    }
}

