/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.capability.Capability;
import oracle.bpm.designer.capability.CapableController;
import oracle.bpm.designer.capability.focus.FocusCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerImpl;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Graphics;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class FlowElementControllerImpl<T extends FlowElement>
extends ControllerImpl<T>
implements FlowElementController<T>,
CapableController<T> {
    private List<Capability> capabilities = new ArrayList<Capability>(5);
    private BatchProjectListenerAdapter<FlowElement> listener;

    protected FlowElementControllerImpl(Controller container, @NotNull DrawableFlowElement<T> drawable) {
        super(container, drawable);
        this.install(new FocusCapability(this));
    }

    @Override
    public void add() {
        this.addProjectObjectListener();
        super.add();
    }

    @Override
    public void remove() {
        super.remove();
        this.dispose();
    }

    @Override
    @NotNull
    public ProcessDomain getDomain() {
        return (ProcessDomain)super.getDomain();
    }

    @Override
    @NotNull
    public DrawableFlowElement<T> getDrawableObject() {
        return (DrawableFlowElement)super.getDrawableObject();
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    @Override
    public void drawSimulation(Graphics graphics) {
    }

    @Override
    public void install(@NotNull Capability capability) {
        this.capabilities.add(capability);
    }

    @Override
    public List<Capability> capabilities() {
        return this.capabilities;
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            this.getDomain().unregister(this);
            this.listener = null;
        }
        for (Controller controller : this.getControllers()) {
            controller.dispose();
        }
    }

    public String toString() {
        return this.name((FlowElement)this.getModelObject());
    }

    @NotNull
    protected final DrawContext getDrawContext() {
        return this.getDomain().getDrawContext();
    }

    private void addProjectObjectListener() {
        this.listener = new BatchProjectListenerAdapter<FlowElement>(FlowElement.class){

            public void processPostEvents(ProjectEventSet events) {
                boolean mustRefresh = false;
                boolean mustRefreshDrawable = false;
                for (ProjectEvent event : events) {
                    ProjectObject object = event.getProjectObject();
                    if (object.getParentObject() == FlowElementControllerImpl.this.getModelObject()) {
                        mustRefresh = true;
                        break;
                    }
                    if (object != FlowElementControllerImpl.this.getModelObject()) continue;
                    mustRefreshDrawable = true;
                }
                if (mustRefresh) {
                    FlowElementControllerImpl.this.refresh();
                } else if (mustRefreshDrawable) {
                    FlowElementControllerImpl.this.refreshDrawable(null);
                }
            }
        };
        this.getDomain().register(this);
    }

    private String name(@NotNull FlowElement flowElement) {
        return flowElement.getDefaultLabel() + '(' + flowElement.getId() + ')';
    }
}

