/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.Drawable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllersHolder<T extends Controller> {
    private final Map<Drawable, T> byDrawable;
    private final Map<Object, T> byElement;
    private final EnumMap<DesignerLayer, TreeSet<T>> byLayer = new EnumMap(DesignerLayer.class);

    private ControllersHolder() {
        this.byElement = new IdentityHashMap<Object, T>();
        this.byDrawable = new IdentityHashMap<Drawable, T>();
    }

    public static <T extends Controller> ControllersHolder<T> create() {
        return new ControllersHolder<T>();
    }

    public boolean add(@NotNull T controller) {
        if (!DesignerLayer.shouldSkipController((DesignerLayer)controller.getDrawableObject().getLayer())) {
            this.byElement.put(controller.getModelObject(), controller);
            this.byDrawable.put(controller.getDrawableObject(), controller);
        }
        return this.getDrawableTreeSet(controller.getDrawableObject().getLayer()).add(controller);
    }

    public boolean remove(@NotNull T controller) {
        if (!DesignerLayer.shouldSkipController((DesignerLayer)controller.getDrawableObject().getLayer())) {
            this.byElement.remove(controller.getModelObject());
            this.byDrawable.remove(controller.getDrawableObject());
        }
        return this.getDrawableTreeSet(controller.getDrawableObject().getLayer()).remove(controller);
    }

    public boolean contains(@NotNull T controller) {
        return this.getDrawableTreeSet(controller.getDrawableObject().getLayer()).contains(controller);
    }

    public boolean contains(@NotNull Drawable drawable) {
        return this.byDrawable.containsKey(drawable);
    }

    public boolean contains(@NotNull Object element) {
        return this.byElement.containsKey(element);
    }

    public void clear() {
        for (TreeSet<T> set : this.byLayer.values()) {
            set.clear();
        }
        this.byLayer.clear();
        this.byElement.clear();
        this.byDrawable.clear();
    }

    @NotNull
    public Sequence<T> getControllers() {
        SequenceBuilder<T> sequence = SequenceBuilder.create();
        for (TreeSet<T> set : this.byLayer.values()) {
            sequence.appendFirst(set);
        }
        return sequence.build();
    }

    @NotNull
    public Sequence<T> getControllersReversed() {
        SequenceBuilder<T> sequence = SequenceBuilder.create();
        for (TreeSet<T> set : this.byLayer.values()) {
            sequence.appendFirst(set.descendingSet());
        }
        return sequence.build();
    }

    @NotNull
    public Sequence<T> getAtLayer(@NotNull DesignerLayer layer) {
        return CollectionUtils.asSequence(this.getDrawableTreeSet(layer));
    }

    @NotNull
    public Sequence<T> getAtLayers(@NotNull EnumSet<DesignerLayer> layers) {
        SequenceBuilder<T> sequence = SequenceBuilder.create();
        for (DesignerLayer layer : layers) {
            sequence.append((Iterable<T>)this.getDrawableTreeSet(layer));
        }
        return sequence.build();
    }

    @Nullable
    public T getControllerFor(@NotNull Drawable drawable) {
        return (T)((Controller)this.byDrawable.get(drawable));
    }

    @Nullable
    public T getControllerFor(@NotNull Object element) {
        return (T)((Controller)this.byElement.get(element));
    }

    @NotNull
    private TreeSet<T> getDrawableTreeSet(@NotNull DesignerLayer layer) {
        TreeSet<Object> result;
        if (!this.byLayer.containsKey(layer)) {
            result = new TreeSet<Controller>(new ReverseDrawableControllerComparator());
            this.byLayer.put(layer, result);
        } else {
            result = this.byLayer.get(layer);
        }
        return result;
    }

    private static class ReverseDrawableControllerComparator
    implements Comparator<Controller> {
        private ReverseDrawableControllerComparator() {
        }

        @Override
        public int compare(Controller first, Controller second) {
            int ret = second.getDrawableObject().getLayer().ordinal() - first.getDrawableObject().getLayer().ordinal();
            return ret != 0 ? ret : first.getDrawableObject().compareTo(second.getDrawableObject());
        }
    }
}

