/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerContainer;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class ControllerUtils {
    private static final int MIN_INSERTION_DISTANCE = 2500;

    public static Sequence<FlowElementController> getControllersAtLayersRecursive(@NotNull NodeContainerController<?> container, @NotNull EnumSet<DesignerLayer> layers) {
        SequenceBuilder<FlowElementController> builder = SequenceBuilder.create();
        ControllerUtils.getControllersAtLayersRecursive(container, layers, builder);
        return builder.build();
    }

    @NotNull
    public static NodeContainerController<?> getNodeContainerControllerFor(@NotNull NodeContainerController<?> container, @NotNull FlowElement element) {
        NodeContainerController<?> result = null;
        if (container.contains(element)) {
            result = container;
        } else {
            Sequence<NodeContainerController> containers = CollectionUtils.selectInstanceOf(container.getControllers(), NodeContainerController.class);
            for (NodeContainerController inner : containers) {
                try {
                    result = ControllerUtils.getNodeContainerControllerFor(inner, element);
                }
                catch (Exception e) {}
            }
        }
        if (result == null) {
            throw new IllegalStateException("No ControllerContainer found for this element : " + element);
        }
        return result;
    }

    public static SequenceFlowController getClosestTransition(@NotNull FlowNodeController controller, @NotNull NodeContainerController container, @NotNull Point location, boolean shiftDown, boolean recursive) {
        SequenceFlowController closest;
        SequenceFlowController result = null;
        DrawContext context = controller.getDomain().getDrawContext();
        if (ModelUtils.canBeInsertedInATransition(controller.getModelObject(), (boolean)shiftDown) && (closest = ControllerUtils.getClosestTransition(ControllerUtils.getFlowControllersForContainer(container, recursive), context, location, shiftDown)) != null && !((SequenceFlow)closest.getModelObject()).getSource().equals(controller.getModelObject()) && !((SequenceFlow)closest.getModelObject()).getTarget().equals(controller.getModelObject())) {
            result = closest;
        }
        return result;
    }

    public static SequenceFlowController getClosestTransition(@NotNull NodeContainerController container, @NotNull Point location, boolean shiftDown, boolean recursive) {
        DrawContext context = container.getDomain().getDrawContext();
        Sequence<SequenceFlowController> sequenceFlows = ControllerUtils.getFlowControllersForContainer(container, recursive);
        return ControllerUtils.getClosestTransition(sequenceFlows, context, location, shiftDown);
    }

    public static List<FlowElementController> getControllersAt(@NotNull ControllerContainer container, final @NotNull Rectangle bounds, final @NotNull DrawContext context) {
        ArrayList<FlowElementController> result = new ArrayList<FlowElementController>();
        Predicate<FlowElementController> inside = new Predicate<FlowElementController>(){

            @Override
            public boolean check(FlowElementController controller) {
                DrawableFlowElement drawable = controller.getDrawableObject();
                DesignerLayer layer = drawable.getLayer();
                return !DesignerLayer.shouldSkipController((DesignerLayer)layer) && !layer.equals((Object)DesignerLayer.LANE_NAME) && !layer.equals((Object)DesignerLayer.PROCESS) && !layer.equals((Object)DesignerLayer.LANE_COLUMN) && drawable.intersects(bounds, context);
            }
        };
        ControllerUtils.getControllersAt(container, inside, result);
        return result;
    }

    public static FlowElementController createFlowElementControllerFromType(@NotNull FlowFigureType type, @NotNull ProcessDomain domain) {
        Process process = domain.getDomainElement();
        Object element = type.getType().isArtifact() ? FlowFigureUtils.createArtifactFromFigureType((FlowFigureType)type, (NodeContainer)process) : FlowFigureUtils.createNodeFromFigureType((FlowFigureType)type, (NodeContainer)process);
        FlowElementController controller = domain.getCanvas().getProcessController().createDisposableControllerFor((FlowElement)element);
        domain.getCanvas().repaint();
        return controller;
    }

    private static SequenceFlowController getClosestTransition(@NotNull Sequence<SequenceFlowController> drawableFlows, @NotNull DrawContext context, @NotNull Point location, boolean shiftDown) {
        SequenceFlowController closest = null;
        double minDistance = shiftDown ? 2.147483647E9 : 2500.0;
        for (SequenceFlowController flowController : drawableFlows) {
            double distance;
            DrawableSequenceFlow drawableFlow = flowController.getDrawableObject();
            if (drawableFlow.isHidden(context) || !((distance = drawableFlow.getPathPoint(0.5).distanceSq(location.getX(), location.getY())) < minDistance)) continue;
            minDistance = distance;
            closest = flowController;
        }
        return closest;
    }

    private static List<FlowElementController> getControllersAt(@NotNull ControllerContainer container, @NotNull Predicate<FlowElementController> inside, @NotNull List<FlowElementController> list) {
        for (Controller child : container.getControllers()) {
            if (!(child instanceof FlowElementController)) continue;
            FlowElementController controller = (FlowElementController)child;
            if (controller instanceof NodeContainerController) {
                ControllerUtils.getControllersAt((ControllerContainer)child, inside, list);
            }
            if (!inside.check(controller)) continue;
            list.add(controller);
        }
        return list;
    }

    private static void getControllersAtLayersRecursive(@NotNull NodeContainerController<?> container, @NotNull EnumSet<DesignerLayer> layers, @NotNull SequenceBuilder<FlowElementController> result) {
        result.append(container.getControllersAt(layers));
        Sequence<NodeContainerController> containers = CollectionUtils.selectInstanceOf(container.getControllers(), NodeContainerController.class);
        for (NodeContainerController inner : containers) {
            ControllerUtils.getControllersAtLayersRecursive(inner, layers, result);
        }
    }

    private static Sequence<DrawableSequenceFlow> getDrawableFlowsForContainer(@NotNull DrawableNodeContainer<?> container, boolean recursive) {
        SequenceBuilder<DrawableSequenceFlow> flows = SequenceBuilder.create(((NodeContainer)container.getModelObject()).getSequenceFlows().map(new ToDrawableFlow(container)));
        if (recursive) {
            Sequence<DrawableNodeContainer> containers = CollectionUtils.selectInstanceOf(container.getDrawables(), DrawableNodeContainer.class);
            for (DrawableNodeContainer inner : containers) {
                flows.append(ControllerUtils.getDrawableFlowsForContainer(inner, recursive));
            }
        }
        return flows.build();
    }

    private static Sequence<SequenceFlowController> getFlowControllersForContainer(@NotNull NodeContainerController<?> container, boolean recursive) {
        SequenceBuilder<SequenceFlowController> flows = SequenceBuilder.create(container.getModelObject().getSequenceFlows().map(new ToFlowController(container)));
        if (recursive) {
            Sequence<NodeContainerController> containers = CollectionUtils.selectInstanceOf(container.getControllers(), NodeContainerController.class);
            for (NodeContainerController inner : containers) {
                flows.append(ControllerUtils.getFlowControllersForContainer(inner, recursive));
            }
        }
        return flows.build();
    }

    private static class ToFlowController
    implements Function<SequenceFlow, SequenceFlowController> {
        private NodeContainerController container;

        private ToFlowController(NodeContainerController container) {
            this.container = container;
        }

        @Override
        public SequenceFlowController eval(SequenceFlow sequenceFlow) {
            return (SequenceFlowController)this.container.asController((FlowElement)sequenceFlow);
        }
    }

    private static class ToDrawableFlow
    implements Function<SequenceFlow, DrawableSequenceFlow> {
        private DrawableNodeContainer container;

        private ToDrawableFlow(DrawableNodeContainer container) {
            this.container = container;
        }

        @Override
        public DrawableSequenceFlow eval(SequenceFlow flowNode) {
            return (DrawableSequenceFlow)this.container.asDrawable((FlowElement)flowNode);
        }
    }
}

