/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.Domain;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerListener;
import oracle.bpm.designer.controller.ControllersHolder;
import oracle.bpm.designer.controller.Subcontroller;
import oracle.bpm.designer.selection.SelectionStatus;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerImpl<T>
implements Controller<T> {
    private final Controller container;
    private final Drawable<T> drawable;
    private boolean focus;
    private final ControllersHolder<Controller> holder;
    private final List<ControllerListener> listeners;
    private SelectionStatus selection = SelectionStatus.NONE_SELECTION;

    protected ControllerImpl(Controller container, @NotNull Drawable<T> drawable) {
        this.container = container;
        this.drawable = drawable;
        this.holder = this.createHolder();
        this.listeners = new ArrayList<ControllerListener>(3);
    }

    @Override
    @NotNull
    public final T getModelObject() {
        return (T)this.drawable.getModelObject();
    }

    @Override
    @NotNull
    public Drawable<T> getDrawableObject() {
        return this.drawable;
    }

    @Override
    @NotNull
    public Domain getDomain() {
        return this.container.getDomain();
    }

    @Override
    @NotNull
    public Controller getContainer() {
        return this.container;
    }

    @NotNull
    public ControllersHolder getHolder() {
        return this.holder;
    }

    @Override
    public String getId() {
        return this.drawable.getId();
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.DEFAULT_CURSOR;
    }

    @Override
    public void setSelection(@NotNull SelectionStatus selection) {
        if (this.selection != selection) {
            this.selection = selection;
            for (ControllerListener listener : this.listeners) {
                listener.selectedStateChanged(this);
            }
            this.getDrawableObject().setShowSelection(selection.isSelected());
        }
    }

    @Override
    public void setFocus(boolean focus) {
        if (this.focus != focus) {
            this.focus = focus;
            this.getDrawableObject().setShowFocus(focus);
        }
    }

    @Override
    @NotNull
    public SelectionStatus getSelection() {
        return this.selection;
    }

    @Override
    public boolean getFocus() {
        return this.focus;
    }

    @Override
    public void editProperties() {
    }

    @Override
    public String getTooltipMessage() {
        return null;
    }

    @Override
    public void addControllerListener(@NotNull ControllerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeControllerListener(@NotNull ControllerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void add() {
        this.getDrawableObject().add();
        this.getContainer().addChild(this);
    }

    @Override
    public void remove() {
        this.getDrawableObject().remove();
        this.getContainer().removeChild(this);
        this.listeners.clear();
    }

    @Override
    @NotNull
    public Sequence<Controller> getControllers() {
        return this.holder.getControllers();
    }

    @Override
    public boolean contains(@NotNull Controller controller) {
        return this.holder.contains(controller);
    }

    @Override
    @Nullable
    public Controller getControllerFor(@NotNull Drawable drawable) {
        return this.holder.getControllerFor(drawable);
    }

    @Override
    public void addChild(@NotNull Controller controller) {
        this.holder.add(controller);
    }

    @Override
    public void removeChild(@NotNull Controller controller) {
        this.holder.remove(controller);
    }

    @Override
    public Controller<?> findControllerAt(@NotNull Predicate<Controller> recursion, int x, int y, @Nullable Predicate<Controller> check) {
        Controller<T> result = check == null || check.check(this) ? this : null;
        DrawContext context = this.getDomain().getDrawContext();
        for (Controller inner : this.getControllersReversed()) {
            if (!inner.getDrawableObject().contains(x, y, context) || check == null || !check.check(inner)) continue;
            if (recursion.check(inner)) {
                Controller innerFound = inner.findControllerAt(recursion, x, y, check);
                result = innerFound != null ? innerFound : inner;
                break;
            }
            result = inner;
            break;
        }
        return result;
    }

    @Override
    public void refresh() {
        HashMap childrenMap = new HashMap();
        ArrayList<Controller> toBeRefreshed = new ArrayList<Controller>();
        for (Controller controller : this.getControllers()) {
            childrenMap.put(controller.getModelObject(), controller);
        }
        Iterable children = this.getDomain().getDrawableFactory().getChildren(this.getModelObject());
        for (Object t : children) {
            if (!childrenMap.containsKey(t)) {
                Controller added = this.addChildObject(t);
                toBeRefreshed.add(added);
            }
            childrenMap.remove(t);
        }
        for (Controller controller : childrenMap.values()) {
            if (controller instanceof Subcontroller) continue;
            controller.remove();
        }
        for (Controller controller : toBeRefreshed) {
            controller.refresh();
        }
        this.refreshDrawable(null);
    }

    @Override
    public void dispose() {
    }

    @NotNull
    protected Sequence<Controller> getControllersReversed() {
        return this.holder.getControllersReversed();
    }

    protected void refreshDrawable(@Nullable ProjectEvent event) {
        this.getDrawableObject().refresh(this.getDomain().getDrawContext(), event);
    }

    protected ControllersHolder<Controller> createHolder() {
        return ControllersHolder.create();
    }

    private Controller addChildObject(@NotNull Object child) {
        Drawable drawable = this.getDomain().getDrawableFactory().create(this.getDrawableObject(), child);
        Controller controller = this.getDomain().getControllerFactory().create(this, drawable);
        controller.add();
        return controller;
    }
}

