/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.Domain;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerFactory;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFactory;
import org.jetbrains.annotations.NotNull;

public class ControllerChildPopulator {
    public static void populateChild(@NotNull Controller parent, @NotNull Object child) {
        DrawableFactory drawableFactory = parent.getDomain().getDrawableFactory();
        ControllerFactory controllerFactory = parent.getDomain().getControllerFactory();
        Drawable drawable = drawableFactory.create(parent.getDrawableObject(), child);
        Controller controller = controllerFactory.create(parent, drawable);
        ControllerChildPopulator.populate(controller);
        controller.add();
    }

    public static void populate(@NotNull Controller controller) {
        Domain domain = controller.getDomain();
        DrawableFactory drawableFactory = domain.getDrawableFactory();
        ControllerFactory controllerFactory = domain.getControllerFactory();
        for (Object child : drawableFactory.getChildren(controller.getModelObject())) {
            Drawable drawableChild = drawableFactory.create(controller.getDrawableObject(), child);
            Controller childController = controllerFactory.create(controller, drawableChild);
            childController.add();
        }
    }
}

