/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerFactory;
import oracle.bpm.designer.controller.EventController;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.GatewayController;
import oracle.bpm.designer.controller.LaneController;
import oracle.bpm.designer.controller.MeasurementController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.controller.RootController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.controller.SubprocessController;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableGateway;
import oracle.bpm.draw.DrawableLane;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.draw.DrawableMeasurement;
import oracle.bpm.draw.DrawableNote;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class BpmnControllerFactory
extends ControllerFactory {
    private static BpmnControllerFactory instance;

    private BpmnControllerFactory() {
    }

    public static BpmnControllerFactory getInstance() {
        if (instance == null) {
            instance = new BpmnControllerFactory();
        }
        return instance;
    }

    @Override
    @NotNull
    public FlowElementController create(Controller container, @NotNull Drawable drawable) {
        FlowElementController<Process> result;
        if (drawable instanceof DrawableProcess) {
            result = BpmnControllerFactory.createProcess((RootController)container, (DrawableProcess)drawable);
        } else if (drawable instanceof DrawableMeasurement) {
            result = BpmnControllerFactory.createMeasurement((NodeContainerController)container, (DrawableMeasurement)drawable);
        } else if (drawable instanceof DrawableLane) {
            result = BpmnControllerFactory.createLane((NodeContainerController)container, (DrawableLane)drawable);
        } else if (drawable instanceof DrawableLaneColumn) {
            result = BpmnControllerFactory.getLaneColumnController((NodeContainerController)container, (DrawableLaneColumn)drawable);
        } else if (drawable instanceof DrawableNote) {
            result = BpmnControllerFactory.createNote((NodeContainerController)container, (DrawableNote)drawable);
        } else if (drawable instanceof DrawableSequenceFlow) {
            result = BpmnControllerFactory.createTransition((NodeContainerController)container, (DrawableSequenceFlow)drawable);
        } else if (drawable instanceof DrawableSubprocess) {
            result = BpmnControllerFactory.createSubprocess((NodeContainerController)container, drawable);
        } else if (drawable instanceof DrawableEvent) {
            result = BpmnControllerFactory.createEvent((NodeContainerController)container, (DrawableEvent)drawable);
        } else if (drawable instanceof DrawableGateway) {
            result = BpmnControllerFactory.createGateway((NodeContainerController)container, (DrawableGateway)drawable);
        } else if (drawable instanceof DrawableActivity) {
            result = BpmnControllerFactory.createActivity((NodeContainerController)container, (DrawableActivity)drawable);
        } else {
            throw new IllegalArgumentException("Drawable Controller Creation: Unknown controller for drawable: " + drawable.getClass());
        }
        return result;
    }

    @NotNull
    private static ProcessController createProcess(@NotNull RootController root, @NotNull DrawableProcess drawable) {
        return new ProcessController(root, drawable);
    }

    @NotNull
    private static SequenceFlowController createTransition(@NotNull NodeContainerController<?> container, @NotNull DrawableSequenceFlow drawable) {
        return new SequenceFlowController(container, drawable);
    }

    @NotNull
    private static NoteController createNote(@NotNull NodeContainerController<?> container, @NotNull DrawableNote drawable) {
        return new NoteController(container, drawable);
    }

    @NotNull
    private static LaneController createLane(@NotNull NodeContainerController<?> container, @NotNull DrawableLane drawable) {
        return new LaneController(container, drawable);
    }

    @NotNull
    private static FlowElementController getLaneColumnController(@NotNull NodeContainerController<?> container, @NotNull DrawableLaneColumn drawableLaneColumn) {
        LaneController laneController = (LaneController)container.asController((Drawable)drawableLaneColumn.getDrawableLane());
        return laneController.getLaneColumnController();
    }

    @NotNull
    private static MeasurementController createMeasurement(@NotNull NodeContainerController<?> container, @NotNull DrawableMeasurement drawable) {
        return new MeasurementController(container, drawable);
    }

    @NotNull
    private static ActivityController createActivity(@NotNull NodeContainerController<?> container, @NotNull DrawableActivity drawable) {
        return new ActivityController(container, drawable);
    }

    @NotNull
    private static GatewayController createGateway(@NotNull NodeContainerController<?> container, @NotNull DrawableGateway drawable) {
        return new GatewayController(container, drawable);
    }

    @NotNull
    private static EventController createEvent(@NotNull NodeContainerController<?> container, @NotNull DrawableEvent drawable) {
        return new EventController(container, drawable);
    }

    @NotNull
    private static FlowElementController createSubprocess(@NotNull NodeContainerController<?> container, @NotNull Drawable drawable) {
        FlowElementControllerImpl result = ModelUtils.isCollapsed((Subprocess)((Subprocess)drawable.getModelObject())) ? BpmnControllerFactory.createActivity(container, (DrawableActivity)drawable) : new SubprocessController(container, (DrawableSubprocess)drawable);
        return result;
    }
}

