/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.Renameable;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.subcontroller.EventDecorationSubcontroller;
import oracle.bpm.draw.ActivityTitle;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityController
extends FlowNodeControllerImpl<Activity>
implements Renameable {
    private final Function<BoundaryEvent, Controller> mapper;

    protected ActivityController(@NotNull NodeContainerController container, @NotNull DrawableActivity drawableObject) {
        super(container, drawableObject);
        EventDecorationSubcontroller.appendTo(this);
        this.mapper = new ToBoundaryControllerMapper(container);
    }

    @Override
    public String getCurrentName() {
        FlowNode node = (FlowNode)this.getModelObject();
        if (DesignerPreferences.getPreferences().getActivityTitleType() == ActivityTitle.DESC_AS_TITLE) {
            return node.getDefaultDescription();
        }
        return node.getDefaultLabel();
    }

    @Override
    public Color getForegroundColor() {
        return this.getDomain().getDrawContext().getTheme().getActivityFontColor();
    }

    @Override
    public void renameTo(String newLabel) {
        FlowNode node = (FlowNode)this.getModelObject();
        if (DesignerPreferences.getPreferences().getActivityTitleType() == ActivityTitle.DESC_AS_TITLE) {
            node.setDefaultDescription(newLabel.trim());
        } else {
            node.setDefaultLabel(newLabel);
        }
    }

    @Override
    public void setEditing(boolean editing) {
    }

    @Override
    protected void refreshDrawable(@Nullable ProjectEvent event) {
        super.refreshDrawable(event);
        for (Controller controller : this.getBoundaryControllers()) {
            controller.refresh();
        }
    }

    @NotNull
    private Sequence<Controller> getBoundaryControllers() {
        return ((Activity)this.getModelObject()).getActivityBoundaryEvents().map(this.mapper);
    }

    static class ToBoundaryControllerMapper
    implements Function<BoundaryEvent, Controller> {
        private final NodeContainerController container;

        ToBoundaryControllerMapper(@NotNull NodeContainerController container) {
            this.container = container;
        }

        @Override
        public Controller eval(@NotNull BoundaryEvent boundary) {
            FlowElementController result = null;
            if (this.container.contains((FlowElement)boundary)) {
                result = this.container.asController((FlowElement)boundary);
            }
            return result;
        }
    }
}

