/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.context;

import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;

public class ProjectObjectUI {
    public static Image getIconForObject(ProjectObjectType sourceType) {
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        Image result = null;
        switch (sourceType) {
            case ACTIVITY: {
                result = theme.getImageFor(FlowFigureUtils.fromType((BpmnType)BpmnType.USER_TASK), ImageType.MINI_ICON);
                break;
            }
            case ATTRIBUTE: {
                result = Image.create((Msg)ProjectMsg.ATTRIBUTE);
                break;
            }
            case ATTRIBUTE_GROUP: {
                result = Image.create((Msg)ProjectMsg.ATTRIBUTE_GROUP);
                break;
            }
            case CONNECTOR: {
                result = theme.getImageFor(FlowFigureUtils.fromType((BpmnType)BpmnType.THROW_INTERMEDIATE_EVENT), ImageType.ICON);
                break;
            }
            case COMPONENT: {
                result = Image.create((Msg)DesignerMsg.COMPONENT);
                break;
            }
            case MODEL: {
                result = Image.create((Msg)SchemaType.PROCESS.getMsg());
                break;
            }
            case PRESENTATION: {
                result = Image.create((Msg)DesignerMsg.PRESENTATION);
                break;
            }
            case MEASUREMENT: {
                result = theme.getImageFor(FlowFigureUtils.fromType((BpmnType)BpmnType.ABSTRACT_ACTIVITY), ImageType.ICON);
                break;
            }
            case METHOD: 
            case TRANSFORMATION_METHOD: {
                result = Image.create((Msg)DesignerMsg.CIL);
                break;
            }
            case TRANSFORMATION: 
            case TRANSFORMATION_MAPPING: {
                result = Image.create((Msg)DesignerMsg.TRANSFORMATION);
                break;
            }
            case TRANSITION: {
                result = Image.create((Msg)DesignerMsg.TREE_TRANSITION);
                break;
            }
            case BPM_OBJECT: {
                result = Image.create((Msg)BpmObjectMsg.BPM_OBJECT);
                break;
            }
            case LANE: {
                result = Image.create((Msg)DesignerMsg.ROLE);
            }
        }
        return result;
    }
}

