/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.designer.command.EnsureLaneCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.activities.PairedGatewayAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartAddActivityCommand
extends MultipleCommand {
    private final FlowNode flowNode;
    private final AddLaneAction.LaneInfo info;
    private final Point location;
    private final SequenceFlow sequenceFlow;
    static int ASSOCIATED_ACTIVITY_DISTANCE = 80;
    static int RIGHT_MARGIN = 50;

    public SmartAddActivityCommand(@NotNull FlowNode flowNode, @Nullable AddLaneAction.LaneInfo info, @NotNull Point location, @Nullable SequenceFlow sequenceFlow) {
        super(new ProjectObject[]{flowNode});
        this.info = info;
        this.sequenceFlow = sequenceFlow;
        this.flowNode = flowNode;
        this.location = location;
        this.buildMultipleCommand();
    }

    public String getName() {
        return DesignerMsg.ADD_ACTIVITY.getString();
    }

    private void buildMultipleCommand() {
        this.addCommand((Command)((Object)new EnsureLaneCommand(this.location, this.flowNode, this.info)));
        if (this.flowNode.getFeature(PairedGatewayAssociationFeature.class) != null) {
            this.addAssociatedActivity((Gateway)this.flowNode.asAnyNode(Gateway.class));
        } else if (this.flowNode.isGateway() && this.flowNode.asAnyNode(EventBasedGateway.class) != null) {
            this.addEventBasedGatewayConstruct((EventBasedGateway)this.flowNode.asAnyNode(EventBasedGateway.class), this.location);
        } else {
            this.addCommand((Command)new AddActivityCommand(this.flowNode, this.location));
            this.addInsertIntoSequenceFlowCommand(this.flowNode, null);
        }
    }

    private void addInsertIntoSequenceFlowCommand(@NotNull FlowNode origin, @Nullable FlowNode associated) {
        if (ModelUtils.canBeInsertedInATransition((FlowNode)origin) && this.sequenceFlow != null) {
            InsertActivityInTransitionCommand insertActivityInTransitionCommand = new InsertActivityInTransitionCommand(origin, associated, this.sequenceFlow);
            this.addCommand((Command)insertActivityInTransitionCommand);
        }
    }

    private void addEventBasedGatewayConstruct(@NotNull EventBasedGateway gateway, @NotNull Point location) {
        Process process = gateway.getProcess();
        NodeContainer container = gateway.getParentObject();
        CatchEvent message = container.createIntermediateCatchEvent(EventTriggerType.MESSAGE);
        message.setDefaultLabel(ModelUtils.nextLabelForActivity((NodeContainer)process, (String)message.getEventTriggerType().getString()));
        CatchEvent timer = container.createIntermediateCatchEvent(EventTriggerType.TIMER);
        timer.setDefaultLabel(ModelUtils.nextLabelForActivity((NodeContainer)process, (String)timer.getEventTriggerType().getString()));
        Point messageLocation = location.translate(ASSOCIATED_ACTIVITY_DISTANCE, 0);
        this.addCommand((Command)new AddActivityCommand((FlowNode)message, messageLocation));
        Point timerLocation = location.translate(ASSOCIATED_ACTIVITY_DISTANCE, ASSOCIATED_ACTIVITY_DISTANCE);
        this.addCommand((Command)new AddActivityCommand(this.flowNode, location));
        this.addCommand((Command)new AddActivityCommand((FlowNode)timer, timerLocation));
        this.addCommand((Command)((Object)new EnsureLaneCommand(timerLocation, (FlowNode)timer, this.info)));
        this.addCommand((Command)new AddTransitionCommand(container, (FlowNode)gateway, (FlowNode)message));
        this.addCommand((Command)new AddTransitionCommand(container, (FlowNode)gateway, (FlowNode)timer));
        this.addInsertIntoSequenceFlowCommand(this.flowNode, (FlowNode)message);
    }

    private void addAssociatedActivity(@NotNull Gateway gateway) {
        Gateway converging;
        Gateway diverging;
        PairedGatewayAssociationFeature info = (PairedGatewayAssociationFeature)gateway.getFeature(PairedGatewayAssociationFeature.class);
        Process processContent = gateway.getProcess();
        FlowFigureType pairedType = gateway.getBpmnType() != BpmnType.COMPLEX_GATEWAY ? FlowFigureUtils.fromType((BpmnType)gateway.getBpmnType()) : FlowFigureUtils.fromType((BpmnType)BpmnType.INCLUSIVE_GATEWAY);
        NodeContainer container = gateway.getParentObject();
        Gateway associated = (Gateway)FlowFigureUtils.createNodeFromFigureType((FlowFigureType)pairedType, (NodeContainer)container).asAnyNode(Gateway.class);
        if (gateway.getBpmnType() != BpmnType.COMPLEX_GATEWAY) {
            diverging = gateway;
            converging = associated;
        } else {
            diverging = associated;
            converging = gateway;
        }
        ModelUtils.setPairedAssociatedGateways((Gateway)diverging, (Gateway)converging);
        ModelUtils.setDirectionToPairedAssociatedGateways((Gateway)diverging, (Gateway)converging);
        this.addCommand((Command)new AddActivityCommand((FlowNode)diverging, this.location));
        this.addCommand((Command)new AddActivityCommand((FlowNode)converging, this.location.translate(ASSOCIATED_ACTIVITY_DISTANCE, 0)));
        this.addCommand((Command)new AddTransitionCommand(container, (FlowNode)diverging, (FlowNode)converging));
        this.addInsertIntoSequenceFlowCommand((FlowNode)diverging, (FlowNode)converging);
    }
}

