/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.beans.PropertyChangeEvent;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.cileditor.MethodTypeDescriptionHolder;
import oracle.bpm.designer.cileditor.ObjectTypeDescriptionHolder;
import oracle.bpm.designer.cileditor.SuperTypeHolder;
import oracle.bpm.designer.cileditor.TypeChooserPropertyEditor;
import oracle.bpm.designer.cileditor.TypePropertyHolder;
import oracle.bpm.designer.cileditor.TypePropertyRenderer;
import oracle.bpm.designer.cileditor.VariableHolder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.Status;

public class TypeProperty
extends AbstractProperty {
    private TypeChooserPropertyEditor editor;
    private TypeDescription typeToAvoid;
    private static TypePropertyRenderer renderer = null;

    public TypeProperty(Msg key, MethodTypeDescription value) {
        this(key, TypeProperty.getHolder(value), null, null);
    }

    public TypeProperty(Msg key, Variable value) {
        this(key, TypeProperty.getHolder(value), null, null);
    }

    public TypeProperty(Msg key, ObjectTypeDescription value) {
        this(key, TypeProperty.getHolder(value), null, null);
    }

    public TypeProperty(Msg key, MethodTypeDescription value, boolean isNew) {
        this(key, TypeProperty.getHolder(value), null, null);
        TypePropertyHolder holder = (TypePropertyHolder)this.getValue();
        holder.setNew(isNew);
    }

    public TypeProperty(Msg key, SuperType superType, TypeDescription typeToAvoid) {
        this(key, TypeProperty.getHolder(superType, typeToAvoid), typeToAvoid, null);
    }

    public TypeProperty(Msg key, Variable value, boolean isNew, ComponentCatalog catalog) {
        this(key, TypeProperty.getHolder(value), null, catalog);
        TypePropertyHolder holder = (TypePropertyHolder)this.getValue();
        holder.setNew(isNew);
    }

    public TypeProperty(Msg key, TypePropertyHolder value, TypeDescription typeToAvoid, ComponentCatalog catalog) {
        this.setKey(key);
        this.setValue(value);
        this.setPropertyRenderer(this.getRenderer());
        this.editor = this.getEditor(catalog);
        this.setPropertyEditor((PropertyEditor)this.editor);
        this.typeToAvoid = typeToAvoid;
    }

    public TypeChooserPropertyEditor getEditor(ComponentCatalog catalog) {
        return new TypeChooserPropertyEditor(this, catalog);
    }

    public void setEditorValue(Object newValue) {
        boolean isValueChange = TypeProperty.valueChange((Object)this.getOldEditorValue(), (Object)newValue);
        if (isValueChange) {
            TypePropertyHolder variable = (TypePropertyHolder)this.getValue();
            Status status = this.isValidValue(newValue);
            if (status.equals(Status.OK_STATUS())) {
                this.setStatus(Status.OK_STATUS());
                variable.setType((TypeRef)newValue);
                this.firePropertyChanged(new PropertyChangeEvent((Object)this, this.getKey(), variable, variable));
            } else {
                this.showError(status, newValue);
            }
        }
    }

    protected final TypePropertyRenderer getRenderer() {
        if (renderer == null) {
            renderer = new TypePropertyRenderer();
        }
        return renderer;
    }

    protected Object getOldEditorValue() {
        TypePropertyHolder variable = (TypePropertyHolder)this.getValue();
        return variable.getType();
    }

    protected Status isValidValue(Object newValue) {
        Status status = Status.OK_STATUS();
        TypeRef newType = (TypeRef)newValue;
        TypesFilter selectionFilter = this.editor.getSelectionFilter();
        if (selectionFilter != null && !selectionFilter.isValid(newType)) {
            status = Status.ERROR_STATUS((Msg)DesignerMsg.INVALID_TYPE(newType.getText()));
        } else if (newType.equals(this.typeToAvoid)) {
            status = Status.ERROR_STATUS((Msg)DesignerMsg.RECURSIVE_DELEGATION_ERROR);
        }
        return status;
    }

    static String renderedType(TypeRef type, int flags) {
        TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
        return renderer.render(type, flags);
    }

    private static TypePropertyHolder getHolder(MethodTypeDescription method) {
        return new MethodTypeDescriptionHolder(method);
    }

    private static TypePropertyHolder getHolder(Variable var) {
        return new VariableHolder(var);
    }

    private static ObjectTypeDescriptionHolder getHolder(ObjectTypeDescription objet) {
        return new ObjectTypeDescriptionHolder(objet);
    }

    private static SuperTypeHolder getHolder(SuperType var, TypeDescription typeToAvoid) {
        return new SuperTypeHolder(var, typeToAvoid);
    }
}

