/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.cileditor.LocalVariableProperty;
import oracle.bpm.designer.cileditor.SuperTypeHolder;
import oracle.bpm.designer.cileditor.TypeProperty;
import oracle.bpm.designer.cileditor.TypePropertyHolder;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.AbstractEditor;

public class TypeChooserPropertyEditor
extends AbstractEditor {
    private ComponentCatalog catalog;
    private TypeChooserPanel chooserPanel;
    private TypeProperty typeProperty;

    public TypeChooserPropertyEditor(TypeProperty typeProperty, ComponentCatalog catalog) {
        this.catalog = catalog;
        this.typeProperty = typeProperty;
    }

    public ComponentCatalog getCatalog() {
        return this.catalog;
    }

    public Object getCellEditorValue() {
        return this.chooserPanel.getEnsuredSelectedItem();
    }

    public UiComponent getEditor(UiContainer parent) {
        return this.createEditor(parent);
    }

    protected Panel createEditor(UiContainer parent) {
        this.chooserPanel = TypeChooserPanel.create(parent, this.getComponentCatalog(), this.isMethod(), this.getOptions(), this.getTypesFilter(), this.getSelectionFilter());
        Property property = this.getProperty();
        TypePropertyHolder variable = (TypePropertyHolder)property.getValue();
        if (variable != null) {
            this.chooserPanel.setInitialType(CatalogTypeImpl.get((TypeRef)variable.getType()), true);
        }
        this.chooserPanel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TypeChooserPropertyEditor.this.typeProperty.updateValue(TypeChooserPropertyEditor.this.getCellEditorValue());
            }
        });
        this.chooserPanel.addTypedItemListener(new MyEnsuredItemListener());
        return this.chooserPanel;
    }

    protected int getOptions() {
        return 3;
    }

    protected TypesFilter getSelectionFilter() {
        return null;
    }

    protected MutableComponentCatalog getTypeRepository(TypeRef ref) {
        return (MutableComponentCatalog)ref.getCatalog();
    }

    protected TypesFilter getTypesFilter() {
        return null;
    }

    protected boolean isMethod() {
        return false;
    }

    protected ComponentCatalog getComponentCatalog() {
        if (this.catalog == null) {
            Object parentValue;
            AbstractProperty parentProperty = ((AbstractProperty)this.getProperty()).getParent();
            if (parentProperty != null && (parentValue = parentProperty.getValue()) instanceof ProjectObject) {
                ProjectObject projectObject = (ProjectObject)parentValue;
                this.catalog = projectObject.getProject().getComponentCatalog();
            }
            if (this.catalog == null) {
                TypeDescription parent;
                TypePropertyHolder variable = (TypePropertyHolder)this.getProperty().getValue();
                FuegoProject project = FuegoProject.getFrom((TypeRef)variable.getType());
                if (project == null && this.typeProperty.getParent() instanceof LocalVariableProperty) {
                    LocalVariableProperty localVariableProperty = (LocalVariableProperty)this.typeProperty.getParent();
                    project = FuegoProject.getFrom((TypeRef)localVariableProperty.getMethod());
                }
                this.catalog = project != null ? project.getComponentCatalog() : (variable instanceof SuperTypeHolder ? ((SuperTypeHolder)variable).getParent().getCatalog() : ((parent = variable.getContextParent()) != null ? parent.getCatalog() : this.getTypeRepository(variable.getType())));
            }
        }
        return this.catalog;
    }

    private class MyEnsuredItemListener
    implements TypeChooserPanel.EnsuredItemListener<CatalogType> {
        private MyEnsuredItemListener() {
        }

        @Override
        public void itemStateChanged(TypeChooserPanel.EnsuredItemEvent<CatalogType> event) {
            TypeChooserPropertyEditor.this.typeProperty.updateValue(TypeChooserPropertyEditor.this.getCellEditorValue());
        }
    }
}

