/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.beans.PropertyChangeListener;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.EditorFactory;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyRenderer;

public class PredefinedVariableProperty
extends PropertyGroup {
    private AbstractProperty desc;
    private AbstractProperty name;
    private AbstractProperty type;
    private static PredefinedVariablePropertyRenderer renderer = new PredefinedVariablePropertyRenderer();

    public PredefinedVariableProperty(String key, MethodTypeDescription variable) {
        super(key);
        this.setValue(variable);
        TypeRenderer typeRenderer = EditorPreferences.getInstance().getTypeRenderer();
        this.name = Factory.createText((Msg)ProjectDrawMsg.NAME, (String)variable.getName());
        this.type = Factory.createText((Msg)CoreMsg.TYPE, (String)typeRenderer.render((TypeRef)variable.getResultType()));
        this.desc = Factory.createLongText((Msg)DesignerMsg.DESCRIPTION, (String)"");
        this.name.setEditable(false);
        this.type.setEditable(false);
        this.desc.setEditable(false);
        this.setPropertyRenderer(renderer);
        this.setPropertyEditor(EditorFactory.TEXT_EDITOR);
        this.type.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.desc.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    private static class PredefinedVariablePropertyRenderer
    implements PropertyRenderer {
        private PredefinedVariablePropertyRenderer() {
        }

        public String getRenderer(Property property) {
            return PredefinedVariablePropertyRenderer.renderProperty(property);
        }

        public String getToolTip(Property property) {
            return PredefinedVariablePropertyRenderer.renderProperty(property);
        }

        private static String renderProperty(Property property) {
            MethodTypeDescription var = (MethodTypeDescription)property.getValue();
            if (var != null) {
                TypeRenderer renderer = EditorPreferences.getInstance().getTypeRenderer();
                return renderer.render((TypeRef)var.getResultType());
            }
            return null;
        }
    }
}

