/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.geom.Insets;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

class ExpressionEditor
extends Dialog
implements DocumentListener {
    private Button cancelButton;
    private List<ValueReference> elements;
    private List<TextField> exprFields;
    private boolean ok;
    private Button okButton;
    private List<Object> values;
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";

    public ExpressionEditor(List labels, List<ValueReference> elements) {
        super(Ui.getRoot(), true);
        assert (labels.size() == elements.size());
        this.elements = elements;
        this.values = new ArrayList<Object>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            this.values.add(null);
        }
        this.ok = false;
        this.setTitle(EditorMsg.FBL_EXPRESSION.getString());
        this.getContentPane().setLayout((Layout)new BorderLayout());
        Panel fieldsPanel = new Panel(this.getContentPane());
        fieldsPanel.setLayout((Layout)new GridBagLayout());
        KeyListener keyLis = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.isEscape()) {
                    ExpressionEditor.this.setVisible(false);
                } else if (e.isEnter() && ExpressionEditor.this.okButton.isEnabled()) {
                    ExpressionEditor.this.okButton.doClick();
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        };
        this.exprFields = new ArrayList<TextField>();
        LanguageSpec langSpec = EditorPreferences.getInstance().getLanguageSpec();
        TypeRenderer renderer = langSpec.getTypeRenderer();
        for (int i = 0; i < labels.size(); ++i) {
            ValueReference ref = elements.get(i);
            Label label = Label.create((UiContainer)fieldsPanel, (Msg)Msg.QUOTE(labels.get(i).toString() + " (the type must be " + renderer.render((TypeRef)ref.getType()) + ")"));
            TextField expr = new TextField((UiContainer)fieldsPanel, this.dump(ref.get()), 25);
            expr.addKeyListener(keyLis);
            expr.addDocumentListener((DocumentListener)this);
            this.exprFields.add(expr);
            fieldsPanel.add((UiComponent)label, (Object)ExpressionEditor.getFldConstraints(0, i * 2));
            fieldsPanel.add((UiComponent)expr, (Object)ExpressionEditor.getFldConstraints(0, i * 2 + 1));
        }
        Border space = BorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
        fieldsPanel.setBorder(BorderFactory.createCompoundBorder((Border)BorderFactory.createEtchedBorder(), (Border)space));
        this.getContentPane().add((UiComponent)fieldsPanel, (Object)"Center");
        Panel buttonPanel = new Panel(this.getContentPane());
        buttonPanel.setLayout((Layout)new GridLayout(5, 1));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder((Border)BorderFactory.createEtchedBorder(), (Border)space));
        buttonPanel.setBorder(space);
        this.okButton = this.buildButton((UiContainer)buttonPanel, "Continue", OK, false);
        this.cancelButton = this.buildButton((UiContainer)buttonPanel, "Cancel", CANCEL, true);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionEditor.this.checkExpressions();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionEditor.this.setVisible(false);
            }
        });
        buttonPanel.add(Box.createGlue((UiContainer)buttonPanel));
        buttonPanel.add((UiComponent)this.okButton);
        buttonPanel.add(Box.createGlue((UiContainer)buttonPanel));
        buttonPanel.add((UiComponent)this.cancelButton);
        buttonPanel.add(Box.createGlue((UiContainer)buttonPanel));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder((Border)BorderFactory.createEtchedBorder(), (Border)space));
        this.getContentPane().add((UiComponent)buttonPanel, (Object)"East");
        this.pack();
        this.addKeyListener(keyLis);
        this.checkButtons();
    }

    public boolean isOk() {
        return this.ok;
    }

    public void changedUpdate(DocumentEvent e) {
        this.checkButtons();
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkButtons();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkButtons();
    }

    private static GridBagConstraints getFldConstraints(int gridx, int gridy) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 0;
        constr.anchor = 17;
        constr.insets = new Insets(8, 10, 8, 10);
        return constr;
    }

    private Button buildButton(UiContainer parent, String text, String command, boolean enabled) {
        Button button = new Button(parent, UIMsg.TO_MSG((String)text));
        button.setEnabled(enabled);
        return button;
    }

    private void checkButtons() {
        for (TextField field : this.exprFields) {
            if (!field.getText().equals("")) continue;
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    private void checkExpressions() {
        try {
            int i;
            for (i = 0; i < this.elements.size(); ++i) {
                String text = this.exprFields.get(i).getText();
                TypeDescription type = this.elements.get(i).getType();
                FuegoCompiler compiler = new FuegoCompiler();
                this.values.set(i, compiler.evaluate(SourceCode.create(text, "Fuego"), type));
            }
            for (i = 0; i < this.values.size(); ++i) {
                ValueReference ref = this.elements.get(i);
                ref.set(this.values.get(i));
            }
            this.ok = true;
            this.setVisible(false);
        }
        catch (CompilerException e) {
            MessageDialog.showError((Msg)UIMsg.TO_MSG((String)("Invalid Expression [" + ((Object)((Object)e)).getClass().getName() + "]")), (Throwable)e);
        }
    }

    private String dump(Object value) {
        return FuegoCILSourceGenerator.generateCILForValue((Object)value);
    }
}

