/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.util.ArrayList;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExecutionInterruptedException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.IgnoreStepException;
import oracle.bpm.compiler.InvalidIndexException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.NullReferenceException;
import oracle.bpm.compiler.RetryStepException;
import oracle.bpm.compiler.RuntimeCompilationException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.cileditor.ExpressionEditor;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.Latch;

public class ExceptionHandler
implements CodeDebugger.ExceptionHandler {
    private ExecutionException lastException;

    public ExceptionHandler(UiComponent parent) {
    }

    public void handleException(final ExecutionException e) throws ExecutionException {
        final Latch waitingException = new Latch();
        try {
            UiUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ExceptionHandler.this.handleExecutionException(e);
                    }
                    catch (ExecutionException ee) {
                        waitingException.put((Object)ee);
                    }
                }
            });
        }
        catch (Exception TODO) {
            TODO.printStackTrace();
        }
        if (!waitingException.isEmpty()) {
            throw (ExecutionException)((Object)waitingException.get());
        }
    }

    private void cilExited() {
        MessageDialog.showNotice((Msg)UIMsg.TO_MSG((String)"CIL Debugger"), (Msg)UIMsg.TO_MSG((String)"CIL Exited"));
    }

    private void compilationFailed(RuntimeCompilationException e) {
        MessageDialog.showNotice((Msg)UIMsg.TO_MSG((String)"CIL Debugger"), (Msg)UIMsg.TO_MSG((String)e.getMessage()), (Throwable)e);
    }

    private void fixException(ExecutionException e) {
        block6: {
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<ValueReference> elements = new ArrayList<ValueReference>();
            if (e instanceof NullReferenceException) {
                labels.add("Value");
                elements.add(((NullReferenceException)e).getValueRef());
            } else if (e instanceof InvalidIndexException) {
                InvalidIndexException iie = (InvalidIndexException)e;
                labels.add("Array");
                labels.add("Index value");
                elements.add(iie.getArrayReference());
                elements.add(iie.getIndexReference());
            } else {
                return;
            }
            try {
                ExpressionEditor editor = new ExpressionEditor(labels, elements);
                editor.setVisible(true);
            }
            catch (Throwable t) {
                if (!Log.isDebugging()) break block6;
                Log.logDebug(t);
            }
        }
    }

    private void handleExecutionException(ExecutionException e) throws ExecutionException {
        if (e == this.lastException) {
            return;
        }
        if (Log.isDebugging()) {
            Log.logDebug(e);
        }
        this.lastException = e;
        if (e instanceof ExecutionInterruptedException) {
            return;
        }
        if (e instanceof ExitException) {
            this.cilExited();
            return;
        }
        if (e instanceof RuntimeCompilationException) {
            this.compilationFailed((RuntimeCompilationException)e);
            return;
        }
        Msg[] options = null;
        Throwable real = e;
        if (e.isRecoverable()) {
            options = new Msg[]{EditorMsg.THROW, EditorMsg.IGNORE, EditorMsg.ABORT, EditorMsg.RETRY, EditorMsg.SHOW_DETAILS, EditorMsg.FIX};
        } else {
            options = new Msg[]{EditorMsg.THROW, EditorMsg.IGNORE, EditorMsg.ABORT, EditorMsg.RETRY, EditorMsg.SHOW_DETAILS};
            while ((real instanceof CompilerExceptionShell || !(real instanceof CompilerException)) && real.getCause() != null) {
                real = real.getCause();
            }
        }
        StringBuffer header = new StringBuffer();
        int count = 0;
        LanguageSpec languageSpec = EditorPreferences.getInstance().getLanguageSpec();
        TypeRenderer renderer = languageSpec.getTypeRenderer();
        header.append(EditorMsg.ERROR_AT((String)String.valueOf(e.getLine()), (String)String.valueOf(e.getColumn()), (String)e.getMemberName()).getString() + "\n\n");
        String detail = real.getMessage();
        header.append(EditorMsg.EXECUTION_SEQ.getString() + "\n");
        for (MethodTypeDescription mtd : e.getMethods()) {
            if (!mtd.isSynthesized()) {
                header.append("     " + EditorMsg.AT.getString() + " ");
                header.append(renderer.render((TypeRef)mtd.getParent()) + "." + renderer.render((TypeRef)mtd));
                header.append("\n");
                ++count;
            }
            if (count != 10) continue;
            header.append("     " + EditorMsg.AT.getString() + " ");
            header.append("...");
            break;
        }
        header.append("\n");
        int CONTINUE = -2;
        int selected = -2;
        while (selected == -2) {
            Panel panel = new Panel((UiContainer)Ui.getRoot());
            panel.setLayout((Layout)new BorderLayout());
            panel.add((UiComponent)new LabelMultiline((UiContainer)panel, UIMsg.TO_MSG((String)header.toString())), (Object)"North");
            Panel detailPanel = new Panel((UiContainer)panel, EditorMsg.DETAILS);
            TextArea detailArea = new TextArea((UiContainer)detailPanel);
            detailArea.setText(detail);
            detailArea.setEditable(false);
            detailArea.setPreferredSize(Dimension.valueOf(200, 300));
            detailPanel.add((UiComponent)detailArea);
            panel.add((UiComponent)detailPanel, (Object)"Center");
            selected = MessageDialog.showQuestion((Msg)EditorMsg.ERROR, (Msg)UIMsg.TO_MSG((String)e.getMessage()), null, (Msg[])options, (int)0, null);
            if (selected == -1 || selected == 0) {
                throw e;
            }
            if (selected == 1) {
                throw IgnoreStepException.instance;
            }
            if (selected == 2) {
                throw new ExecutionInterruptedException(e.getLine(), e.getColumn());
            }
            if (selected == 3) {
                throw RetryStepException.instance;
            }
            if (selected == 4) {
                MessageDialog.showError((Msg)UIMsg.TO_MSG((String)ExceptionFormatter.fullTechLevel(real)), (Throwable)real);
                selected = -2;
                continue;
            }
            if (selected == 5) {
                this.fixException(e);
                continue;
            }
            throw new IllegalStateException(String.valueOf(selected));
        }
    }
}

