/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import javax.swing.DefaultListModel;
import javax.swing.Icon;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.CodeFixHandler;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CompositeIcon;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.util.FixOption;

public class ErrorList
extends List
implements ListSelectionListener,
MessageListener,
FocusListener,
CodeDebugger.ErrorListener {
    private CodeEditor codeEditor;
    private CodeFixHandler handler_d;
    private boolean isOk;
    private DefaultListModel listModel;
    private boolean reportStopped = false;

    public ErrorList(UiContainer parent) {
        this(parent, null);
    }

    public ErrorList(UiContainer parent, CodeEditor textComponent) {
        this(parent, textComponent, null);
    }

    public ErrorList(UiContainer parent, CodeEditor codeEditor, CodeFixHandler handler) {
        super(parent, ListSelectionMode.SINGLE_SELECTION);
        this.codeEditor = codeEditor;
        this.handler_d = handler;
        this.isOk = true;
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.setLabelProvider((LabelProvider)new CompilationErrorLabelProvider());
        this.addListSelectionListener(this);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (MouseEventUtilities.isPopupTrigger((MouseEvent)e)) {
                    ErrorList.this.buildPopup(e);
                }
            }
        });
        this.addFocusListener(this);
    }

    public Dimension getMinimumSize() {
        return Dimension.ZERO;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setScope(int firstLine, int lastLine) {
        this.reportStopped = false;
    }

    public void clear() {
        this.isOk = true;
        this.listModel.clear();
        this.codeEditor.updateCompilationStatus();
    }

    public void focusGained(FocusEvent e) {
        if (this.getSelectedIndex() != -1) {
            MessageEntry entry = (MessageEntry)((Object)this.getSelectedValue());
            this.codeEditor.selectLine(entry.line);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    public void reportError(CilException exception) {
        this.reportMessage(exception);
        this.codeEditor.addError(exception);
    }

    public void reportException(ExecutionException e) {
        this.reportError((CilException)e);
    }

    @Override
    public void reportWarning(CilException e) {
        this.codeEditor.addWarning(e);
        MessageEntry entry = new MessageEntry((UiContainer)this, e);
        entry.method = e.getMemberName();
        entry.msg = e.getMessage();
        entry.col = e.getColumn();
        entry.line = e.getLine();
        entry.isError = false;
        this.listModel.addElement(entry);
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        MessageEntry entry;
        if (!e.getValueIsAdjusting() && this.getSelectedIndex() != -1) {
            entry = (MessageEntry)((Object)this.getSelectedValue());
            this.codeEditor.selectLine(entry.line);
        }
        if (this.getSelectedIndex() != -1) {
            entry = (MessageEntry)((Object)this.getSelectedValue());
            this.codeEditor.selectLine(entry.line);
        }
    }

    private void buildPopup(MouseEvent e) {
        MessageEntry entry;
        PopupMenu menu = new PopupMenu();
        if (this.getSelectedIndex() != -1 && (entry = (MessageEntry)((Object)this.getSelectedValue())).cilEx_d.isFixable()) {
            FixOption[] options = entry.cilEx_d.getFixOptions();
            for (int i = 0; i < options.length; ++i) {
                FixOption option = options[i];
                FixAction fixAction = new FixAction(entry, option);
                MenuItem item = menu.add((BaseAction)fixAction);
                item.setText(option.getDescription());
            }
        }
        if (menu.getComponentCount() > 0) {
            menu.show((UiComponent)this, e.getX(), e.getY());
        }
    }

    private void reportMessage(CilException e) {
        this.isOk = false;
        if (this.reportStopped) {
            return;
        }
        int line = e.getLine();
        int col = e.getColumn();
        String msg = e.getMessage();
        MessageEntry entry = new MessageEntry((UiContainer)this, e);
        entry.method = e.getMemberName();
        entry.msg = msg != null ? msg : "";
        entry.col = col;
        entry.line = line;
        entry.isError = true;
        this.listModel.addElement(entry);
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
    }

    private class FixAction
    extends BaseAction {
        private MessageEntry entry;
        private FixOption fixOption;
        static final long serialVersionUID = -6405459196115786517L;
        static final long serialCheck = 1449415714396557209L;

        public FixAction(MessageEntry entry, FixOption fixOption) {
            super(EditorMsg.FIX);
            this.entry = entry;
            this.fixOption = fixOption;
        }

        public void run() {
            try {
                this.fixOption.fix();
                if (ErrorList.this.handler_d != null) {
                    if (this.fixOption.getType() == null) {
                        this.fixOption.setType(this.entry.cilEx_d.getMember().asMethod());
                    }
                    ErrorList.this.handler_d.fix(this.fixOption);
                    ErrorList.this.listModel.removeElement((Object)this.entry);
                    System.out.println("Fixed");
                }
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private class CompilationErrorLabelProvider
    extends LabelProvider.Default {
        private CompilationErrorLabelProvider() {
        }

        public Image getIcon(Object element) {
            MessageEntry entry = (MessageEntry)((Object)element);
            Image icon = Image.create((Msg)EditorMsg.BALL_YELLOW);
            if (entry.isError) {
                icon = Image.create((Msg)EditorMsg.BALL_RED);
            }
            if (entry.cilEx_d.isFixable()) {
                icon = Image.create((Icon)new CompositeIcon(icon, Image.create((Msg)EditorMsg.BULB), 4));
                ErrorList.this.setToolTipText(EditorMsg.FIX.getString());
            }
            return icon;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    private static class MessageEntry
    extends Label {
        int col;
        boolean isError;
        int line;
        String method;
        String msg;
        private CilException cilEx_d;

        public MessageEntry(UiContainer parent, CilException cilEx) {
            super(parent);
            this.cilEx_d = cilEx;
        }

        public String toString() {
            String typeStr = this.isError ? "[" + EditorMsg.ERROR.getString() + "] " : "[" + CoreMsg.WARNING.getString() + "] ";
            String lineStr = EditorMsg.LINE.getString() + ": " + this.line + " " + EditorMsg.COLUMN.getString() + ": " + this.col + " : ";
            this.setText(typeStr + (this.line > 0 ? lineStr : "") + this.msg);
            return this.getText();
        }
    }
}

