/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.designer.cileditor.BreakPointList;
import oracle.bpm.designer.cileditor.DebuggerPropertiesPanel;
import oracle.bpm.designer.cileditor.StackTraceList;
import oracle.bpm.designer.cileditor.WatchList;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class DebuggerPane
extends Panel {
    private BreakPointList breakPointList;
    private ToolBar historyToolBar;
    private DebuggerPropertiesPanel propertiesPanel;
    private ToolBar runToolBar;
    private StackTraceList stackTraceList;
    private WatchList watchList;

    public DebuggerPane(UiContainer parent, Process process) {
        super(parent);
        this.setLayout((Layout)new BorderLayout());
        TabbedPane stackPane = new TabbedPane((UiContainer)this, 1);
        this.stackTraceList = new StackTraceList((UiContainer)stackPane);
        stackPane.addTab(EditorMsg.EXECUTION_STACK.getString(), Image.create((Msg)EditorMsg.EXECUTION_STACK), (UiComponent)this.stackTraceList);
        this.breakPointList = new BreakPointList((UiContainer)this);
        this.watchList = new WatchList(null);
        if (process != null) {
            this.propertiesPanel = new DebuggerPropertiesPanel(parent, process);
        }
        TabbedPane tabbedPane = this.buildTabbedPane(null);
        SplitPane splitPane = new SplitPane((UiContainer)this, 1, (UiComponent)stackPane, (UiComponent)tabbedPane);
        this.add((UiComponent)splitPane, "Center");
        Panel toolBarPanel = this.createToolBarPanel((UiContainer)this);
        this.add((UiComponent)toolBarPanel, "West");
    }

    public BreakPointList getBreakPointList() {
        return this.breakPointList;
    }

    public ToolBar getHistoryToolBar() {
        return this.historyToolBar;
    }

    public ToolBar getRunToolBar() {
        return this.runToolBar;
    }

    public StackTraceList getStackTraceList() {
        return this.stackTraceList;
    }

    public String getActivity() {
        return this.propertiesPanel.getActivity();
    }

    public String getParticipant() {
        return this.propertiesPanel.getParticipant();
    }

    public void register(CodeDebugger debugger) {
        debugger.setStackTraceList((CodeDebugger.StackTraceList)this.stackTraceList);
        this.watchList.setDebugger(debugger);
        this.breakPointList.setDebugger(debugger);
    }

    private TabbedPane buildTabbedPane(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent, 1);
        tabbedPane.addTab(EditorMsg.WATCHLIST.getString(), Image.create((Msg)EditorMsg.WATCHLIST), (UiComponent)this.watchList);
        tabbedPane.addTab(EditorMsg.BREAKPOINTS.getString(), Image.create((Msg)EditorMsg.BREAKPOINTS), (UiComponent)this.breakPointList);
        if (this.propertiesPanel != null) {
            tabbedPane.addTab(LibMsg.PROPERTIES, (UiComponent)this.propertiesPanel);
        }
        return tabbedPane;
    }

    private ToolBar buildToolBar(UiContainer parent) {
        return new ToolBar(parent, ToolBar.VERTICAL);
    }

    private Panel createToolBarPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel toolBarPanel = new Panel(parent);
        toolBarPanel.setLayout((Layout)layout);
        this.runToolBar = this.buildToolBar((UiContainer)toolBarPanel);
        this.historyToolBar = this.buildToolBar((UiContainer)toolBarPanel);
        toolBarPanel.add((UiComponent)this.runToolBar, (Object)"runToolBar");
        toolBarPanel.add((UiComponent)this.historyToolBar, (Object)"historyToolBar");
        layout.addConstraint("runToolBar", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("runToolBar", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("runToolBar", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("historyToolBar", AttributeType.TOP, (Constraint)new AttributeConstraint("runToolBar", AttributeType.TOP));
        layout.addConstraint("historyToolBar", AttributeType.LEFT, (Constraint)new AttributeConstraint("runToolBar", AttributeType.RIGHT));
        layout.addConstraint("historyToolBar", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("runToolBar", AttributeType.BOTTOM));
        return toolBarPanel;
    }
}

