/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import javax.swing.DefaultListModel;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.ConditionalBreakPoint;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LineBreakPoint;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.PopupListener;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseListener;

public class BreakPointList
extends List<BreakPoint>
implements ListSelectionListener,
FocusListener,
CodeDebugger.BreakPointHandler {
    private CodeDebugger debugger;
    private DefaultListModel listModel = new DefaultListModel();
    private BaseAction removeBreakPoints_d;

    public BreakPointList(UiContainer parent) {
        super(parent, ListSelectionMode.SINGLE_INTERVAL_SELECTION);
        this.setModel(this.listModel);
        this.addListSelectionListener(this);
        this.addFocusListener(this);
        this.buildPopup();
    }

    public void setDebugger(CodeDebugger debugger) {
        debugger.setBreakPointHandler((CodeDebugger.BreakPointHandler)this);
        this.debugger = debugger;
    }

    public Dimension getMinimumSize() {
        return Dimension.ZERO;
    }

    public void clear() {
        this.listModel.clear();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void handleBreakPoint(final BreakPoint bp) throws ExecutionException {
        try {
            UiUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    BreakPointList.this.reportBreakPoint(bp);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllBreakPoints() {
        int length = this.listModel.getSize();
        for (int i = 0; i < length; ++i) {
            BreakPoint bp = (BreakPoint)this.listModel.elementAt(i);
            this.debugger.removeBreakPoint(bp);
        }
        this.listModel.removeAllElements();
    }

    public void removeBreakPoint(BreakPoint bp) {
        this.listModel.removeElement(bp);
        this.debugger.removeBreakPoint(bp);
    }

    public void toggleLineBreakPoint(int codeLine) {
        LineBreakPoint lbp = new LineBreakPoint(null, null, codeLine);
        LineBreakPoint old = this.debugger.toggleLineBreakPoint(lbp);
        if (old == null) {
            this.listModel.addElement(lbp);
            this.setSelectedIndex(this.listModel.getSize() - 1);
        } else {
            this.listModel.removeElement(old);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        BreakPoint bp;
        if (this.getSelectedIndex() == -1 || (bp = (BreakPoint)this.getSelectedValue()) instanceof LineBreakPoint) {
            // empty if block
        }
    }

    private void add() {
        String expression = MessageDialog.showInput((UiWindow)this.getOwnerWindow(), (Msg)EditorMsg.BREAKPOINT, (Msg)EditorMsg.BREAKPOINT_EXP);
        if (expression != null && !expression.equals("")) {
            try {
                ConditionalBreakPoint bp = new ConditionalBreakPoint(expression);
                this.addBreakPoint((BreakPoint)bp);
                if (!this.removeBreakPoints_d.isEnabled()) {
                    this.removeBreakPoints_d.setEnabled(true);
                }
            }
            catch (CompilerParserException e) {
                MessageDialog.showError((Msg)EditorMsg.INVALID_EXPRESSION, (Msg)EditorMsg.INVALID_EXP((String)e.getMessage()));
            }
            catch (InvalidLanguageException e) {
                MessageDialog.showError((Msg)EditorMsg.INVALID_EXPRESSION, (Msg)EditorMsg.INVALID_EXP((String)e.getMessage()));
            }
        }
    }

    private void addBreakPoint(BreakPoint bp) throws CompilerParserException, InvalidLanguageException {
        this.debugger.addBreakPoint(bp);
        this.listModel.addElement(bp);
        this.setSelectedIndex(this.listModel.getSize() - 1);
    }

    private void buildPopup() {
        PopupMenu popup = new PopupMenu();
        popup.add((BaseAction)new AddBreakPointAction());
        this.removeBreakPoints_d = new RemoveBreakPointAction();
        this.removeBreakPoints_d.setEnabled(false);
        popup.add(this.removeBreakPoints_d);
        this.addMouseListener((MouseListener)new PopupListener(popup));
    }

    private void removeSelected() {
        for (BreakPoint bp : this.getSelectedValues()) {
            this.removeBreakPoint(bp);
        }
        if (this.listModel.getSize() == 0) {
            this.removeBreakPoints_d.setEnabled(false);
        }
    }

    private void reportBreakPoint(BreakPoint bp) {
        MessageDialog.showNotice((Msg)EditorMsg.BREAKPOINT, (Msg)EditorMsg.A_BREAKPOINT((String)String.valueOf(bp)));
    }

    private class RemoveBreakPointAction
    extends BaseAction {
        static final long serialVersionUID = -6590026185948630823L;
        static final long serialCheck = 8122004251385910397L;

        RemoveBreakPointAction() {
            super(EditorMsg.REMOVE_BREAKPOINT);
        }

        public void run() {
            BreakPointList.this.removeSelected();
        }
    }

    private class AddBreakPointAction
    extends BaseAction {
        static final long serialVersionUID = -5833996514274504868L;
        static final long serialCheck = 672204195124746277L;

        AddBreakPointAction() {
            super(EditorMsg.ADD_COND_BREAKPOINT);
        }

        public void run() {
            BreakPointList.this.add();
        }
    }
}

