/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.cileditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.formatters.AbstractFormatter;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.formatters.FormatterFactory;
import oracle.bpm.designer.cileditor.LocalVariableProperty;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.InvalidPropertyType;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.ResetableProperty;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.DefaultPropertyRenderer;
import oracle.bpm.ui.prop.impl.ResetPropertyEditor;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;
import oracle.bpm.xobject.runtime.ConversionUtilities;

public class ArgumentVariableProperty
extends LocalVariableProperty {
    private AbstractProperty defaultValue;
    private AbstractProperty inOut;

    public ArgumentVariableProperty(String key, Argument variable, MethodTypeDescription method, ComponentCatalog catalog) {
        this(key, variable, method, false, catalog);
    }

    public ArgumentVariableProperty(String key, Argument variable, MethodTypeDescription method, boolean useDefaultValue, ComponentCatalog catalog) {
        this(key, variable, method, true, false, useDefaultValue, catalog);
    }

    public ArgumentVariableProperty(String name, CatalogArgument arg, MethodTypeDescription method, boolean useDefaultValue, ComponentCatalog componentCatalog) {
        super(name, new Argument(arg.getName(), arg.getType().getDynamicRef(), 3L), method);
    }

    public ArgumentVariableProperty(String key, Argument variable, MethodTypeDescription method, boolean canBeJustIn, boolean isNew, ComponentCatalog catalog) {
        this(key, variable, method, canBeJustIn, isNew, false, catalog);
    }

    public ArgumentVariableProperty(String key, Argument variable, MethodTypeDescription method, boolean canBeJustIn, boolean isNew, boolean useDefaultValue, ComponentCatalog catalog) {
        super(key, variable, method, isNew, catalog);
        Vector<String> poss = new Vector<String>();
        if (canBeJustIn) {
            poss.add("in");
        }
        poss.add("out");
        poss.add("in/out");
        int pos = poss.indexOf("in/out");
        if (canBeJustIn && variable.isIn()) {
            if (!variable.isOut()) {
                pos = poss.indexOf("in");
            }
        } else if (variable.isOut()) {
            pos = poss.indexOf("out");
            if (variable.isIn()) {
                pos = poss.indexOf("in/out");
            }
        }
        this.inOut = Factory.createCombo((Msg)DesignerMsg.MODE, poss, (int)pos);
        this.add((Property)this.inOut);
        this.inOut.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        if (useDefaultValue) {
            this.defaultValue = new DefaultValueProperty(variable);
            this.add((Property)this.defaultValue);
            this.defaultValue.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.defaultValue.setEditable(ArgumentVariableProperty.canHaveDefaultValue(variable.getType()));
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        if (this.inOut != null) {
            this.inOut.setEditable(b);
        }
        if (this.defaultValue != null) {
            this.defaultValue.setEditable(b);
        }
    }

    public void setInOutEnabled(boolean b) {
        if (this.inOut != null) {
            this.inOut.setEditable(b);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property p;
        if (evt.getSource() == this.inOut) {
            Argument argument = (Argument)this.getValue();
            String varIsInOut = evt.getNewValue().toString();
            boolean isIn = varIsInOut.indexOf("in") >= 0;
            boolean isOut = varIsInOut.indexOf("out") >= 0;
            argument.setIn(isIn);
            argument.setOut(isOut);
        } else if (evt.getSource() instanceof DefaultValueProperty) {
            DefaultValueProperty defaultValueProperty = (DefaultValueProperty)((Object)evt.getSource());
            Argument argument = (Argument)this.getValue();
            argument.setDefaultValue((String)defaultValueProperty.getValue());
        } else if (evt.getSource() instanceof Property && CoreMsg.TYPE.equals((p = (Property)evt.getSource()).getMsg())) {
            Argument argument = (Argument)this.getValue();
            argument.setDefaultValue(null);
            if (this.defaultValue != null) {
                this.defaultValue.valueChanged();
                this.defaultValue.setEditable(ArgumentVariableProperty.canHaveDefaultValue(argument.getType()));
            }
        }
        super.propertyChange(evt);
    }

    protected void setEditorValue(Object newValue) {
        Argument value = (Argument)this.getValue();
        value.setDefaultValue(newValue.toString());
    }

    protected Object getOldEditorValue() {
        Argument value = (Argument)this.getValue();
        return value.getDefaultValue();
    }

    private static boolean canHaveDefaultValue(TypeDescription type) {
        int kind = type.getKind();
        return kind == 1 || kind == 2 || kind == 3 || kind == 4 || kind == 5 || kind == 6 || kind == 7;
    }

    private static class DefaultValueRenderer
    extends DefaultPropertyRenderer {
        private DefaultValueRenderer() {
        }

        protected String renderProperty(Property property) {
            ArgumentVariableProperty argumentVariableProperty;
            Argument argument;
            int kind;
            Object propValue = property.getValue();
            String currentValue = propValue == null ? "" : propValue.toString();
            Property parent = property.getParent();
            if (parent instanceof ArgumentVariableProperty && (kind = (argument = (Argument)(argumentVariableProperty = (ArgumentVariableProperty)parent).getValue()).getType().getKind()) == 6) {
                return this.parseTime(currentValue);
            }
            return currentValue == null ? "" : currentValue;
        }

        private String parseTime(String value) {
            try {
                Time defaultTimeValue;
                if (value != null && !value.equals("") && (defaultTimeValue = (Time)ConversionUtilities.fromString((String)value, (int)6)) != null) {
                    SimpleDateFormat format = (SimpleDateFormat)Time.getDateFormat(2, 2, Locale.getDefault());
                    value = format.format(defaultTimeValue.dateValue());
                }
            }
            catch (TimeFormatException timeFormatException) {
                // empty catch block
            }
            return value;
        }
    }

    private static class DefaultValueProperty
    extends AbstractProperty
    implements ResetableProperty {
        public DefaultValueProperty(Object value) {
            this.setKey(ProjectMsg.DEFAULT_VALUE);
            this.setValue(((Argument)value).getDefaultValue());
            this.setPropertyRenderer((PropertyRenderer)new DefaultValueRenderer());
            DefaultValueEditor editor = new DefaultValueEditor();
            this.setPropertyEditor((PropertyEditor)editor);
            this.setPropertyEditor((PropertyEditor)new ResetPropertyEditor((PropertyEditor)editor));
        }

        public Object getDefaultValue() {
            return null;
        }
    }

    private static class DefaultValueEditor
    extends AbstractEditor {
        private Editor editor;

        private DefaultValueEditor() {
        }

        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        protected UiComponent getEditor(UiContainer parent) {
            this.editor = new Editor();
            Property property = this.getProperty();
            Property parentProperty = property.getParent();
            Object value = parentProperty.getValue();
            if (!(parentProperty instanceof ArgumentVariableProperty)) {
                throw new InvalidPropertyType(value, Argument.class);
            }
            Argument argument = (Argument)value;
            return this.editor.createComponent(parent, argument);
        }

        private class Editor {
            private UiComponent currentEditor;
            private DocumentListener documentListener;
            private ItemListener itemListener;
            private ValueChangedListener valueChangedListener;

            private Editor() {
            }

            public Object getCellEditorValue() {
                String result;
                if (this.currentEditor instanceof TimeField) {
                    TimeField timeField = (TimeField)this.currentEditor;
                    Time time = timeField.getTime();
                    result = time == null ? null : time.toString();
                } else if (this.currentEditor instanceof ComboBox) {
                    ComboBox booleanCombo = (ComboBox)this.currentEditor;
                    result = "" + (booleanCombo.getSelectedIndex() == 0);
                } else if (this.currentEditor instanceof IntervalField) {
                    IntervalField intervalField = (IntervalField)this.currentEditor;
                    Interval interval = intervalField.getInterval();
                    result = interval == null ? null : interval.toString();
                } else {
                    TextField textField = (TextField)this.currentEditor;
                    result = textField.getText();
                }
                return result;
            }

            public UiComponent getCurrentEditor() {
                return this.currentEditor;
            }

            public UiComponent createComponent(UiContainer parent, Argument argument) {
                TimeField result;
                TypeDescription argumentType = argument.getType();
                int kind = argumentType.getKind();
                String value = argument.getDefaultValue();
                switch (kind) {
                    case 6: {
                        result = this.createTime(parent, value);
                        break;
                    }
                    case 1: {
                        result = this.createBooleanCombo(parent, value);
                        break;
                    }
                    case 7: {
                        result = this.createIntervalField(parent, value);
                        break;
                    }
                    case 3: 
                    case 5: {
                        AbstractFormatter formatter = FormatterFactory.create(kind);
                        int scale = argumentType.getScale();
                        int length = argumentType.getLength();
                        result = this.createTextField(parent, value, formatter, scale, length);
                        break;
                    }
                    case 2: {
                        result = this.createTextField(parent, value);
                        break;
                    }
                    default: {
                        result = this.createNonEditableTextField(parent, value);
                    }
                }
                this.currentEditor = result;
                return result;
            }

            private ItemListener getItemListener() {
                if (this.itemListener == null) {
                    this.itemListener = new ItemListener(){

                        public void itemStateChanged(ItemEvent e) {
                            DefaultValueEditor.this.stopCellEditing();
                        }
                    };
                }
                return this.itemListener;
            }

            private DocumentListener getDocumentListener() {
                if (this.documentListener == null) {
                    this.documentListener = new DocumentListener(){

                        public void changedUpdate(DocumentEvent e) {
                        }

                        public void insertUpdate(DocumentEvent e) {
                        }

                        public void removeUpdate(DocumentEvent e) {
                        }
                    };
                }
                return this.documentListener;
            }

            private ValueChangedListener getValueChangedListener() {
                if (this.valueChangedListener == null) {
                    this.valueChangedListener = new ValueChangedListener(){

                        public void valueChanged(ValueChangedEvent valuechangedevent) {
                        }
                    };
                }
                return this.valueChangedListener;
            }

            private ComboBox createBooleanCombo(UiContainer parent, Object value) {
                ComboBox booleanCombo = UiFactory.createBooleanComboBox((UiContainer)parent);
                booleanCombo.putClientProperty("ComboBox.isTableCellEditor", (Object)Boolean.TRUE);
                booleanCombo.addItemListener(this.getItemListener());
                boolean isTrue = value != null && value.equals("true");
                booleanCombo.setSelectedIndex(isTrue ? 0 : 1);
                return booleanCombo;
            }

            private IntervalField createIntervalField(UiContainer parent, String value) {
                IntervalField intervalField = new IntervalField(parent);
                intervalField.addValueChangedListener(this.valueChangedListener);
                Interval intervalValue = value == null ? null : Interval.valueOf(value);
                intervalField.setInterval(intervalValue);
                return intervalField;
            }

            private TextField createNonEditableTextField(UiContainer parent, String value) {
                TextField nonEditableTextField = new TextField(parent);
                nonEditableTextField.setText(value != null ? value : "");
                nonEditableTextField.setEditable(false);
                nonEditableTextField.setEnabled(false);
                return nonEditableTextField;
            }

            private TextField createTextField(UiContainer parent, String value) {
                TextField textField = new TextField(parent);
                textField.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        DefaultValueEditor.this.stopCellEditing();
                    }
                });
                textField.addDocumentListener(this.getDocumentListener());
                textField.setText(value != null ? value : "");
                textField.addDocumentListener(this.getDocumentListener());
                return textField;
            }

            private TextField createTextField(UiContainer parent, String value, AbstractFormatter formatter, int scale, int length) {
                TextField textField = this.createTextField(parent, value);
                formatter.format(textField);
                if (length != -1 || scale != -1) {
                    formatter.applyPrecisionRestrictions(scale, length);
                }
                return textField;
            }

            private TimeField createTime(UiContainer parent, Object value) {
                TimeField timeField = new TimeField(parent, TimeField.Style.DATE_TIME);
                timeField.addValueChangedListener(this.getValueChangedListener());
                Time defaultTimeValue = null;
                try {
                    if (value != null && !value.equals("")) {
                        defaultTimeValue = (Time)ConversionUtilities.fromString((String)((String)value), (int)6);
                    }
                }
                catch (TimeFormatException tfe) {
                    defaultTimeValue = Time.now();
                }
                timeField.setTime(defaultTimeValue);
                return timeField;
            }
        }
    }
}

