/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalogdoc.ui;

import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.util.SystemInfo;

public class MenuItem
extends JMenuItem {
    private Msg msg;
    private boolean showDialog;
    private static final String DOTS = "...";

    public MenuItem() {
    }

    public MenuItem(BaseAction a) {
        super((Action)a);
        this.setText(a.getName());
    }

    public MenuItem(String text) {
        super(text);
    }

    public MenuItem(Msg msg) {
        this(msg, true);
    }

    public MenuItem(Action a, String text) {
        super(a);
        super.setText(text);
    }

    public MenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public MenuItem(Msg msg, int options) {
        this(msg, false);
    }

    public MenuItem(Msg msg, boolean showedDialog) {
        this.showDialog = showedDialog;
        this.setMsg(msg);
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        this.update();
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
        this.update();
    }

    public Msg getMsg() {
        return this.msg;
    }

    public void setShowDialog(boolean showedDialog) {
        this.showDialog = showedDialog;
        this.update();
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    @Override
    public void setVisible(boolean bool) {
        if (SystemInfo.isAnyMac()) {
            super.setEnabled(bool);
        } else {
            super.setVisible(bool);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        InputMap inputMap = this.getInputMap(condition);
        if (this.getAccelerator() != null) {
            inputMap.keys();
        }
        boolean result = super.processKeyBinding(ks, e, condition, pressed);
        return result;
    }

    private void update() {
        ImageIcon icon;
        if (this.msg == null) {
            return;
        }
        String s = this.msg.getString();
        if (this.isShowDialog()) {
            s = s + DOTS;
        }
        super.setText(s);
        if (this.msg.hasImage() && (icon = new ImageIcon(this.msg.getImageResource())) != null) {
            super.setIcon(icon);
        }
    }
}

