/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalogdoc;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.UrlTextField;
import oracle.bpm.ui.validators.NotEmptyValidator;
import org.jetbrains.annotations.Nullable;

class HRefComponent
extends Panel {
    private DescriptionTextField descriptionTextField;
    private UrlTextField urlTextField;

    public HRefComponent(UiContainer parent) {
        this(parent, new Value());
    }

    public HRefComponent(UiContainer parent, Value defaultValue) {
        super(parent);
        this.init(defaultValue);
    }

    public void validateForm() throws InputValidationException {
        this.urlTextField.validateInput();
        this.descriptionTextField.validateInput();
    }

    public Value getHRef() {
        String url = this.urlTextField.getText();
        String description = this.descriptionTextField.getText();
        return new Value(url, description);
    }

    private void init(Value defaultValue) {
        this.urlTextField = new UrlTextField((UiContainer)this, 45);
        this.urlTextField.setText(defaultValue.getURL());
        String description = defaultValue.getDescription();
        boolean existDescription = description != null && !"".equals(description);
        this.descriptionTextField = new DescriptionTextField((UiContainer)this, 45, (TextField)(existDescription ? null : this.urlTextField));
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ADDRESS));
        this.add((UiComponent)this.urlTextField, "growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TEXT_TO_DISPLAY));
        this.add((UiComponent)this.descriptionTextField, "growx, wrap");
        if (existDescription) {
            this.descriptionTextField.setText(description);
            this.descriptionTextField.setEnabled(false);
        }
    }

    private static class DescriptionTextField
    extends TextField {
        private boolean coupled;

        public DescriptionTextField(UiContainer parent, int columns, final @Nullable TextField baseTextField) {
            super(parent, columns);
            this.setInputValidator(new NotEmptyValidator(DesignerMsg.FIELD_VALUE_CANNOT_BE_EMPTY(DesignerMsg.TEXT_TO_DISPLAY.toString())));
            if (baseTextField != null) {
                this.setText(baseTextField.getText());
                DocumentListener coupleListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent e) {
                        this.updateText();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        this.updateText();
                    }

                    public void changedUpdate(DocumentEvent e) {
                        this.updateText();
                    }

                    private void updateText() {
                        if (DescriptionTextField.this.coupled) {
                            String text = baseTextField.getText();
                            DescriptionTextField.this.setText(text);
                        }
                    }
                };
                baseTextField.addDocumentListener(coupleListener);
                this.addKeyListener(new KeyListener(){

                    private void stopCouple() {
                        if (DescriptionTextField.this.coupled) {
                            DescriptionTextField.this.coupled = false;
                        }
                    }

                    public void keyPressed(KeyEvent e) {
                        this.stopCouple();
                    }

                    public void keyReleased(KeyEvent e) {
                        this.stopCouple();
                    }

                    public void keyTyped(KeyEvent e) {
                        this.stopCouple();
                    }
                });
                this.coupled = true;
            }
        }
    }

    public static class Value {
        private String description;
        private String url;

        public Value() {
            this(null);
        }

        public Value(String url) {
            this(url, null);
        }

        public Value(String url, String description) {
            this.setURL(url == null ? "http://" : url);
            this.setDescription(description);
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setURL(String url) {
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }
    }
}

