/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalogdoc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import oracle.bpm.designer.catalogdoc.HRefComponent;
import oracle.bpm.designer.catalogdoc.HRefDialog;
import oracle.bpm.designer.catalogdoc.PreviewDialog;
import oracle.bpm.designer.catalogdoc.ui.PopupMenu;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.LanguageChooser;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.SwingCellRenderer;
import oracle.bpm.ui.utils.FontUtils;
import oracle.bpm.util.FileFilter;
import oracle.bpm.util.documentation.Documentable;
import oracle.bpm.util.documentation.DocumentationType;
import oracle.bpm.util.documentation.DocumentationUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentationEditorPanel
extends JPanel {
    private BaseAction alignCenterAction;
    private BaseAction alignLeftAction;
    private BaseAction alignRightAction;
    private JToggleButton boldButton;
    private JToggleButton centerAlignButton;
    private boolean changed = false;
    private Documentable currentDocumentable;
    private JLabel documentationLabel;
    private ItemListener documentationTypeChangeListener;
    private JComboBox documentationTypeCombo;
    private DocumentListener documentListener;
    private BaseAction editCopyAction;
    private BaseAction editCutAction;
    private BaseAction editPasteAction;
    private JTextPane editTextPane;
    private BaseAction fontBoldAction;
    private JComboBox fontFamilyCombo;
    private BaseAction fontItalicAction;
    private JComboBox fontSizeCombo;
    private BaseAction fontUnderlineAction;
    private JButton foregroundColorJButton;
    private BaseAction hyperlinkAction;
    private JFileChooser imageFileChooser;
    private boolean isAutosave;
    private JToggleButton italicButton;
    private ItemListener languageChangeListener;
    private JComboBox languagesCombo;
    private JToggleButton leftAlignButton;
    private PreviewDialog previewDialog;
    private RedoAction redoAction;
    private JToggleButton rightAlignButton;
    private BaseAction selectAllAction;
    private JToggleButton underlineButton;
    private UndoManager undo;
    private UndoAction undoAction;
    private UndoableEditListener undoHandler;
    private boolean updatingToolbar;
    private static final StyledEditorKit.FontSizeAction FONT_SIZE_ACTION = new StyledEditorKit.FontSizeAction("font-size", 0);
    private static final StyledEditorKit.FontFamilyAction FONT_FAMILY_ACTION = new StyledEditorKit.FontFamilyAction("font-family", null);
    private static int OPTIONS = 10;

    private DocumentationEditorPanel(@NotNull Documentable documentable, boolean isAutosave) {
        super(true);
        this.isAutosave = isAutosave;
        this.init();
        this.documentableChanged(documentable);
    }

    public static DocumentationEditorPanel create(@NotNull Documentable documentable) {
        return new DocumentationEditorPanel(documentable, false);
    }

    public static DocumentationEditorPanel createAutosave(@NotNull Documentable documentable) {
        return new DocumentationEditorPanel(documentable, true);
    }

    public void documentableChanged(final @NotNull Documentable documentable) {
        if (documentable != this.currentDocumentable) {
            if (UiUtilities.isEventDispatchThread()) {
                this.storeDocumentation();
                this.currentDocumentable = documentable;
                this.documentableToEditor(this.currentDocumentable);
            } else {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DocumentationEditorPanel.this.documentableChanged(documentable);
                    }
                });
            }
        }
    }

    public void storeDocumentation() {
        this.storeDocumentation(this.getCurrentLanguage(), this.getCurrentDocumentationType());
    }

    public void refreshLabel() {
        this.documentationLabel.setText(this.currentDocumentable.getLabel());
    }

    private static ImageIcon getSmallIcon(BaseAction action) {
        ImageIcon img = null;
        Msg msg = action.getMsg();
        if (msg != null && msg.hasImage()) {
            img = new ImageIcon(msg.getImageResource());
        } else {
            Object smallIcon = action.getValue("SmallIcon");
            if (smallIcon instanceof ImageIcon) {
                img = (ImageIcon)smallIcon;
            }
        }
        return img;
    }

    private static void setAttributes(AbstractButton item, BaseAction action, int options) {
        ImageIcon icon;
        if ((options & 2) != 0 && (icon = DocumentationEditorPanel.getSmallIcon(action)) != null) {
            item.setIcon(icon);
        }
        item.setEnabled(action.isEnabled());
        Msg msg = action.getMsg();
        if (msg != null) {
            if (msg.getString() != null && (options & 1) != 0) {
                item.setText(msg.getString());
            }
            if (msg.getDetail() != null) {
                item.setToolTipText(msg.getDetail());
            }
        }
    }

    private static int getHTMLAlignment(AttributeSet paragraphAttrs) {
        Object attribute;
        String align = (String)paragraphAttrs.getAttribute(HTML.Attribute.ALIGN);
        if (align == null && (attribute = paragraphAttrs.getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            align = attribute.toString();
        }
        int alignment = 0;
        if (align != null) {
            if ("center".equals(align)) {
                alignment = 1;
            } else if ("right".equals(align)) {
                alignment = 2;
            }
        }
        return alignment;
    }

    private static void addActionToToolbar(JToolBar toolbar, BaseAction action) {
        JButton button = toolbar.add((Action)action);
        DocumentationEditorPanel.setUpButton(action, button);
    }

    private static void setUpButton(BaseAction action, AbstractButton button) {
        Msg msg = action.getMsg();
        button.setText("");
        button.setToolTipText(action.getMsg().getString());
        if (msg.hasImage()) {
            ImageIcon icon = new ImageIcon(msg.getImageResource());
            button.setIcon(icon);
        }
        button.setBorder(null);
        button.setEnabled(true);
        button.setFocusable(false);
        Dimension dimension = new Dimension(24, 24);
        button.setMinimumSize(dimension);
        button.setMaximumSize(dimension);
        button.setPreferredSize(dimension);
    }

    private static void fixPasteAction(final JTextPane editorPane) {
        BaseAction pasteAction = new BaseAction(){

            public void run() {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable content = clipboard.getContents((Object)this);
                if (content != null && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String text = (String)content.getTransferData(DataFlavor.stringFlavor);
                        editorPane.replaceSelection(text);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        editorPane.getActionMap().put("paste", (Action)pasteAction);
    }

    private static JComboBox createLanguageCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        SwingCellRenderer cellRenderer = new SwingCellRenderer((LabelProvider)LanguageChooser.getDefaultLabelProvider());
        combo.setRenderer((ListCellRenderer<String>)cellRenderer);
        combo.setPrototypeDisplayValue("HHHHHHHHH");
        combo.setFocusable(false);
        return combo;
    }

    private static Object getAttribute(HTMLEditorKit htmlEditorKit, AttributeSet attributeSet, Object key) {
        Style s;
        Object value = attributeSet.getAttribute(key);
        if (value == null && (s = htmlEditorKit.getStyleSheet().getStyle("body")) != null) {
            value = s.getAttribute(key);
        }
        return value;
    }

    private void storeDocumentation(@NotNull Locale fixedLanguage) {
        this.storeDocumentation(fixedLanguage, this.getCurrentDocumentationType());
    }

    private void storeDocumentation(@NotNull DocumentationType fixedType) {
        this.storeDocumentation(this.getCurrentLanguage(), fixedType);
    }

    private void storeDocumentation(@NotNull Locale language, @NotNull DocumentationType type) {
        if (this.changed && this.currentDocumentable.isEditable()) {
            String htmlString = DocumentationUtils.getDocumentation(this.getTextPane());
            this.currentDocumentable.setDocumentation(type, language, htmlString);
            this.changed = false;
        }
    }

    private JTextPane createTextPane() {
        final JTextPane editorPane = new JTextPane();
        DocumentationEditorPanel.fixPasteAction(editorPane);
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                DocumentationEditorPanel.this.updateToolBarStatus(e.getDot());
            }
        });
        editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MouseEventUtilities.isPopupTrigger((MouseEvent)e)) {
                    this.showPopup(e);
                }
            }

            private void showPopup(MouseEvent e) {
                PopupMenu popupMenu = DocumentationEditorPanel.this.createPopupMenu();
                popupMenu.show(editorPane, e.getX(), e.getY());
            }
        });
        editorPane.addKeyListener(new TextPaneKeyListener());
        return editorPane;
    }

    private JTextPane getTextPane() {
        return this.editTextPane;
    }

    private Action getEditorAction(String cmd) {
        return this.getTextPane().getActionMap().get(cmd);
    }

    private void init() {
        this.undo = new UndoManager();
        this.undoHandler = new UndoHandler();
        JPanel headerPanel = this.createHeaderPanel();
        JPanel editorPanel = this.createEditorPanel();
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)headerPanel, "North");
        this.add((Component)editorPanel, "Center");
    }

    private JPanel createHeaderPanel() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new MigLayout("fillx, gapx 5, ins 5"));
        this.documentationLabel = new JLabel();
        this.documentationTypeCombo = this.createDocumentationTypeCombo();
        this.languagesCombo = DocumentationEditorPanel.createLanguageCombo();
        result.add((Component)this.documentationLabel, "growx");
        result.add(new JLabel(DesignerMsg.TYPE.withColon().getString()));
        result.add(this.documentationTypeCombo);
        result.add(new JLabel(UIMsg.LANGUAGE.withColon().getString()));
        result.add(this.languagesCombo);
        return result;
    }

    private JPanel createEditorPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        this.editTextPane = this.createTextPane();
        this.createActions();
        JComponent toolBar = this.createToolbar();
        JScrollPane scrollPane = new JScrollPane(this.editTextPane);
        scrollPane.getViewport().setScrollMode(2);
        result.add((Component)toolBar, "North");
        result.add((Component)scrollPane, "Center");
        return result;
    }

    private void createActions() {
        this.redoAction = new RedoAction();
        this.undoAction = new UndoAction();
        this.editCutAction = BaseAction.valueOf((Action)this.getEditorAction("cut-to-clipboard"), (Msg)UIMsg.CUT);
        this.editCopyAction = BaseAction.valueOf((Action)this.getEditorAction("copy-to-clipboard"), (Msg)UIMsg.COPY);
        this.editPasteAction = BaseAction.valueOf((Action)this.getEditorAction("paste-from-clipboard"), (Msg)UIMsg.PASTE);
        this.fontBoldAction = BaseAction.valueOf((Action)this.getEditorAction("font-bold"), (Msg)DesignerMsg.BOLD);
        this.fontItalicAction = BaseAction.valueOf((Action)this.getEditorAction("font-italic"), (Msg)DesignerMsg.ITALIC);
        this.fontUnderlineAction = BaseAction.valueOf((Action)this.getEditorAction("font-underline"), (Msg)DesignerMsg.UNDERLINE);
        this.alignCenterAction = BaseAction.valueOf((Action)this.getEditorAction("center-justify"), (Msg)DesignerMsg.CENTER_JUSTIFY);
        this.alignLeftAction = BaseAction.valueOf((Action)this.getEditorAction("left-justify"), (Msg)DesignerMsg.LEFT_JUSTIFY);
        this.alignRightAction = BaseAction.valueOf((Action)this.getEditorAction("right-justify"), (Msg)DesignerMsg.RIGHT_JUSTIFY);
        this.selectAllAction = BaseAction.valueOf((Action)this.getEditorAction("select-all"), (Msg)DesignerMsg.SELECT_ALL);
        ShowColorChooserAction showColorChooserAction = new ShowColorChooserAction();
        this.foregroundColorJButton = new JButton(showColorChooserAction);
        this.foregroundColorJButton.setFocusable(false);
        this.foregroundColorJButton.setToolTipText(UIMsg.FGROUND.getString());
        this.foregroundColorJButton.setIcon(new ImageIcon(UIMsg.FGROUND.getImageResource()));
        this.hyperlinkAction = new HyperLinkAction();
    }

    private void documentableToEditor(Documentable documentable) {
        String label = documentable.getLabel();
        this.documentationLabel.setText(label);
        ItemListener languageListener = this.getLanguageChangeListener();
        this.languagesCombo.removeItemListener(languageListener);
        this.languagesCombo.removeAllItems();
        Collection<Locale> languages = documentable.getAvailableLanguages();
        for (Locale locale : languages) {
            this.languagesCombo.addItem(locale);
        }
        this.languagesCombo.setSelectedItem(documentable.getDefaultLanguage());
        this.languagesCombo.addItemListener(languageListener);
        ItemListener typeListener = this.getDocumentationTypeChangeListener();
        this.documentationTypeCombo.removeItemListener(typeListener);
        this.documentationTypeCombo.setSelectedItem(DocumentationType.DOCUMENTATION);
        this.documentationTypeCombo.addItemListener(typeListener);
        this.loadDocumentation(documentable);
        this.getTextPane().setEditable(documentable.isEditable());
    }

    private ItemListener getLanguageChangeListener() {
        if (this.languageChangeListener == null) {
            this.languageChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DocumentationEditorPanel.this.loadDocumentation(DocumentationEditorPanel.this.currentDocumentable);
                    } else {
                        Locale previousLocale = (Locale)e.getItem();
                        DocumentationEditorPanel.this.storeDocumentation(previousLocale);
                    }
                }
            };
        }
        return this.languageChangeListener;
    }

    private ItemListener getDocumentationTypeChangeListener() {
        if (this.documentationTypeChangeListener == null) {
            this.documentationTypeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DocumentationEditorPanel.this.loadDocumentation(DocumentationEditorPanel.this.currentDocumentable);
                    } else {
                        DocumentationType previousType = (DocumentationType)e.getItem();
                        DocumentationEditorPanel.this.storeDocumentation(previousType);
                    }
                }
            };
        }
        return this.documentationTypeChangeListener;
    }

    private JComboBox createDefaultFamilyCombo() {
        String[] availableFontFamilyNames = FontUtils.getAvailableFontFamilyNames();
        JComboBox<String> comboBox = new JComboBox<String>(availableFontFamilyNames);
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String fontFamily = (String)value;
                Font font = new Font(fontFamily, 0, 12);
                label.setFont(font);
                return label;
            }
        };
        comboBox.setRenderer(renderer);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DocumentationEditorPanel.this.updatingToolbar && e.getStateChange() == 1) {
                    FONT_FAMILY_ACTION.actionPerformed(new ActionEvent(DocumentationEditorPanel.this.getTextPane(), 1001, (String)e.getItem()));
                }
            }
        });
        comboBox.setSelectedItem(this.getTextPane().getFont().getFamily());
        return comboBox;
    }

    private JComboBox createHtmlSizesCombo() {
        JComboBox<String> comboBox = new JComboBox<String>(new String[]{"8", "10", "12", "14", "16", "18", "24", "36", "48"});
        comboBox.setToolTipText(UIMsg.FONT_SIZE.getString());
        comboBox.setPrototypeDisplayValue("100");
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DocumentationEditorPanel.this.updatingToolbar && e.getStateChange() == 1) {
                    FONT_SIZE_ACTION.actionPerformed(new ActionEvent(DocumentationEditorPanel.this.getTextPane(), 1001, (String)e.getItem()));
                }
            }
        });
        comboBox.setSelectedItem(String.valueOf(this.getTextPane().getFont().getSize()));
        return comboBox;
    }

    private JFileChooser getImageFileChooser() {
        if (this.imageFileChooser == null) {
            this.imageFileChooser = new JFileChooser();
            FileFilter defaultFilter = FileFilter.create(UIMsg.IMAGE_FILES, "jpg", "gif", "bmp", "png");
            this.imageFileChooser.setFileFilter(defaultFilter);
            this.imageFileChooser.addChoosableFileFilter(defaultFilter);
            this.imageFileChooser.addChoosableFileFilter(FileFilter.create(UIMsg.JPEG_FILES, "jpg"));
            this.imageFileChooser.addChoosableFileFilter(FileFilter.create(UIMsg.GIF_FILES, "gif"));
            this.imageFileChooser.addChoosableFileFilter(FileFilter.create(UIMsg.BMP_FILES, "bmp"));
            this.imageFileChooser.addChoosableFileFilter(FileFilter.create(UIMsg.PNG_FILES, "png"));
        }
        return this.imageFileChooser;
    }

    private JToggleButton addToggleActionToToolbar(BaseAction action) {
        JToggleButton button = new JToggleButton(action.getMsg().getString());
        DocumentationEditorPanel.setUpButton(action, button);
        button.setAction((Action)action);
        DocumentationEditorPanel.setAttributes(button, action, OPTIONS);
        return button;
    }

    private JComponent createToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        DocumentationEditorPanel.addActionToToolbar(toolbar, this.undoAction);
        DocumentationEditorPanel.addActionToToolbar(toolbar, this.redoAction);
        toolbar.addSeparator();
        DocumentationEditorPanel.addActionToToolbar(toolbar, this.editCutAction);
        DocumentationEditorPanel.addActionToToolbar(toolbar, this.editCopyAction);
        DocumentationEditorPanel.addActionToToolbar(toolbar, this.editPasteAction);
        toolbar.addSeparator();
        this.fontSizeCombo = this.createHtmlSizesCombo();
        toolbar.add(this.fontSizeCombo);
        toolbar.addSeparator();
        this.fontFamilyCombo = this.createDefaultFamilyCombo();
        toolbar.add(this.fontFamilyCombo);
        toolbar.addSeparator();
        this.boldButton = this.addToggleActionToToolbar(this.fontBoldAction);
        DocumentationEditorPanel.setUpButton(this.fontBoldAction, this.boldButton);
        this.italicButton = this.addToggleActionToToolbar(this.fontItalicAction);
        DocumentationEditorPanel.setUpButton(this.fontItalicAction, this.italicButton);
        this.underlineButton = this.addToggleActionToToolbar(this.fontUnderlineAction);
        DocumentationEditorPanel.setUpButton(this.fontUnderlineAction, this.underlineButton);
        toolbar.add(this.boldButton);
        toolbar.add(this.italicButton);
        toolbar.add(this.underlineButton);
        toolbar.addSeparator();
        toolbar.add(this.foregroundColorJButton);
        toolbar.addSeparator();
        this.leftAlignButton = this.addToggleActionToToolbar(this.alignLeftAction);
        DocumentationEditorPanel.setUpButton(this.alignLeftAction, this.leftAlignButton);
        this.centerAlignButton = this.addToggleActionToToolbar(this.alignCenterAction);
        DocumentationEditorPanel.setUpButton(this.alignCenterAction, this.centerAlignButton);
        this.rightAlignButton = this.addToggleActionToToolbar(this.alignRightAction);
        DocumentationEditorPanel.setUpButton(this.alignRightAction, this.rightAlignButton);
        toolbar.add(this.leftAlignButton);
        toolbar.add(this.centerAlignButton);
        toolbar.add(this.rightAlignButton);
        toolbar.addSeparator();
        DocumentationEditorPanel.addActionToToolbar(toolbar, this.hyperlinkAction);
        return toolbar;
    }

    private PopupMenu createPopupMenu() {
        PopupMenu popup = new PopupMenu();
        popup.add(this.editCutAction);
        popup.add(this.editCopyAction);
        popup.add(this.editPasteAction);
        popup.addSeparator();
        popup.add(this.selectAllAction);
        popup.addSeparator();
        popup.add(BaseAction.valueOf((Action)this.foregroundColorJButton.getAction(), (Msg)UIMsg.FGROUND), true);
        popup.addSeparator();
        popup.add(this.hyperlinkAction, true);
        if (Ui.isDebug()) {
            BaseAction showSourceAction = new BaseAction("View Source"){

                public void actionPerformed(oracle.bpm.ui.event.ActionEvent e) {
                    if (DocumentationEditorPanel.this.previewDialog == null) {
                        DocumentationEditorPanel.this.previewDialog = new PreviewDialog(Ui.getRoot(), DocumentationEditorPanel.this.getTextPane());
                    }
                    DocumentationEditorPanel.this.previewDialog.setVisible(true);
                }
            };
            popup.addSeparator();
            popup.add(showSourceAction);
        }
        return popup;
    }

    private JComboBox createDocumentationTypeCombo() {
        JComboBox<DocumentationType> comboBox = new JComboBox<DocumentationType>(DocumentationType.values());
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                DocumentationType type = (DocumentationType)value;
                label.setText(type.getString());
                return label;
            }
        };
        comboBox.setRenderer(renderer);
        comboBox.setFocusable(false);
        comboBox.setSelectedItem(DocumentationType.DOCUMENTATION);
        return comboBox;
    }

    private int findCorrectCaretPos(int caretPosition) {
        try {
            if (caretPosition > 0) {
                --caretPosition;
            }
            String text = this.getTextPane().getText(caretPosition, 1);
            if (caretPosition > 0 && (text == null || "".equals(text) || "\n".equals(text))) {
                --caretPosition;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return caretPosition;
    }

    private Locale getCurrentLanguage() {
        return (Locale)this.languagesCombo.getSelectedItem();
    }

    private DocumentationType getCurrentDocumentationType() {
        return (DocumentationType)this.documentationTypeCombo.getSelectedItem();
    }

    private void loadDocumentation(Documentable documentable) {
        Locale language = this.getCurrentLanguage();
        DocumentationType type = this.getCurrentDocumentationType();
        JTextPane textPane = this.getTextPane();
        Document oldDocument = textPane.getDocument();
        DocumentListener documentListener = this.getDocumentListener();
        oldDocument.removeDocumentListener(documentListener);
        oldDocument.removeUndoableEditListener(this.undoHandler);
        String htmlDocument = documentable.getDocumentation(type, language);
        DocumentationUtils.loadDocumentation(textPane, htmlDocument);
        Document newDocument = textPane.getDocument();
        if (documentable.isEditable()) {
            newDocument.addDocumentListener(documentListener);
        }
        newDocument.addUndoableEditListener(this.undoHandler);
        this.resetUndoManager();
        int length = textPane.getDocument().getLength() == 0 ? 0 : 1;
        textPane.setCaretPosition(length);
        this.updateToolBarStatus(length);
    }

    private DocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.save();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.save();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.save();
                    DocumentationEditorPanel.this.updateToolBarStatus(e.getOffset());
                }

                private void save() {
                    DocumentationEditorPanel.this.changed = true;
                    if (DocumentationEditorPanel.this.isAutosave) {
                        DocumentationEditorPanel.this.storeDocumentation();
                    }
                }
            };
        }
        return this.documentListener;
    }

    private void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private void updateToolBarStatus(int caretPosition) {
        int caret = this.findCorrectCaretPos(caretPosition);
        this.updatingToolbar = true;
        JTextPane textPane = this.getTextPane();
        HTMLEditorKit htmlEditorKit = (HTMLEditorKit)textPane.getEditorKit();
        Element ce = textPane.getStyledDocument().getCharacterElement(caret);
        AttributeSet characterAttrs = ce.getAttributes();
        Element element = textPane.getStyledDocument().getParagraphElement(caret);
        AttributeSet paragraphAttrs = element.getAttributes();
        Object fontFamily = DocumentationEditorPanel.getAttribute(htmlEditorKit, characterAttrs, StyleConstants.FontFamily);
        if (fontFamily != null) {
            this.fontFamilyCombo.setSelectedItem(fontFamily);
        } else {
            this.fontFamilyCombo.setSelectedIndex(-1);
        }
        Integer fontSize = (Integer)DocumentationEditorPanel.getAttribute(htmlEditorKit, characterAttrs, StyleConstants.FontSize);
        if (fontSize != null) {
            this.fontSizeCombo.setSelectedItem(fontSize.toString());
        } else {
            this.fontSizeCombo.setSelectedIndex(-1);
        }
        this.boldButton.setSelected(StyleConstants.isBold(characterAttrs));
        this.italicButton.setSelected(StyleConstants.isItalic(characterAttrs));
        this.underlineButton.setSelected(StyleConstants.isUnderline(characterAttrs));
        int alignment = DocumentationEditorPanel.getHTMLAlignment(paragraphAttrs);
        this.leftAlignButton.setSelected(alignment == 0);
        this.leftAlignButton.setEnabled(alignment != 0);
        this.centerAlignButton.setSelected(alignment == 1);
        this.centerAlignButton.setEnabled(alignment != 1);
        this.rightAlignButton.setSelected(alignment == 2);
        this.rightAlignButton.setEnabled(alignment != 2);
        this.updatingToolbar = false;
    }

    private class UndoHandler
    implements UndoableEditListener {
        private UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            DocumentationEditorPanel.this.undo.addEdit(e.getEdit());
            DocumentationEditorPanel.this.undoAction.update();
            DocumentationEditorPanel.this.redoAction.update();
        }
    }

    private class UndoAction
    extends BaseAction {
        public UndoAction() {
            super(UIMsg.UNDO);
            this.setEnabled(false);
        }

        public void run() {
            if (DocumentationEditorPanel.this.undo.canUndo()) {
                try {
                    DocumentationEditorPanel.this.undo.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
                this.update();
                DocumentationEditorPanel.this.redoAction.update();
            }
        }

        void update() {
            if (DocumentationEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("ShortDescription", DocumentationEditorPanel.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", this.getMsg().getString());
            }
        }
    }

    private class TextPaneKeyListener
    extends KeyAdapter {
        private TextPaneKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            int keyCode = event.getKeyCode();
            try {
                if (event.isControlDown()) {
                    if (keyCode == 90) {
                        DocumentationEditorPanel.this.undoAction.actionPerformed(new ActionEvent(event.getSource(), 1001, null));
                    } else if (keyCode == 89) {
                        DocumentationEditorPanel.this.redoAction.actionPerformed(new ActionEvent(event.getSource(), 1001, null));
                    }
                } else if (keyCode == 10 && event.getModifiers() == 1) {
                    this.insertBreak();
                } else if (keyCode == 9) {
                    this.insertTab();
                }
            }
            catch (BadLocationException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void insertBreak() throws IOException, BadLocationException {
            JTextPane textPane = DocumentationEditorPanel.this.getTextPane();
            int caretPos = textPane.getCaretPosition();
            HTMLDocument document = (HTMLDocument)DocumentationEditorPanel.this.getTextPane().getDocument();
            HTMLEditorKit htmlEdiorKit = (HTMLEditorKit)textPane.getEditorKit();
            htmlEdiorKit.insertHTML(document, caretPos, "<br>", 0, 0, HTML.Tag.BR);
            textPane.setCaretPosition(caretPos + 1);
        }

        private void insertTab() throws BadLocationException {
            JTextPane textPane = DocumentationEditorPanel.this.getTextPane();
            int caretPos = textPane.getCaretPosition();
            HTMLDocument document = (HTMLDocument)DocumentationEditorPanel.this.getTextPane().getDocument();
            document.insertString(caretPos, "\u00a0\u00a0\u00a0\u00a0", textPane.getInputAttributes());
            textPane.setCaretPosition(caretPos + 4);
        }
    }

    private class RedoAction
    extends BaseAction {
        public RedoAction() {
            super(UIMsg.REDO);
            this.setEnabled(false);
        }

        public void run() {
            if (DocumentationEditorPanel.this.undo.canRedo()) {
                try {
                    DocumentationEditorPanel.this.undo.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
                this.update();
                DocumentationEditorPanel.this.undoAction.update();
            }
        }

        void update() {
            if (DocumentationEditorPanel.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("ShortDescription", DocumentationEditorPanel.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", this.getMsg().getString());
            }
        }
    }

    private class HyperLinkAction
    extends BaseAction {
        public HyperLinkAction() {
            super(UIMsg.URL_LINK);
        }

        public void actionPerformed(oracle.bpm.ui.event.ActionEvent e) {
            final ActionEvent awtEvent = e.asSwing();
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    HyperLinkAction.this.showHrefDialog(awtEvent);
                }
            });
        }

        private void showHrefDialog(ActionEvent awtEvent) {
            boolean existAnchor;
            JTextPane textPane = DocumentationEditorPanel.this.getTextPane();
            int pos = textPane.getCaretPosition();
            Element characterElement = textPane.getStyledDocument().getCharacterElement(pos);
            int startOffset = characterElement.getStartOffset();
            int endOffset = characterElement.getEndOffset();
            AttributeSet anchor = (AttributeSet)characterElement.getAttributes().getAttribute(HTML.Tag.A);
            String oldRef = null;
            String oldDescription = null;
            boolean bl = existAnchor = anchor != null;
            if (existAnchor) {
                oldRef = (String)anchor.getAttribute(HTML.Attribute.HREF);
                try {
                    oldDescription = textPane.getStyledDocument().getText(startOffset, endOffset - startOffset);
                }
                catch (BadLocationException ignore) {
                    // empty catch block
                }
                textPane.setSelectionStart(startOffset);
                textPane.setSelectionEnd(endOffset);
            } else {
                int selectionEnd;
                int selectionStart = textPane.getSelectionStart();
                if (selectionStart != (selectionEnd = textPane.getSelectionEnd())) {
                    try {
                        oldDescription = textPane.getText(selectionStart, selectionEnd - selectionStart);
                    }
                    catch (BadLocationException ignore) {
                        // empty catch block
                    }
                }
            }
            HRefComponent.Value value = new HRefComponent.Value(oldRef, oldDescription);
            HRefDialog hrefDialog = existAnchor ? HRefDialog.editHyperlink(Ui.getRoot(), value) : HRefDialog.createHyperlink(Ui.getRoot(), value);
            hrefDialog.setVisible(true);
            if (hrefDialog.userAccepted()) {
                HRefComponent.Value hrefValue = hrefDialog.getHRef();
                String newRef = hrefValue.getURL();
                String description = hrefValue.getDescription();
                if (newRef == null) {
                    return;
                }
                if (anchor == null) {
                    textPane.replaceSelection("");
                    String html = "<a href=\"" + newRef + "\">" + Str.toXMLString(description) + "</a>&nbsp;";
                    HTMLEditorKit.InsertHTMLTextAction action = new HTMLEditorKit.InsertHTMLTextAction("insertHREF", html, HTML.Tag.P, HTML.Tag.A, HTML.Tag.IMPLIED, HTML.Tag.A);
                    awtEvent.setSource(DocumentationEditorPanel.this.getTextPane());
                    action.actionPerformed(awtEvent);
                    textPane.setCaretPosition(pos + description.length() + 1);
                } else {
                    SimpleAttributeSet hrefAttr = new SimpleAttributeSet();
                    hrefAttr.addAttribute(HTML.Attribute.HREF, newRef);
                    SimpleAttributeSet tagAttr = new SimpleAttributeSet();
                    tagAttr.addAttribute(HTML.Tag.A, hrefAttr);
                    textPane.getStyledDocument().setCharacterAttributes(startOffset, endOffset - startOffset, tagAttr, false);
                    textPane.setCaretPosition(endOffset);
                }
                textPane.grabFocus();
            }
        }
    }

    private class ColorActionListener
    implements ActionListener {
        private ShowColorChooserAction showColorChooserAction;

        public ColorActionListener(ShowColorChooserAction showColorChooserAction) {
            this.showColorChooserAction = showColorChooserAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.showColorChooserAction.getColor();
            if (color != null) {
                StyledEditorKit.ForegroundAction action = new StyledEditorKit.ForegroundAction(null, color);
                ActionEvent colorEvent = new ActionEvent(DocumentationEditorPanel.this.getTextPane(), 1001, "");
                action.actionPerformed(colorEvent);
            }
        }
    }

    private static class ColorPanel
    extends JPanel {
        private final BaseAction clickAction;

        public ColorPanel(BaseAction clickAction) {
            this.clickAction = clickAction;
            this.setUp();
        }

        public void translate() {
            this.setToolTipText(DesignerMsg.COLOR.getString());
        }

        void setUp() {
            this.setMaximumSize(new Dimension(20, 20));
            this.setToolTipText(DesignerMsg.COLOR.getString());
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ColorPanel.this.clickAction.actionPerformed(new ActionEvent(this, 1001, null));
                }
            });
        }
    }

    public class ShowColorChooserAction
    extends AbstractAction {
        private JColorChooser chooser;
        private JDialog dialog;

        ShowColorChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            ColorActionListener okListener = new ColorActionListener(this);
            this.chooser = new JColorChooser(Color.BLACK);
            this.dialog = JColorChooser.createDialog(w, UIMsg.CHOOSE_COLOR.getString(), true, this.chooser, okListener, null);
            this.dialog.setVisible(true);
        }

        public Color getColor() {
            return this.chooser.getColor();
        }
    }
}

