/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import java.io.IOException;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.type.Introspector;
import oracle.bpm.type.TypeCatalogException;

public abstract class ProjectCatalogTreeNode
extends ProjectObjectTreeNode {
    static final long serialVersionUID = 1111190757962588914L;
    static final long serialCheck = 8528955328471251257L;

    public ProjectCatalogTreeNode(Project element) {
        super((ProjectObject)element);
    }

    public abstract void removeFromRepository() throws IOException, TypeCatalogException;

    public String getComponentType() {
        return ComponentType.OBJECT.getText();
    }

    public boolean isIntrospectable() {
        Extension<IntrospectorMetadata> extension = Introspector.Extension.find(this.getComponentType());
        return extension != null && extension.getMetadata().reintrospectable();
    }

    public boolean isModule() {
        return this.getComponentType().equals(ComponentType.OBJECT.getText());
    }

    public boolean isMutable() {
        return this.getComponentType().equals(ComponentType.XOBJECT.getText());
    }

    public boolean isLeaf() {
        if (this.isLoaded()) {
            return super.isLeaf();
        }
        if (this.getUserObject() instanceof ProjectObjectContainer) {
            ProjectObjectContainer container = (ProjectObjectContainer)this.getUserObject();
            return this.getFilter().getChildren(container).isEmpty();
        }
        return super.isLeaf();
    }

    public String getTemplate() {
        return "";
    }

    public boolean delete() {
        return false;
    }

    @Override
    public void refresh() {
        this.reload();
    }

    @Override
    public void refresh(String qualifiedName) {
        if (!this.isLoaded()) {
            return;
        }
        super.refresh(qualifiedName);
    }

    public void refreshMemberVisibility(int mask) {
        if (!this.isLoaded()) {
            return;
        }
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).refreshMemberVisibility(mask);
        }
    }

    public void reloadParent() {
        if (this.hasParent()) {
            this.getParent().reload();
        }
    }
}

