/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.action.CloseObjectPresentationNodeAction;
import oracle.bpm.designer.action.CopyPresentationAction;
import oracle.bpm.designer.action.OpenObjectPresentationAction;
import oracle.bpm.designer.action.RemoveComponentPresentationAction;
import oracle.bpm.designer.action.RenamePresentationAction;
import oracle.bpm.designer.catalog.tree.CatalogObjectComponentTreeNode;
import oracle.bpm.designer.catalog.tree.CatalogObjectNode;
import oracle.bpm.designer.catalog.tree.CatalogObjectStructureTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class ObjectPresentationTreeNode
extends CatalogObjectComponentTreeNode
implements DragItem {
    private CloseObjectPresentationNodeAction closeAction_d;
    private TypeRef currentObject;
    private OpenObjectPresentationAction openAction_d;

    public ObjectPresentationTreeNode(XFormPresentationModel presentationModel, ObjectTypeDescription otd) {
        this.setUserObject(presentationModel);
        this.currentObject = otd.getRef();
        this.setMsg(DesignerMsg.EMPTY_MSG(presentationModel.getModelName()));
    }

    public ObjectPresentationTreeNode(XFormPresentationModel presentationModel, CatalogObjectStructureTreeNode node) {
        this(presentationModel, node.getObject());
    }

    public static String getNodeId(XFormPresentationModel presentationModel) {
        return "PRESENTATION_" + presentationModel.getModelName();
    }

    public void setAsDefault(boolean set) {
        if (set) {
            XObjectTypeDescriptionHelper.setDefaultPresentationName((XObjectTypeDescription)((XObjectTypeDescription)this.currentObject.get()), (String)this.getPresentationModel().getModelName());
        }
    }

    @Override
    public BaseAction getDeleteAction() {
        return this.isEditable() ? this.getRemoveAction() : null;
    }

    @Override
    public Image getIcon() {
        return IconFactory.getIconFor(this.getPresentationModel(), (XObjectTypeDescription)this.currentObject.get());
    }

    public boolean isOpen() {
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        StudioEditor editor = workbench.findEditorByObject(this.getPresentationModel());
        return workbench.isOpen(editor);
    }

    @Override
    public DesignerAction getOpenAction() {
        if (this.openAction_d == null) {
            this.openAction_d = new OpenObjectPresentationAction(this.getPresentationModel(), (XObjectTypeDescription)this.currentObject.get());
        }
        return this.openAction_d;
    }

    public XFormPresentationModel getPresentationModel() {
        return (XFormPresentationModel)this.getUserObject();
    }

    public String getPresentationName() {
        return this.getPresentationModel().getModelName();
    }

    public Transfer[] getTransfers() {
        return new Transfer[]{LocalObjectTransfer.getInstance(XFormPresentationModel.class)};
    }

    public Object getObjectAs(Transfer transfer) {
        XFormPresentationModel result = LocalObjectTransfer.getInstance(XFormPresentationModel.class) == transfer ? this.getPresentationModel() : null;
        return result;
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup(this.getMsg());
        if (!this.getCloseAction().isOpened()) {
            result.add((BaseAction)this.getOpenAction());
        } else {
            result.add((BaseAction)this.getCloseAction());
        }
        if (this.isEditable()) {
            result.add((BaseAction)new CopyPresentationAction(this, (XObjectTypeDescription)this.currentObject.get()));
            result.addSeparator();
            result.add((BaseAction)new RenamePresentationAction(this, (XObjectTypeDescription)this.currentObject.get()));
            result.add((BaseAction)new RemoveComponentPresentationAction(this, (XObjectTypeDescription)this.currentObject.get()));
        }
        return result;
    }

    public boolean delete() {
        return this.getRemoveAction().doIt();
    }

    @Override
    public void removeFromRepository() throws TypeCatalogException {
    }

    public String toString() {
        return ObjectPresentationTreeNode.getNodeId(this.getPresentationModel());
    }

    protected boolean isEditable() {
        return !((CatalogObjectNode)this.getParent()).getObjectModel().isReadOnly();
    }

    private CloseObjectPresentationNodeAction getCloseAction() {
        if (this.closeAction_d == null) {
            this.closeAction_d = new CloseObjectPresentationNodeAction(this.getPresentationModel(), this.getParentCatalogObject());
        }
        return this.closeAction_d;
    }

    private RemoveComponentPresentationAction getRemoveAction() {
        return new RemoveComponentPresentationAction(this, (XObjectTypeDescription)this.currentObject.get());
    }

    private CatalogObject getParentCatalogObject() {
        CatalogObjectNode parentNode = (CatalogObjectNode)this.getParent();
        return parentNode.getObjectModel();
    }
}

