/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import java.util.List;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProjectTreeNode;
import oracle.bpm.designer.UiTypeObserverDecorator;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.HideComponentAction;
import oracle.bpm.designer.action.OpenCatalogNodeAction;
import oracle.bpm.designer.catalog.tree.CatalogNodeLoader;
import oracle.bpm.designer.catalog.tree.CatalogObjectNode;
import oracle.bpm.designer.catalog.tree.ProjectCatalogTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.extensionpoint.metadata.OutlineRootNode;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeObserverImpl;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

@OutlineRootNode(objectClass=CatalogObject.class)
@TreeNodeMetadata(objectType=CatalogObject.class)
public class CatalogObjectTypeTreeNode
extends ProjectCatalogTreeNode
implements CatalogObjectNode,
DragItem,
ObjectRelationListener {
    public UiTypeObserverDecorator typeObserver;
    private CatalogNodeLoader catalogNodeLoader;
    private String componentType;
    private FontStyle fontStyle;
    private boolean initialized;
    private boolean listenersAdded = false;
    private long modifiers = 0L;
    private CatalogObject objectModel;
    private TypeDescription typeDescription;
    private static final int HIDDEN_CATALOG_COLOR_RGB = Color.GRAY.getRGB();
    private static final int DEFAULT_COLOR_RGB = Color.BLACK.getRGB();
    private static final int INHERITED_CATALOG_COLOR_RGB = Color.BLUE.getRGB();

    public CatalogObjectTypeTreeNode(TypeRef objectRef) {
        this(CatalogObjectImpl.create((TypeRef)objectRef));
    }

    public CatalogObjectTypeTreeNode(CatalogObject object) {
        super(object.getProject());
        this.setUserObject(object);
        if (object.getId().equals("")) {
            this.setMsg(DesignerMsg.CATALOG);
        }
        this.objectModel = object;
        this.initTypeObserverListener();
    }

    public static CatalogObjectTypeTreeNode createRoot(Project project) {
        CatalogObjectTypeTreeNode typeTreeNode = new CatalogObjectTypeTreeNode(project.getComponentCatalog().getRoot());
        typeTreeNode.setMsg(DesignerMsg.CATALOG);
        return typeTreeNode;
    }

    public boolean isRoot() {
        if (this.getTypeRef() == null) {
            Platform.getInternalReportingService().reportIssue("Type ref is null", " and it shouldn't ");
            return false;
        }
        String value = this.getTypeRef().getText();
        if (value == null) {
            Platform.getInternalReportingService().reportIssue("Type ref has not text", " and it should");
            return false;
        }
        return value.equals("");
    }

    public int getColorModifiers() {
        return this.isHidden() ? HIDDEN_CATALOG_COLOR_RGB : (this.isProjectInherited() ? INHERITED_CATALOG_COLOR_RGB : DEFAULT_COLOR_RGB);
    }

    @Override
    public boolean isModule() {
        return super.isModule() || Modifier.isModule(this.getObjectModel().getDelegate().getModifiers());
    }

    @Override
    public String getComponentType() {
        if (this.componentType == null) {
            TreeNode parent = this.getParent();
            if (parent != null && parent instanceof CatalogObjectTypeTreeNode) {
                this.componentType = ((CatalogObjectTypeTreeNode)parent).getComponentType();
                if ("object".equals(this.componentType)) {
                    this.componentType = null;
                }
            }
            if (this.componentType == null) {
                TypeInfo info = this.getProject().getComponentCatalog().getInfo(this.getObjectRef());
                if (info != null) {
                    this.componentType = info.getType();
                }
                this.componentType = this.componentType != null ? this.componentType : "object";
            }
        }
        return this.componentType;
    }

    @Override
    public String getToolTipText() {
        String result = null;
        if (this.objectModel instanceof ErrorSource) {
            result = this.formatErrorMsg();
        }
        return result;
    }

    public FontStyle getFontModifiers() {
        if (this.fontStyle == null) {
            FontStyle style = this.isProjectCatalogRoot() ? FontStyle.BOLD : (this.isHidden() ? FontStyle.ITALIC : (this.isDeprecated() ? FontStyle.BOLD_ITALIC : FontStyle.PLAIN));
            this.fontStyle = style;
        }
        return this.fontStyle;
    }

    @Override
    public ObjectTypeDescription getObject() {
        return this.getTypeRef().get().asObject();
    }

    @Override
    public CatalogObject getObjectModel() {
        if (this.objectModel == null) {
            this.initRootData();
        }
        return this.objectModel;
    }

    @Override
    public DesignerAction getOpenAction() {
        if (this.isModule()) {
            return null;
        }
        return new OpenCatalogNodeAction();
    }

    public boolean shouldOpenOnDoubleClick() {
        return !this.getObject().isModule() && this.getObject().getParentRef() != null;
    }

    public boolean isProjectCatalogRoot() {
        return this.getParent() instanceof ProjectTreeNode;
    }

    public Transfer[] getTransfers() {
        Transfer[] transferArray;
        if (this.isModule() || this.isProjectCatalogRoot()) {
            transferArray = Transfer.NONE;
        } else {
            Transfer[] transferArray2 = new Transfer[2];
            transferArray2[0] = LocalObjectTransfer.getInstance(TypeRef.class);
            transferArray = transferArray2;
            transferArray2[1] = TextTransfer.getInstance();
        }
        return transferArray;
    }

    public Object getObjectAs(Transfer transfer) {
        if (LocalObjectTransfer.getInstance(TypeRef.class) == transfer) {
            return this.getTypeRef();
        }
        if (TextTransfer.getInstance() == transfer) {
            return this.getTypeRef().getText();
        }
        return null;
    }

    @Override
    public TypeRef getTypeRef() {
        if (this.getObjectRef() == null) {
            this.initRootData();
        }
        return this.getObjectRef();
    }

    @Override
    public ActionGroup createActions() {
        return ActionGroup.create((Object)this.getObjectModel());
    }

    @Override
    public TreeNode createInner(CatalogObject innerTypeModel, long modifiers) {
        CatalogObjectTypeTreeNode result = new CatalogObjectTypeTreeNode(innerTypeModel);
        result.modifiers = modifiers;
        return result;
    }

    @Override
    public boolean delete() {
        DeleteActionFactory.getDeleteActionFor((ProjectObject)this.getObjectModel()).run();
        return true;
    }

    @Override
    public void removeFromRepository() throws TypeCatalogException {
        MutableComponentCatalog catalogRepository = (MutableComponentCatalog)this.getProject().getComponentCatalog();
        catalogRepository.remove(this.getObjectRef().getText());
    }

    @Override
    public String toString() {
        if (this.getMsg() != null) {
            return this.getMsg().toString();
        }
        return this.getObjectModel().getName();
    }

    @Override
    public TreeNode asTreeNode() {
        return this;
    }

    @Override
    public Exception debugInfo() {
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void relationAdded(Object object, String relationName) {
        this.nodeChanged();
        this.loadMembers();
    }

    @Override
    public void relationRemoved(Object object, String relationName) {
        this.nodeChanged();
        this.loadMembers();
    }

    public TypeRef getObjectRef() {
        return this.getObjectModel().getDynamicRef();
    }

    @Override
    protected int getMultipleActionsMask() {
        ObjectTypeDescription objectType = this.getObject();
        if (objectType.isDefault()) {
            return 0;
        }
        boolean isGroup = objectType.isInnerType();
        int mask = 23;
        if (!isGroup) {
            mask |= 8;
        }
        if (Modifier.isHidden(this.getObjectRef().getModifiers())) {
            mask |= 0x40;
        } else if (!HideComponentAction.isUIHidden(this.getObjectRef().get().getParent())) {
            mask |= 0x20;
        }
        return mask;
    }

    protected void addCommonActions() {
        super.addCommonActions();
        ObjectTypeDescription objectType = this.getObject();
        if (!(this.isProjectCatalogRoot() || objectType.isDefault() || objectType.isInnerType())) {
            this.getCommonActionsMap().put("delete-action", DeleteActionFactory.getDeleteActionFor((ProjectObject)this.getObjectModel()));
        }
    }

    protected void removeListeners() {
        super.removeListeners();
        TypeRef ref = this.getTypeRef();
        if (ref != null) {
            ref.removeObserver(this.typeObserver);
            if (this.listenersAdded) {
                ref.get().removeRelationObserver("members", this);
                ref.get().removeRelationObserver("presentation", this);
                this.listenersAdded = false;
            }
        }
    }

    private String formatErrorMsg() {
        String result = null;
        ErrorSource errorSource = (ErrorSource)this.objectModel;
        if (errorSource.hasErrors()) {
            StringBuilder builder = new StringBuilder();
            List projectExceptions = errorSource.getErrors();
            for (ProjectException projectException : projectExceptions) {
                Throwable current = projectException;
                ProjectException rootCause = current;
                while (current != null) {
                    rootCause = current;
                    current = rootCause.getCause();
                }
                builder.append(rootCause.getMessage());
            }
            result = builder.toString();
        }
        return result;
    }

    private boolean isDeprecated() {
        return Modifier.isDeprecated(this.getObjectRef().getModifiers());
    }

    private boolean isProjectInherited() {
        return !this.getTypeRef().getCatalog().isReadOnly() && this.getTypeRef().getCatalog() != this.getProject().getComponentCatalog();
    }

    private void initTypeObserverListener() {
        this.typeObserver = new UiTypeObserverDecorator(new TypeObserverImpl(){

            @Override
            public void typeChanged(TypeRef thisType) {
                CatalogObjectTypeTreeNode.this.nodeChanged();
                if (CatalogObjectTypeTreeNode.this.typeDescription != thisType.get()) {
                    CatalogObjectTypeTreeNode.this.typeDescription.removeRelationObserver("members", CatalogObjectTypeTreeNode.this);
                    CatalogObjectTypeTreeNode.this.typeDescription.removeRelationObserver("presentation", CatalogObjectTypeTreeNode.this);
                    CatalogObjectTypeTreeNode.this.typeDescription = thisType.get();
                    CatalogObjectTypeTreeNode.this.onLoading();
                }
            }
        });
        this.getObjectRef().addObserver(this.typeObserver);
        this.typeDescription = this.getObjectModel().getDelegate();
    }

    private void initRootData() {
        if (!this.initialized) {
            this.initialized = true;
            this.objectModel = CatalogObjectImpl.create((Project)this.getProject(), (TypeRef)this.getObjectRef());
        }
    }

    private ComponentCatalog getCatalog() {
        return this.getProject().getComponentCatalog();
    }

    private boolean isHidden() {
        return this.getObjectModel().isHidden();
    }

    private void loadMembers() {
        Tree tree = this.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        boolean groupInheritedMembers = false;
        boolean isMutable = this.isMutable();
        boolean showMethod = true;
        boolean showAttributes = true;
        boolean showPresentations = true;
        boolean showDelegated = false;
        boolean showInherited = false;
        boolean showGroups = false;
        boolean showProjectInherited = false;
        this.getCatalogNodeLoader().load(this.getObjectModel(), this, false, isMutable, showMethod, showAttributes, showPresentations, false, false, showGroups, this.modifiers, showProjectInherited);
    }

    private CatalogNodeLoader getCatalogNodeLoader() {
        if (this.catalogNodeLoader == null) {
            this.catalogNodeLoader = new CatalogNodeLoader(this.getProject());
        }
        return this.catalogNodeLoader;
    }
}

