/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.tree;

import java.util.Comparator;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.SeparatorTreeNode;
import oracle.bpm.designer.StudioTree;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.PathAction;
import oracle.bpm.designer.catalog.tree.AttributeMemberAccessorTreeNode;
import oracle.bpm.designer.catalog.tree.CatalogObjectNode;
import oracle.bpm.designer.catalog.tree.ObjectAttributeMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectMethodMemberTreeNode;
import oracle.bpm.designer.catalog.tree.ObjectPresentationTreeNode;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class CatalogNodeLoader {
    private StringList delegatedList;
    private Project project;
    private StringList typeList;

    public CatalogNodeLoader(Project project) {
        this.project = project;
        this.typeList = StringList.create();
        this.delegatedList = StringList.create();
    }

    public static TreeNode createInner(TreeNode node, CatalogObject model, long modifiers) {
        TreeNode treeNode = node;
        TreeNode groupNode = null;
        if (node instanceof CatalogObjectNode) {
            CatalogObjectNode catalogObjectNode = (CatalogObjectNode)node;
            groupNode = catalogObjectNode.createInner(model, modifiers);
        } else if (node instanceof SeparatorTreeNode && treeNode.getParent() instanceof CatalogObjectNode) {
            groupNode = ((CatalogObjectNode)treeNode.getParent()).createInner(model, modifiers);
        }
        return groupNode;
    }

    public static boolean shouldAddReadAccessor(AttributeTypeDescription member) {
        return !(!member.isVirtual() && !Modifier.hasGetter(member.getModifiers()) || member.getCode() != null && !member.getCode().isEmpty());
    }

    public static boolean shouldAddWriteAccessor(AttributeTypeDescription member) {
        return (member.isVirtual() || Modifier.hasSetter(member.getModifiers())) && member.getWriteCode() == null;
    }

    public static void insertPropertyAccessMethods(ObjectAttributeMemberTreeNode parent) {
        CatalogNodeLoader.insertPropertyAccessMethods(parent, true);
    }

    public static void insertPropertyAccessMethods(ObjectAttributeMemberTreeNode parent, boolean fireEvents) {
        AttributeMemberAccessorTreeNode acc;
        AttributeTypeDescription member = (AttributeTypeDescription)parent.getMember();
        boolean addRead = (member.isVirtual() || parent.getMember().hasGetter()) && parent.getMember().asAttribute().getCode() != null;
        boolean addWrite = (member.isVirtual() || Modifier.hasSetter(parent.getMember().getModifiers())) && parent.getMember().asAttribute().getWriteCode() != null;
        AttributeMemberAccessorTreeNode prevGetter = CatalogNodeLoader.findAccessorNode(parent, 8);
        AttributeMemberAccessorTreeNode prevSetter = CatalogNodeLoader.findAccessorNode(parent, 7);
        boolean changed = false;
        if (addRead && prevGetter == null) {
            acc = new AttributeMemberAccessorTreeNode(8, member);
            parent.add(acc);
            changed = true;
        }
        if (!addRead && prevGetter != null) {
            parent.remove(prevGetter);
            changed = true;
        }
        if (addWrite && prevSetter == null) {
            acc = new AttributeMemberAccessorTreeNode(7, member);
            parent.add(acc);
            changed = true;
        }
        if (!addWrite && prevSetter != null) {
            parent.remove(prevSetter);
            changed = true;
        }
        if (fireEvents && changed) {
            parent.nodeChanged();
        }
    }

    public static synchronized CatalogObject getCatalogObjectModel(TypeRef type) {
        return CatalogObjectImpl.create((TypeRef)type);
    }

    public static synchronized CatalogObject getCatalogObjectModel(Project project, TypeRef type) {
        return CatalogObjectImpl.create((Project)project, (TypeRef)type);
    }

    public CatalogObject getInnerTypeModel(TypeRef inner) {
        return CatalogNodeLoader.getCatalogObjectModel(this.project, inner);
    }

    public void load(CatalogObject catalogObjectModel, CatalogObjectNode fuegoTreeNode, boolean groupInheritedMembers, boolean isMutable, boolean showMethods, boolean showAttributes, boolean showPresentations, boolean showDelegated, boolean showInherited, boolean showGroups, long modifiers, boolean showProjectInherited) {
        fuegoTreeNode.asTreeNode().removeAllChildren();
        this.addMembersFrom(fuegoTreeNode.asTreeNode(), modifiers, catalogObjectModel.getDelegate(), groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited, true);
    }

    public void createGroup(Tree tree, TreeNode node, AttributeTypeDescription member, TreeNode parent, long modifiers) {
        TreeNode groupNode;
        TypeDescription type = member.getType();
        if (type.isArray()) {
            type = type.getElementType();
        }
        if ((groupNode = CatalogNodeLoader.createInner(node, this.getInnerTypeModel(type.getRef()), modifiers)) != null) {
            tree.insertNodeInto(groupNode, parent, 0, false);
        }
    }

    private static AttributeMemberAccessorTreeNode findAccessorNode(ObjectAttributeMemberTreeNode parent, int accessorType) {
        AttributeMemberAccessorTreeNode result = null;
        for (TreeNode node : parent.getChildren()) {
            AttributeMemberAccessorTreeNode accessorNode;
            if (!(node instanceof AttributeMemberAccessorTreeNode) || (accessorNode = (AttributeMemberAccessorTreeNode)node).getAccessorType() != accessorType) continue;
            result = accessorNode;
            break;
        }
        return result;
    }

    private void addDelegatedMembers(ObjectTypeDescription otd, TreeNode fuegoTreeNode, boolean groupInheritedMembers, boolean isMutable, boolean showMethods, boolean showAttributes, boolean showPresentations, boolean showDelegated, boolean showInherited, boolean showGroups, boolean showProjectInherited) {
        showPresentations = false;
        this.delegatedList.add(otd.getText());
        for (SuperType superType : otd.getSuperTypes()) {
            TypeRef cl = superType.getTypeRef();
            if (!superType.isDelegated() || superType.isHidden() || this.delegatedList.contains(cl.getText()) || cl.get().equals(TypeFactory.getNone())) continue;
            SeparatorTreeNode node = this.addSeparatorNode(cl, fuegoTreeNode);
            if (groupInheritedMembers) {
                this.addMembersFrom(node, 0x800000L, cl, groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited, false);
                continue;
            }
            this.addMembersFrom(fuegoTreeNode, 0x800000L, cl, groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited, false);
        }
    }

    private void addInheritedMembers(ObjectTypeDescription otd, TreeNode fuegoTreeNode, boolean groupInheritedMembers, boolean isMutable, boolean showMethods, boolean showAttributes, boolean showPresentations, boolean showDelegated, boolean showInherited, boolean showGroups, boolean showProjectInherited) {
        for (SuperType superType : otd.getSuperTypes()) {
            boolean hideSuperType = this.hideSuperType(superType.getTypeRef());
            boolean hidden = superType.isHidden();
            boolean isDelegated = superType.isDelegated();
            if (isDelegated || hidden || hideSuperType) continue;
            TypeRef cl = superType.getTypeRef();
            SeparatorTreeNode node = this.addSeparatorNode(cl, fuegoTreeNode);
            if (groupInheritedMembers) {
                this.addMembersFrom(node, 524288L, cl, groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited, false);
                continue;
            }
            this.addMembersFrom(fuegoTreeNode, 524288L, cl, groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited, false);
        }
    }

    private void addMembersFrom(TreeNode fuegoTreeNode, long mods, TypeRef td, boolean groupInheritedMembers, boolean isMutable, boolean showMethods, boolean showAttributes, boolean showPresentations, boolean showDelegated, boolean showInherited, boolean showGroups, boolean showProjectInherited, boolean showConstructors) {
        Comparator<TreeNode> nodeComparator = FuegoObjectAction.getFuegoObjectTreeNodeComparator();
        StudioTree studioTree = (StudioTree)fuegoTreeNode.getTree();
        if (studioTree == null) {
            return;
        }
        ObjectTypeDescription otd = td.get().asObject();
        CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)otd);
        long excludeMods = 0x102000000L;
        for (MethodTypeDescription member : otd.getMemberTypes(-1, 0L, excludeMods)) {
            boolean exactMatch;
            CatalogMember catalogMember = catalogObject.findMember(member.getName());
            ObjectMemberTreeNode newChild = null;
            TreeNode match = PathAction.find(fuegoTreeNode, new String[]{PathAction.NAME_ID + fuegoTreeNode.toString(), PathAction.MEMBER_ID + member.getName()});
            if (match instanceof ObjectMethodMemberTreeNode) {
                MethodTypeDescription mtdMatch = ((ObjectMethodMemberTreeNode)match).getMember();
                exactMatch = member.matchArguments(mtdMatch, false);
            } else {
                boolean bl = exactMatch = match != null;
            }
            if (exactMatch) continue;
            if (showConstructors || !member.isConstructor()) {
                if (isMutable) {
                    if (showMethods && member.isMethod()) {
                        newChild = new ObjectMethodMemberTreeNode(catalogMember);
                    } else if (showAttributes && member.isAttribute()) {
                        newChild = new ObjectAttributeMemberTreeNode(catalogMember);
                    }
                } else if (showAttributes) {
                    newChild = new ObjectMethodMemberTreeNode(catalogMember);
                }
            }
            if (newChild == null) continue;
            studioTree.insertSortedNode(newChild, fuegoTreeNode, nodeComparator, false);
            if (!isMutable || !member.isAttribute()) continue;
            if (XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)member.asAttribute())) {
                this.createGroup((Tree)studioTree, fuegoTreeNode, member.asAttribute(), newChild, mods);
                continue;
            }
            if (!(newChild instanceof ObjectAttributeMemberTreeNode)) continue;
            CatalogNodeLoader.insertPropertyAccessMethods((ObjectAttributeMemberTreeNode)newChild, false);
        }
        if (showInherited) {
            this.addInheritedMembers(otd, fuegoTreeNode, groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited);
        }
        if (showDelegated) {
            this.addDelegatedMembers(otd, fuegoTreeNode, groupInheritedMembers, isMutable, showMethods, showAttributes, showPresentations, showDelegated, showInherited, showGroups, showProjectInherited);
        }
        int innerCount = otd.getInnerTypeCount();
        for (int i = 0; i < innerCount; ++i) {
            CatalogObject catalogObjectModel;
            TreeNode newChild;
            TypeRef typeRef = otd.getInnerTypeRef(i);
            if (!showProjectInherited && this.isProjectInherited(typeRef) || (newChild = CatalogNodeLoader.createInner(fuegoTreeNode, catalogObjectModel = CatalogNodeLoader.getCatalogObjectModel(this.project, typeRef), mods)) == null) continue;
            studioTree.insertSortedNode(newChild, fuegoTreeNode, nodeComparator, false);
        }
        if (showPresentations && otd instanceof XObjectTypeDescription) {
            for (XFormPresentationModel element : ((XObjectTypeDescription)otd).getPModels()) {
                if (!(fuegoTreeNode instanceof CatalogObjectNode)) continue;
                CatalogObjectNode catalogObjectNode = (CatalogObjectNode)fuegoTreeNode;
                ObjectPresentationTreeNode newChild = new ObjectPresentationTreeNode(element, catalogObjectNode.getTypeRef().get().asObject());
                studioTree.insertSortedNode(newChild, fuegoTreeNode, nodeComparator, false);
            }
        }
    }

    private boolean isProjectInherited(TypeRef typeRef) {
        return !typeRef.getCatalog().isReadOnly() && typeRef.getCatalog() != this.project.getComponentCatalog();
    }

    private SeparatorTreeNode addSeparatorNode(TypeRef cl, TreeNode fuegoTreeNode) {
        SeparatorTreeNode sep = new SeparatorTreeNode(cl.getText());
        fuegoTreeNode.getTree().insertSortedNode((TreeNode)sep, fuegoTreeNode, FuegoObjectAction.getFuegoObjectTreeNodeComparator(), false);
        sep.getChildCount();
        return sep;
    }

    private boolean hideSuperType(TypeRef superType) {
        return superType.get() == TypeFactory.getAny() || superType.getText().startsWith("Fuego.Internal") || this.typeList.contains(superType.getText());
    }
}

