/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.panel;

import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.BPMObjectAttributeInputValidator;
import oracle.bpm.designer.action.ChangeAttributeVirtualAction;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.RenameGroupAction;
import oracle.bpm.designer.action.RenameMemberAction;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FOAttributePropertiesPanelEnabler;
import oracle.bpm.designer.catalog.panel.CatalogObjectProperty;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.table.ProviderTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogObjectTableModel
extends ProviderTableModel<CatalogMember> {
    @NotNull
    private final CatalogObject catalogObject;

    public CatalogObjectTableModel(@NotNull CatalogObject catalogObject) {
        super(CatalogObjectProperty.asMessageList());
        this.catalogObject = catalogObject;
        this.initData();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result = !this.getCatalogObject().isReadOnly();
        result &= this.isRowEditable(rowIndex);
        return result &= this.isColumnEditable((CatalogMember)this.getRow(rowIndex), CatalogObjectProperty.propertyAt(columnIndex));
    }

    public boolean isRowEditable(int row) {
        return true;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        CatalogMember catalogMember = (CatalogMember)this.getRow(rowIndex);
        MethodTypeDescription member = catalogMember.getMemberType();
        Object result = null;
        switch (CatalogObjectProperty.propertyAt(columnIndex)) {
            case NAME: {
                result = catalogMember;
                break;
            }
            case PRIMARY_KEY: {
                result = member.isAttribute() && member.asAttribute().isPrimaryKey();
                break;
            }
            case VIRTUAL: {
                result = member.isAttribute() && member.asAttribute().isVirtual();
                break;
            }
            case TYPE: {
                result = member.getResultType();
                break;
            }
            case NOT_NULL: {
                result = member.isAttribute() && member.asAttribute().isRequired();
                break;
            }
            case DEFAULT_VALUE: {
                result = member.isAttribute() ? member.asAttribute().getDefaultValue() : "";
            }
        }
        return result;
    }

    public Class<?> getColumnClass(int columnIndex) {
        CatalogObjectProperty property = CatalogObjectProperty.propertyAt(columnIndex);
        return property.getPropertyClazz();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isRowEditable(rowIndex)) {
            return;
        }
        CatalogMember member = (CatalogMember)this.getRow(rowIndex);
        AttributeTypeDescription currentAttribute = member.getMemberType().asAttribute();
        switch (CatalogObjectProperty.propertyAt(columnIndex)) {
            case PRIMARY_KEY: {
                boolean isPrimaryKey = (Boolean)aValue;
                currentAttribute.setPrimaryKey(isPrimaryKey);
                break;
            }
            case VIRTUAL: {
                new ChangeAttributeVirtualAction(currentAttribute, (Boolean)aValue).doIt();
                break;
            }
            case NAME: {
                String value = (String)aValue;
                if (BpmObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)currentAttribute)) {
                    new RenameGroupAction(currentAttribute, value).doIt();
                    break;
                }
                try {
                    new BPMObjectAttributeInputValidator(currentAttribute.getParent().asObject()).validate(value);
                }
                catch (InputValidationException e) {
                    break;
                }
                new RenameMemberAction(currentAttribute, value).doIt();
                break;
            }
            case TYPE: {
                currentAttribute.setType((TypeDescription)aValue);
                break;
            }
            case NOT_NULL: {
                currentAttribute.setRequired((Boolean)aValue);
                break;
            }
            case DEFAULT_VALUE: {
                currentAttribute.setDefaultValue(String.valueOf(aValue));
            }
        }
        if (this.isGroupAttribute(member)) {
            CatalogObject catalogObject = CatalogObjectImpl.create((TypeRef)currentAttribute.getParent());
            FuegoObjectAction.storeObjectIfEditorIsNotActive(catalogObject);
        }
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    public boolean canMoveRowDown(int row) {
        return this.isRowEditable(row) && super.canMoveRowDown(row) && this.getNextRow(row) != row;
    }

    public boolean moveRowDown(int row) {
        return super.moveRowDown(row);
    }

    public boolean canMoveRowUp(int row) {
        return this.isRowEditable(row) && super.canMoveRowUp(row) && this.getPrevRow(row) != row;
    }

    public boolean moveRowUp(int row) {
        return super.moveRowUp(row);
    }

    @NotNull
    ComponentCatalog getComponentCatalog() {
        return this.catalogObject.asBpmObject().getObjectType().getCatalog();
    }

    private boolean isColumnEditable(CatalogMember member, CatalogObjectProperty property) {
        boolean result = false;
        FOAttributePropertiesPanelEnabler enabler = new FOAttributePropertiesPanelEnabler(member);
        switch (property) {
            case NAME: {
                result = true;
                break;
            }
            case PRIMARY_KEY: {
                result = enabler.canChangePrimaryKey();
                break;
            }
            case VIRTUAL: {
                result = enabler.canChangeVirtual();
                break;
            }
            case TYPE: {
                result = enabler.isTypeChangeAllowed();
                break;
            }
            case NOT_NULL: {
                result = enabler.canSetNotNull();
                break;
            }
            case DEFAULT_VALUE: {
                result = enabler.canSetDefaultValue();
            }
        }
        return result;
    }

    private int getNextRow(int row) {
        if (row < this.getRowCount() - 1) {
            TypeDescription mtdParent = ((CatalogMember)this.getRow(row)).getMemberType().getParent();
            for (int i = row + 1; i < this.getRowCount(); ++i) {
                if (((CatalogMember)this.getRow(i)).getMemberType().getParent() != mtdParent) continue;
                return i;
            }
        }
        return row;
    }

    private int getPrevRow(int row) {
        if (row > 0) {
            TypeDescription mtdParent = ((CatalogMember)this.getRow(row)).getMemberType().getParent();
            for (int i = row - 1; i >= 0; --i) {
                if (((CatalogMember)this.getRow(i)).getMemberType().getParent() != mtdParent) continue;
                return i;
            }
        }
        return row;
    }

    private boolean isGroupAttribute(CatalogMember member) {
        ObjectTypeDescription otd;
        MethodTypeDescription mtd;
        MethodTypeDescription methodTypeDescription = mtd = member != null ? member.getMemberType() : null;
        if (mtd != null && mtd.getParent() != null && (otd = mtd.getParent().asObject()).isBpmObject()) {
            return false;
        }
        return false;
    }

    private void initData() {
        for (CatalogMember member : this.getAttributesFromCatalogObject()) {
            this.addRow(member);
        }
    }

    private Sequence<CatalogMember> getAttributesFromCatalogObject() {
        return this.getCatalogObject().getChildrenByType(CatalogMember.class).select(new Predicate<CatalogMember>(){

            @Override
            public boolean check(@Nullable CatalogMember value) {
                return value.isAttribute();
            }
        });
    }

    @NotNull
    private CatalogObject getCatalogObject() {
        return this.catalogObject;
    }
}

