/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.panel;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.ExternalEditorSupport;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.NewAttributeAction;
import oracle.bpm.designer.catalog.panel.CatalogObjectHeaderPanel;
import oracle.bpm.designer.catalog.panel.CatalogObjectTable;
import oracle.bpm.designer.catalog.panel.CatalogObjectTableModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;

public class BpmObjectPanel
extends CatalogObjectEditor {
    private BaseAction addMember;
    private TabbedPane container;
    private boolean enableMultiTab = false;
    private ProjectListener<CatalogMember> membersListener;
    private CatalogObjectTableModel model;
    private BaseAction removeMember;
    private CatalogObjectTable table;

    public BpmObjectPanel(UiContainer parent, BpmObject catalogObject) {
        super(parent, (CatalogObject)catalogObject);
    }

    @Override
    public void setExternalEditorSupport(ExternalEditorSupport support) {
        super.setExternalEditorSupport(support);
        Sequence members = this.getProjectObject().getChildrenByType(CatalogMember.class);
        if (this.enableMultiTab) {
            for (CatalogMember member : members) {
                if (!member.isMethod()) continue;
                String name = member.getName();
                this.container.addTab(Msg.QUOTE(name), this.getExternalEditorSupport().openEditor((ProjectObject)member, (UiContainer)this.container));
            }
        }
    }

    @Override
    public void openPart(Object part) {
        if (part instanceof CatalogMember) {
            CatalogMember member = (CatalogMember)part;
            int index = this.model.getData().indexOf(member);
            if (index != -1) {
                this.table.setSelectionInterval(index, index);
            }
        }
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.FOBJECT;
    }

    @Override
    public void disposeEditor() {
        super.disposeEditor();
        this.getProjectObject().getProject().removeListener(this.getMembersListener());
    }

    @Override
    public BpmObject getProjectObject() {
        return (BpmObject)super.getProjectObject();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        if (this.enableMultiTab) {
            this.container = new TabbedPane(parent, 3);
            parent.setLayout((Layout)new BorderLayout());
            Panel structure = this.createStructure((UiContainer)this.container);
            this.container.addTab(DesignerMsg.BPMN, (UiComponent)structure);
            parent.add((UiComponent)this.container, (Object)"Center");
        } else {
            parent.add((UiComponent)this.createStructure(parent));
        }
        this.getProjectObject().getProject().addListener(this.getMembersListener());
        this.updateActionsSelection();
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }

    private Panel createStructure(UiContainer parent) {
        Panel structure = new Panel(parent);
        Panel tableAndToolbar = new Panel((UiContainer)structure);
        tableAndToolbar.setLayout((Layout)new BorderLayout());
        this.model = new CatalogObjectTableModel((CatalogObject)this.getProjectObject());
        this.table = CatalogObjectTable.create((UiContainer)tableAndToolbar, this.model);
        this.table.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                BpmObjectPanel.this.updateActionsSelection();
            }
        });
        tableAndToolbar.add((UiComponent)this.table, (Object)"Center");
        ToolBar toolBar = this.createActionsToolBar((UiContainer)tableAndToolbar);
        tableAndToolbar.add((UiComponent)toolBar, (Object)"East");
        String columns = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref,5dlu, fill:pref:grow, 5dlu";
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref,5dlu, fill:pref:grow, 5dlu");
        PanelBuilder builder = new PanelBuilder(layout, (UiContainer)structure);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)new CatalogObjectHeaderPanel((UiContainer)structure, (CatalogObject)this.getProjectObject()), cc.xy(2, 2));
        builder.add((UiComponent)tableAndToolbar, cc.xy(2, 4));
        return structure;
    }

    private Panel createStructure1(UiContainer parent) {
        Panel structure = new Panel(parent);
        CatalogObjectHeaderPanel headerPanel = new CatalogObjectHeaderPanel((UiContainer)structure, (CatalogObject)this.getProjectObject());
        Panel tableAndToolbar = new Panel((UiContainer)structure);
        tableAndToolbar.setLayout((Layout)new BorderLayout());
        this.model = new CatalogObjectTableModel((CatalogObject)this.getProjectObject());
        this.table = CatalogObjectTable.create((UiContainer)tableAndToolbar, this.model);
        this.table.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                BpmObjectPanel.this.updateActionsSelection();
            }
        });
        ToolBar toolBar = this.createActionsToolBar((UiContainer)tableAndToolbar);
        tableAndToolbar.add((UiComponent)this.table, (Object)"Center");
        tableAndToolbar.add((UiComponent)toolBar, (Object)"East");
        String columns = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref,5dlu, fill:pref:grow, 5dlu";
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref,5dlu, fill:pref:grow, 5dlu");
        PanelBuilder builder = new PanelBuilder(layout, (UiContainer)structure);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)headerPanel, cc.xy(2, 2));
        builder.add((UiComponent)tableAndToolbar, cc.xy(2, 4));
        return structure;
    }

    private void updateActionsSelection() {
        this.addMember.setSelection(DefaultSelection.createSingle((Object)this.getProjectObject()));
        this.removeMember.setSelection(DefaultSelection.createSingle((Object)this.table.getSelectedMember()));
    }

    private ToolBar createActionsToolBar(UiContainer parent) {
        this.initActions();
        ToolBar toolBar = new ToolBar(parent, ToolBar.VERTICAL);
        toolBar.add(this.addMember);
        toolBar.add(this.removeMember);
        return toolBar;
    }

    private void initActions() {
        this.addMember = new AddMemberAction();
        this.removeMember = new RemoveMemberAction();
    }

    private ProjectListener<CatalogMember> getMembersListener() {
        if (this.membersListener == null) {
            this.membersListener = new ProjectListenerAdapter<CatalogMember>(CatalogMember.class){

                public void postObjectAdded(CatalogMember member, ProjectObject parent) {
                    if (member.getParentObject() == BpmObjectPanel.this.getProjectObject()) {
                        BpmObjectPanel.this.model.addRow(member);
                    }
                }

                public void postObjectRemoved(CatalogMember member, ProjectObject parent) {
                    if (member.getParentObject() == BpmObjectPanel.this.getProjectObject()) {
                        BpmObjectPanel.this.model.removeRow(BpmObjectPanel.this.model.getRowIndex(member));
                    }
                }
            };
        }
        return this.membersListener;
    }

    private static class RemoveMemberAction
    extends BaseAction {
        private RemoveMemberAction() {
            super(UIMsg.REMOVE);
            this.requires(CatalogMember.class);
        }

        public void run() {
            CatalogMember member = (CatalogMember)this.getSelection().as(CatalogMember.class);
            DeleteActionFactory.getDeleteActionFor((ProjectObject)member).run();
        }
    }

    private static class AddMemberAction
    extends BaseAction {
        private AddMemberAction() {
            super(UIMsg.ADD);
            this.requires(BpmObject.class);
        }

        public void run() {
            NewAttributeAction.silentCreate((BpmObject)this.getSelection().as(BpmObject.class));
        }
    }
}

