/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.enumeration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.catalog.enumeration.EnumPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.AbstractTableModel;

class EnumTableModel
extends AbstractTableModel {
    private StringList names;
    private EnumPanel panel;
    private boolean sequential;
    private List<Integer> values;

    public EnumTableModel(EnumPanel panel) {
        this.panel = panel;
        this.names = StringList.create();
        this.values = new ArrayList<Integer>();
    }

    public String getColumnName(int column) {
        Msg msg = column == 0 ? ProjectDrawMsg.NAME : DesignerMsg.VALUE;
        return msg.getString();
    }

    public boolean isCellEditable(int row, int column) {
        return !this.panel.isReadOnly();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? String.class : Integer.class;
    }

    public int getColumnCount() {
        return this.sequential ? 1 : 2;
    }

    public int getRowCount() {
        return this.names.size();
    }

    public void setValueAt(Object value, int row, int column) {
        if (column == 0) {
            this.names.set(row, value == null ? "" : (String)value);
        } else {
            this.values.set(row, (Integer)value);
        }
        this.fireTableCellUpdated(row, column);
    }

    public Object getValueAt(int row, int column) {
        return column == 0 ? this.getName(row) : this.getValue(row);
    }

    public Integer getValue(int row) {
        return this.values.get(row);
    }

    public String getName(int row) {
        return (String)this.names.get(row);
    }

    public void removeRow(int row) {
        this.names.remove(row);
        this.values.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void addRow(String name, int value) {
        int row = this.names.size();
        this.names.add(name);
        this.values.add(value);
        this.fireTableRowsInserted(row, row);
    }

    public void moveRowUp(int row) {
        if (row > 0) {
            Collections.swap(this.names, row - 1, row);
            Collections.swap(this.values, row - 1, row);
            this.fireTableRowsUpdated(row - 1, row);
        }
    }

    public void moveRowDown(int row) {
        if (row + 1 < this.names.size()) {
            Collections.swap(this.names, row, row + 1);
            Collections.swap(this.values, row, row + 1);
            this.fireTableRowsUpdated(row, row + 1);
        }
    }

    public void setSequential(boolean b) {
        this.sequential = b;
    }
}

