/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.enumeration;

import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.catalog.enumeration.EnumTableModel;
import oracle.bpm.designer.catalog.panel.CatalogObjectHeaderPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableAdapter;
import oracle.bpm.ui.table.TableListener;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.IdentifierTextFieldEditor;
import oracle.bpm.ui.table.editors.NumericFieldCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;

public class EnumPanel
extends CatalogObjectEditor {
    private BaseAction addRowAction;
    private boolean buildingUi;
    private DocumentListener documentListener;
    private EnumTableModel memberModel;
    private Table memberTable;
    private BaseAction moveDownAction;
    private BaseAction moveUpAction;
    private BaseAction removeRowAction;
    private CheckBox sequential;
    static final int NAME_COLUMN = 0;
    static final int VALUE_COLUMN = 1;

    public EnumPanel(UiContainer parent, CatalogObject enumType) {
        super(parent, enumType);
    }

    public EnumTypeDescription getComponent() {
        return (EnumTypeDescription)((Object)((CatalogObject)this.getProjectObject()).getObjectType());
    }

    public String getName() {
        return this.getComponent().getText();
    }

    public Dimension getPreferredSize() {
        Dimension screenSize = Ui.getToolkit().getScreenSize();
        int width = (int)((double)screenSize.getWidth() * 0.65);
        int height = (int)((double)screenSize.getHeight() * 0.7);
        return Dimension.valueOf(width, height);
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.ENUM;
    }

    @Override
    public boolean checkPanelData() {
        boolean result = true;
        try {
            int j;
            String item;
            int i;
            this.stopEditing();
            int rows = this.memberModel.getRowCount();
            for (i = 0; i < rows && !"".equals(item = this.memberModel.getName(i)); ++i) {
                if (item.indexOf(32) >= 0) {
                    MessageDialog.showError((Msg)DesignerMsg.ENUM_ID_CANNOT_CONTAIN_BLANKS(item));
                    result = false;
                }
                for (j = i + 1; j < rows; ++j) {
                    if (!this.memberModel.getName(j).equals(item)) continue;
                    MessageDialog.showError((Msg)DesignerMsg.ENUM_ID_DUPLICATED(item, i, j));
                    result = false;
                }
            }
            if (!this.getComponent().isSequential()) {
                for (i = 0; i < rows; ++i) {
                    Integer value = this.memberModel.getValue(i);
                    if (value == null) {
                        MessageDialog.showError((Msg)DesignerMsg.ENUM_WITHOUT_VALUE(this.memberModel.getName(i)));
                        result = false;
                        continue;
                    }
                    for (j = i + 1; j < rows; ++j) {
                        if (!value.equals(this.memberModel.getValue(j))) continue;
                        MessageDialog.showError((Msg)DesignerMsg.ENUM_VALUE_DUPLICATED(this.memberModel.getName(i), this.memberModel.getName(j), value));
                        result = false;
                    }
                }
            }
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
            result = false;
        }
        return result;
    }

    @Override
    public boolean doUpdate() {
        return !this.buildingUi && this.checkPanelData();
    }

    public boolean updateTypeDescription() {
        String item;
        this.getComponent().setSequential(this.sequential.isSelected());
        this.getComponent().removeMembers();
        for (int i = 0; i < this.memberModel.getRowCount() && !"".equals(item = this.memberModel.getName(i)); ++i) {
            if (this.sequential.isSelected()) {
                this.getComponent().addItem(item);
                continue;
            }
            Integer value = this.memberModel.getValue(i);
            this.getComponent().addItem(item, value == null ? i : value);
        }
        return true;
    }

    @Override
    protected void buildUI(UiContainer parent) {
        this.buildingUi = true;
        this.setReadOnly(this.getCatalogRepository(this.getComponent()).isReadOnly(this.getComponent()));
        Panel header = this.createHeaderPanel(parent);
        Panel tableAndToolbar = new Panel(parent);
        tableAndToolbar.setLayout((Layout)new BorderLayout());
        this.memberTable = this.buildTable((UiContainer)tableAndToolbar);
        tableAndToolbar.add((UiComponent)this.memberTable, (Object)"Center");
        ToolBar buttonPanel = this.createButtonPanel((UiContainer)tableAndToolbar);
        tableAndToolbar.add((UiComponent)buttonPanel, (Object)"East");
        String columns = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref,5dlu, fill:pref:grow, 5dlu";
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref,5dlu, fill:pref:grow, 5dlu");
        PanelBuilder builder = new PanelBuilder(layout, parent);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)header, cc.xy(2, 2));
        builder.add((UiComponent)tableAndToolbar, cc.xy(2, 4));
        this.addListeners();
        this.enableFields();
        this.buildingUi = false;
    }

    @Override
    protected void editorToObject() {
        if (!this.buildingUi) {
            if (this.memberTable != null && this.memberTable.getCellEditor() != null) {
                this.memberTable.getCellEditor().stopCellEditing();
            }
            this.updateTypeDescription();
        }
    }

    @Override
    protected void objectToEditor() {
    }

    private ToolBar createButtonPanel(UiContainer centerPanel) {
        ToolBar buttonPanel = new ToolBar(centerPanel, ToolBar.VERTICAL);
        this.buildAddRowAction();
        this.buildRemoveRowAction();
        this.buildMoveUpAction();
        this.buildMoveDownAction();
        buttonPanel.add(this.addRowAction);
        buttonPanel.add(this.removeRowAction);
        buttonPanel.addSeparator();
        buttonPanel.add(this.moveUpAction);
        buttonPanel.add(this.moveDownAction);
        this.checkButtons();
        return buttonPanel;
    }

    private Table buildTable(UiContainer centerPanel) {
        this.memberModel = new EnumTableModel(this);
        this.memberTable = new Table(centerPanel, (TableModel)this.memberModel, ListSelectionMode.SINGLE_SELECTION);
        IdentifierTextFieldEditor identifierEditor = new IdentifierTextFieldEditor();
        identifierEditor.setColumns(25);
        identifierEditor.setAllowsFirstInUpperCase(true);
        identifierEditor.addDocumentListener(this.getDocumentListener());
        NumericFieldCellEditor.IntegerFieldCellEditor numericEditor = NumericFieldCellEditor.createIntegerCellEditor();
        numericEditor.setColumns(3);
        numericEditor.setShowSpinner(false);
        numericEditor.addDocumentListener(this.getDocumentListener());
        this.memberTable.setDefaultEditor(String.class, (TableCellEditor)identifierEditor);
        this.memberTable.setDefaultEditor(Integer.class, (TableCellEditor)numericEditor);
        for (int i = 0; i < this.getComponent().getMemberCount(); ++i) {
            this.memberModel.addRow(this.getComponent().getMemberName(i), this.getComponent().getValue(i));
        }
        this.memberTable.setPreferredRows(5);
        this.memberTable.setRelativeSizes(new double[]{0.9, 0.1});
        boolean seq = this.getComponent().isSequential();
        this.renderTableAsSequential(seq);
        return this.memberTable;
    }

    private DocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                }

                public void removeUpdate(DocumentEvent e) {
                }
            };
        }
        return this.documentListener;
    }

    private Panel createHeaderPanel(UiContainer parent) {
        Panel container = new Panel(parent);
        container.setLayout((Layout)new BorderLayout(0, 5));
        CatalogObjectHeaderPanel header = new CatalogObjectHeaderPanel((UiContainer)container, (CatalogObject)this.getProjectObject());
        this.sequential = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.IS_SEQUENTIAL);
        this.sequential.setSelected(this.getComponent().isSequential());
        container.add((UiComponent)this.sequential, (Object)"South");
        container.add((UiComponent)header, (Object)"Center");
        return container;
    }

    private void buildMoveDownAction() {
        this.moveDownAction = new MoveDownAction();
    }

    private void buildMoveUpAction() {
        this.moveUpAction = new MoveUpAction();
    }

    private void buildRemoveRowAction() {
        this.removeRowAction = new RemoveAction();
    }

    private void buildAddRowAction() {
        this.addRowAction = new AddAction();
    }

    private MutableComponentCatalog getCatalogRepository(TypeRef ref) {
        return (MutableComponentCatalog)ref.getCatalog();
    }

    private void addListeners() {
        this.memberTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EnumPanel.this.checkButtons();
            }
        });
        this.memberTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() == -1) {
                    return;
                }
                EnumPanel.this.setDirty(true);
            }
        });
        this.memberTable.addTableListener((TableListener)new TableAdapter(){

            public boolean keyPressed(Table table, int row, KeyEvent e) {
                return false;
            }

            public void popupTriggered(Table table, int row, int key, MouseEvent e) {
                PopupMenu popup = new PopupMenu((UiContainer)table);
                popup.add(EnumPanel.this.moveUpAction);
                popup.add(EnumPanel.this.moveDownAction);
                popup.addSeparator();
                popup.add(EnumPanel.this.removeRowAction);
                Rectangle cellRect = table.getCellRect(row, 0, false);
                popup.show((UiComponent)table, cellRect.getX(), cellRect.getY());
            }
        });
        this.sequential.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (EnumPanel.this.memberModel == null) {
                    return;
                }
                EnumPanel.this.setDirty(true);
                boolean seq = EnumPanel.this.sequential.isSelected();
                EnumPanel.this.renderTableAsSequential(seq);
                EnumPanel.this.checkButtons();
            }
        });
    }

    private void renderTableAsSequential(boolean seq) {
        this.memberModel.setSequential(seq);
        if (seq) {
            this.memberTable.hideColumn(1);
        } else {
            this.memberTable.showColumn(1);
        }
    }

    private void checkButtons() {
        if (this.isReadOnly()) {
            return;
        }
        if (this.memberModel.getRowCount() == 0 || this.memberTable.getSelectedRow() == -1) {
            this.removeRowAction.setEnabled(false);
            this.moveUpAction.setEnabled(false);
            this.moveDownAction.setEnabled(false);
            return;
        }
        this.removeRowAction.setEnabled(true);
        this.moveUpAction.setEnabled(true);
        this.moveDownAction.setEnabled(true);
        if (this.memberTable.getSelectedRow() == 0) {
            this.moveUpAction.setEnabled(false);
        }
        if (this.memberTable.getSelectedRow() == this.memberTable.getRowCount() - 1) {
            this.moveDownAction.setEnabled(false);
        }
    }

    private void enableFields() {
    }

    private void stopEditing() {
        if (this.memberTable != null) {
            TableCellEditor cellEditor;
            int row = this.memberTable.getEditingRow();
            int column = this.memberTable.getEditingColumn();
            if (row >= 0 && column >= 0 && (cellEditor = this.memberTable.getCellEditor(row, column)) != null) {
                cellEditor.stopCellEditing();
            }
        }
    }

    private class RemoveAction
    extends BaseAction {
        public RemoveAction() {
            super(UIMsg.REMOVE);
        }

        public void run() {
            if (EnumPanel.this.isReadOnly()) {
                return;
            }
            EnumPanel.this.stopEditing();
            int rowSelected = EnumPanel.this.memberTable.getSelectedRow();
            if (rowSelected == -1) {
                MessageDialog.showError((Msg)DesignerMsg.NO_ROW_SELECTED);
                return;
            }
            EnumPanel.this.memberModel.removeRow(rowSelected);
            int rowCount = EnumPanel.this.memberTable.getRowCount();
            if (rowCount > rowSelected) {
                EnumPanel.this.memberTable.setSelectionInterval(rowSelected, rowSelected);
            } else if (rowCount > 0) {
                EnumPanel.this.memberTable.setSelectionInterval(rowSelected - 1, rowSelected - 1);
            }
            EnumPanel.this.checkButtons();
        }
    }

    private class MoveUpAction
    extends BaseAction {
        public MoveUpAction() {
            super(UIMsg.MOVE_UP);
        }

        public void run() {
            if (EnumPanel.this.isReadOnly()) {
                return;
            }
            EnumPanel.this.stopEditing();
            int rowSelected = EnumPanel.this.memberTable.getSelectedRow();
            if (rowSelected == -1) {
                MessageDialog.showError((Msg)DesignerMsg.NO_ROW_SELECTED);
                return;
            }
            EnumPanel.this.memberModel.moveRowUp(rowSelected);
            EnumPanel.this.memberTable.setSelectionInterval(rowSelected - 1, rowSelected - 1);
            EnumPanel.this.checkButtons();
        }
    }

    private class MoveDownAction
    extends BaseAction {
        public MoveDownAction() {
            super(UIMsg.MOVE_DOWN);
        }

        public void run() {
            if (EnumPanel.this.isReadOnly()) {
                return;
            }
            EnumPanel.this.stopEditing();
            int rowSelected = EnumPanel.this.memberTable.getSelectedRow();
            if (rowSelected == -1) {
                MessageDialog.showError((Msg)DesignerMsg.NO_ROW_SELECTED);
            } else {
                EnumPanel.this.memberModel.moveRowDown(rowSelected);
                EnumPanel.this.memberTable.setSelectionInterval(rowSelected + 1, rowSelected + 1);
                EnumPanel.this.checkButtons();
            }
        }
    }

    private class AddAction
    extends BaseAction {
        public AddAction() {
            super(UIMsg.ADD);
        }

        public void run() {
            if (EnumPanel.this.isReadOnly()) {
                return;
            }
            EnumPanel.this.stopEditing();
            EnumPanel.this.memberModel.addRow("", 0);
            int lastRow = EnumPanel.this.memberModel.getRowCount() - 1;
            EnumPanel.this.memberTable.requestFocus();
            EnumPanel.this.memberTable.setSelectionInterval(lastRow, lastRow);
            EnumPanel.this.memberTable.editCellAt(lastRow, 0);
            EnumPanel.this.setDirty(true);
        }
    }
}

