/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.components;

import java.util.Iterator;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.catalog.components.MemberEditorModel;
import oracle.bpm.designer.catalog.panel.CatalogObjectHeaderPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TreeTableColorProvider;
import oracle.bpm.ui.TreeTableFontProvider;
import oracle.bpm.ui.TreeTableLabelProvider;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.treetable.TreeTable;
import oracle.bpm.ui.treetable.TreeTableColumn;
import oracle.bpm.ui.treetable.TreeTableModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class ComponentStructurePanel
extends CatalogObjectEditor
implements ActionListener {
    private CatalogObjectHeaderPanel header;
    private MemberEditorModel memberModel;
    private TreeTable memberTable;
    private TreeNode outlineRoot;
    private CheckBox showHidden;

    public ComponentStructurePanel(UiContainer parent, CatalogObject catalogObject) {
        super(parent, catalogObject);
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.COMP_STRUCTURE;
    }

    @Override
    public String getPanelId() {
        return ((CatalogObject)this.getProjectObject()).getName();
    }

    public Dimension getPreferredSize() {
        Dimension screenSize = Ui.getToolkit().getScreenSize();
        int width = (int)((double)screenSize.getWidth() * 0.65);
        int height = (int)((double)screenSize.getHeight() * 0.7);
        return Dimension.valueOf(width, height);
    }

    @Override
    public String getTitle() {
        return this.getPanelId();
    }

    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public boolean checkPanelData() {
        return true;
    }

    @Deprecated
    public synchronized void refreshStructure() {
        int i;
        TreePath selectedPath = this.memberTable.getSelectionPath();
        TreePath treePath = TreePath.createSinglePath((Object)this.memberModel.getRoot());
        Iterator expandedPaths = this.memberTable.getExpandedDescendants(treePath);
        int[] widths = new int[this.memberTable.getColumnCount()];
        for (i = 0; i < widths.length; ++i) {
            widths[i] = this.memberTable.getColumn(i).getWidth();
        }
        this.memberModel = new ReadOnlyMemberEditorModel((CatalogObject)this.getProjectObject(), this.showHidden.isSelected());
        this.memberTable.setModel((TreeTableModel)this.memberModel);
        this.initTemplateRenderer();
        this.memberTable.repaint();
        while (expandedPaths != null && expandedPaths.hasNext()) {
            this.memberTable.expandPath((TreePath)expandedPaths.next());
        }
        this.memberTable.setSelectionPath(selectedPath);
        for (i = 0; i < widths.length; ++i) {
            this.memberTable.getColumn(i).setWidth(widths[i]);
        }
        this.memberTable.expandLevel(2);
    }

    @Deprecated
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Panel header = this.createHeaderPanel(parent);
        this.memberTable = this.createTable(parent);
        String columns = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref,5dlu, fill:pref:grow, 5dlu";
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref,5dlu, fill:pref:grow, 5dlu");
        PanelBuilder builder = new PanelBuilder(layout, parent);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)header, cc.xy(2, 2));
        builder.add((UiComponent)this.memberTable, cc.xy(2, 4));
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }

    private Panel createHeaderPanel(UiContainer parent) {
        Panel container = new Panel(parent);
        container.setLayout((Layout)new BorderLayout(0, 5));
        CatalogObjectHeaderPanel header = new CatalogObjectHeaderPanel((UiContainer)container, (CatalogObject)this.getProjectObject());
        this.showHidden = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.SHOW_HIDDEN_METHODS);
        this.showHidden.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ComponentStructurePanel.this.refreshStructure();
            }
        });
        this.showHidden.setSelected(false);
        container.add((UiComponent)this.showHidden, (Object)"South");
        container.add((UiComponent)header, (Object)"Center");
        return container;
    }

    private Image getIconFor(Object value) {
        Image result = null;
        if (value instanceof XFormPresentationModel) {
            result = IconFactory.getIconFor((XFormPresentationModel)value, (XObjectTypeDescription)this.getProjectObject());
        } else if (value instanceof Argument) {
            Argument arg = (Argument)value;
            if ((arg.getModifiers() & 0x10L) != 0L) {
                result = Image.create((Msg)UIMsg.ARG_RETURN);
            }
        } else {
            result = IconFactory.getIconFor((TypeRef)value);
        }
        return result;
    }

    private TreeTable createTable(UiContainer parent) {
        this.memberModel = new ReadOnlyMemberEditorModel((CatalogObject)this.getProjectObject(), this.showHidden.isSelected());
        this.memberTable = new TreeTable(parent, (TreeTableModel)this.memberModel, true);
        this.initTemplateRenderer();
        this.memberTable.expandLevel(2);
        this.memberTable.repaint();
        this.memberTable.setPreferredRows(5);
        this.setupColumnSizes();
        this.memberTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object selected = ComponentStructurePanel.this.memberTable.getLastSelectedPathComponent();
                Selection selection = DefaultSelection.createSingle((Object)selected);
                AbstractStudioWorkbench.getInstance().getEditorAreaSelectionProvider().setSelection(selection);
            }
        });
        return this.memberTable;
    }

    private void setupColumnSizes() {
        this.memberTable.getColumn(2).setWidth(130);
        this.memberTable.getColumn(2).setResizable(false);
        this.memberTable.getColumn(3).setWidth(60);
        this.memberTable.getColumn(3).setResizable(false);
    }

    private void initTemplateRenderer() {
        TreeColumnLabelFontProvider nameColumnProvider = new TreeColumnLabelFontProvider(this.memberTable.getFont(), 0);
        TreeTableColumn columnName = this.memberTable.getColumn(0);
        columnName.setLabelProvider((LabelProvider)nameColumnProvider);
        columnName.setFontProvider((FontProvider)nameColumnProvider);
        columnName.setColorProvider((ColorProvider)nameColumnProvider);
        TreeColumnLabelFontProvider descriptionColumnProvider = new TreeColumnLabelFontProvider(this.memberTable.getFont(), 1);
        TreeTableColumn columnDescription = this.memberTable.getColumn(1);
        columnDescription.setLabelProvider((LabelProvider)descriptionColumnProvider);
        columnDescription.setFontProvider((FontProvider)descriptionColumnProvider);
        columnDescription.setColorProvider((ColorProvider)descriptionColumnProvider);
        TreeColumnLabelFontProvider pKColumnProvider = new TreeColumnLabelFontProvider(this.memberTable.getFont(), 3);
        TreeTableColumn columnPk = this.memberTable.getColumn(3);
        columnPk.setLabelProvider((LabelProvider)pKColumnProvider);
        columnPk.setFontProvider((FontProvider)pKColumnProvider);
        columnPk.setColorProvider((ColorProvider)pKColumnProvider);
        TreeColumnLabelFontProvider typeColumnProvider = new TreeColumnLabelFontProvider(this.memberTable.getFont(), 2);
        TreeTableColumn columnType = this.memberTable.getColumn(2);
        columnType.setLabelProvider((LabelProvider)typeColumnProvider);
        columnType.setFontProvider((FontProvider)typeColumnProvider);
        columnType.setColorProvider((ColorProvider)typeColumnProvider);
    }

    private class TreeColumnLabelFontProvider
    extends TreeTableFontProvider.Default
    implements TreeTableLabelProvider,
    TreeTableColorProvider {
        private final int column;
        private Font defaultFont;

        TreeColumnLabelFontProvider(Font font, int column) {
            this.defaultFont = font;
            this.column = column;
        }

        public Image getIcon(Object element) {
            Image result = null;
            if (this.column == 0 && element instanceof TypeDescription) {
                TypeDescription td = (TypeDescription)element;
                result = ComponentStructurePanel.this.getIconFor(td.getRef());
                if (ComponentStructurePanel.this.memberModel.isMemberInherited(td)) {
                    result = Image.create((Msg)DesignerMsg.INHERITED_MEMBER);
                }
            }
            return result;
        }

        public String getText(Object element) {
            Object valueAt;
            String result = ComponentStructurePanel.this.memberModel != null && element != null ? ((valueAt = ComponentStructurePanel.this.memberModel.getValueAt(this.getObject(), this.column, true)) != null ? valueAt.toString() : "") : "";
            return result;
        }

        public Font getFont(Object dummy) {
            Font font = this.defaultFont;
            if (ComponentStructurePanel.this.memberModel != null) {
                boolean visible = ComponentStructurePanel.this.memberModel.isNodeVisible(this.getObject());
                boolean deprecated = ComponentStructurePanel.this.memberModel.isDeprecated(this.getObject());
                if (!visible) {
                    font = this.defaultFont.applyStyle(FontStyle.ITALIC);
                }
                if (deprecated) {
                    font = this.defaultFont.applyStyle(FontStyle.ITALIC);
                }
            }
            return font;
        }

        public Color getForeground(Object dummy) {
            if (ComponentStructurePanel.this.memberModel != null) {
                boolean visible = ComponentStructurePanel.this.memberModel.isNodeVisible(this.getObject());
                boolean deprecated = ComponentStructurePanel.this.memberModel.isDeprecated(this.getObject());
                if (!visible || deprecated) {
                    return Color.LIGHT_GRAY;
                }
            }
            return null;
        }

        public Color getBackground(Object dummy) {
            return null;
        }
    }

    private class ReadOnlyMemberEditorModel
    extends MemberEditorModel {
        public ReadOnlyMemberEditorModel(CatalogObject root, boolean showHidden) {
            super(root.getObjectType(), showHidden);
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, Object node, int column) {
        }
    }
}

