/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.precision;

import java.util.ArrayList;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.AbstractPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class TimePrecisionPanel
extends AbstractPrecisionPanel {
    private boolean eventsEnabled = true;
    private ComboBox precisionCombo;
    static final int TIMESTAMP = 2;

    public TimePrecisionPanel(PrecisionPanel parentPanel, PrecisionMediator precisionMediator) {
        super(parentPanel, precisionMediator);
        this.initGui();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.precisionCombo.setEnabled(enabled);
    }

    @Override
    public int getPrecision() {
        return this.precisionCombo.getSelectedIndex();
    }

    @Override
    public boolean isPrecisionSet() {
        return true;
    }

    @Override
    public void clear() {
        this.precisionCombo.setSelectedIndex(2);
    }

    @Override
    public void deselectPrecision() {
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        int index = attribute.asAttribute().getPrecision();
        if (index < 0) {
            index = 2;
        }
        this.eventsEnabled = false;
        this.precisionCombo.setSelectedIndex(index);
        this.eventsEnabled = true;
    }

    private void buildTimeCombo() {
        ArrayList<Msg> precisions = new ArrayList<Msg>();
        precisions.add(DesignerMsg.ATT_DATE_ONLY);
        precisions.add(DesignerMsg.ATT_TIME_ONLY);
        precisions.add(DesignerMsg.ATT_TIMESTAMP);
        this.precisionCombo = UiFactory.createComboBox((UiContainer)this, precisions);
        this.precisionCombo.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
        this.precisionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected() && TimePrecisionPanel.this.eventsEnabled) {
                    int precision = TimePrecisionPanel.this.precisionCombo.getSelectedIndex();
                    TimePrecisionPanel.this.getPrecisionMediator().timePrecisionChanged(precision);
                }
            }
        });
        this.precisionCombo.setToolTipMsg(DesignerMsg.TIME_PRECISION_TOOLTIP);
    }

    private void initGui() {
        String cols = "2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu";
        String rows = "3dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        Label precisionLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TIME_PRECISION);
        precisionLabel.setToolTipText(DesignerMsg.TIME_PRECISION_TOOLTIP.getString());
        builder.add((UiComponent)precisionLabel, cc.xy(2, 2));
        this.buildTimeCombo();
        builder.add((UiComponent)this.precisionCombo, cc.xy(4, 2));
    }
}

