/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.precision;

import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.AbstractPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;

class StringPrecisionPanel
extends AbstractPrecisionPanel {
    private boolean isUnselectingPrecision = false;
    private CheckBox lengthCheck;
    private NumericField<Integer> lengthSpinner;

    public StringPrecisionPanel(PrecisionPanel parentPanel, PrecisionMediator precisionMediator) {
        super(parentPanel, precisionMediator);
        this.initGui();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lengthCheck.setEnabled(enabled);
        this.lengthSpinner.setEnabled(this.lengthCheck.isSelected());
    }

    @Override
    public int getPrecision() {
        return (Integer)this.lengthSpinner.getValue();
    }

    @Override
    public boolean isPrecisionSet() {
        return this.lengthCheck.isSelected();
    }

    @Override
    public void clear() {
        this.lengthSpinner.setValue((Number)10);
        this.lengthSpinner.setEnabled(false);
    }

    @Override
    public void deselectPrecision() {
        this.isUnselectingPrecision = true;
        this.clear();
        this.lengthCheck.setSelected(false);
        this.isUnselectingPrecision = false;
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        boolean isPrecisionSet;
        int length = attribute.asAttribute().getResultType().getLength();
        boolean bl = isPrecisionSet = length != -1;
        if (!isPrecisionSet) {
            this.deselectPrecision();
        } else {
            this.lengthSpinner.setValue((Number)length);
            this.lengthCheck.setSelected(true);
        }
    }

    private void changeLength() {
        int length = -1;
        if (this.lengthCheck.isSelected()) {
            length = (Integer)this.lengthSpinner.getValue();
        }
        this.getPrecisionMediator().stringPrecisionChanged(length);
    }

    private CheckBox createLengthCheck(UiContainer parent) {
        final CheckBox result = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.MAX_STRING_LENGTH);
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StringPrecisionPanel.this.lengthSpinner.setEnabled(result.isSelected());
                if (!StringPrecisionPanel.this.isUnselectingPrecision) {
                    StringPrecisionPanel.this.changeLength();
                }
            }
        });
        result.setToolTipText(DesignerMsg.MAXIMUM_LENGTH_TOOLTIP.getString());
        result.setBackground(Color.WHITE);
        return result;
    }

    private NumericField<Integer> createLengthSpinner(UiContainer parent) {
        NumericField result = NumericField.createIntegerNumericField((UiContainer)parent);
        result.setValue((Number)0);
        result.setRange((Number)0, (Number)10000);
        result.setStepSize((Number)1);
        result.setEnabled(false);
        result.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!StringPrecisionPanel.this.isUnselectingPrecision) {
                    StringPrecisionPanel.this.changeLength();
                }
            }
        });
        result.setToolTipText(DesignerMsg.MAXIMUM_LENGTH_TOOLTIP.getString());
        return result;
    }

    private void initGui() {
        String cols = "8dlu, pref, 2dlu, pref, 2dlu";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.lengthCheck = this.createLengthCheck((UiContainer)this);
        builder.add((UiComponent)this.lengthCheck, cc.xy(2, 1));
        this.lengthSpinner = this.createLengthSpinner((UiContainer)this);
        builder.add(this.lengthSpinner, cc.xy(4, 1));
    }
}

