/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.precision;

import oracle.bpm.designer.catalog.bpmobjects.TypeUtilities;
import oracle.bpm.designer.catalog.bpmobjects.attributes.TypePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.AbstractPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.DecimalPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.IntPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.NoPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.RealPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.StringPrecisionPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.TimePrecisionPanel;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;

public class PrecisionPanel
extends Panel {
    private CardLayout cardLayout;
    private DecimalPrecisionPanel decimalPresicionPanel;
    private String editedType;
    private IntPrecisionPanel intPresicionPanel;
    private PrecisionMediator precisionMediator;
    private RealPrecisionPanel realPresicionPanel;
    private StringPrecisionPanel stringPrecisionPanel;
    private TimePrecisionPanel timePrecisionPanel;
    private static final String DEFAULT = "Default";

    public PrecisionPanel(UiContainer parent, boolean isReadOnly, PrecisionMediator precisionMediator) {
        super(parent);
        this.precisionMediator = precisionMediator;
        this.initGui();
        this.setEnabled(!isReadOnly);
        this.editedType = DEFAULT;
    }

    public AbstractPrecisionPanel getCurrentPrecisionPanel() {
        return (AbstractPrecisionPanel)this.cardLayout.getComponent(this.editedType);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.timePrecisionPanel.setEnabled(enabled);
    }

    public TypePanel getParentPanel() {
        return (TypePanel)this.getParent();
    }

    public int getPrecision() {
        return this.getCurrentPrecisionPanel().getPrecision();
    }

    public boolean isPrecisionSet() {
        return this.getCurrentPrecisionPanel().isPrecisionSet();
    }

    public void loadAttribute(MethodTypeDescription attribute) {
        if (!this.precisionMediator.isPrecisionChanging()) {
            AbstractPrecisionPanel currentPrecisionPanel;
            this.editedType = TypeUtilities.getNonLanguageDependantTypeAsString(attribute);
            boolean hasPrecision = TypeUtilities.hasPrecision(this.editedType);
            if (!hasPrecision) {
                this.editedType = DEFAULT;
            }
            this.cardLayout.show((UiContainer)this, this.editedType);
            if (hasPrecision && (currentPrecisionPanel = this.getCurrentPrecisionPanel()) != null) {
                currentPrecisionPanel.loadAttribute(attribute);
            }
        }
    }

    private void initGui() {
        this.cardLayout = new CardLayout();
        this.setLayout((Layout)this.cardLayout);
        this.stringPrecisionPanel = new StringPrecisionPanel(this, this.precisionMediator);
        this.add((UiComponent)this.stringPrecisionPanel, TypeUtilities.STRING);
        this.decimalPresicionPanel = new DecimalPrecisionPanel(this, this.precisionMediator);
        this.add((UiComponent)this.decimalPresicionPanel, TypeUtilities.DECIMAL);
        this.intPresicionPanel = new IntPrecisionPanel(this, this.precisionMediator);
        this.add((UiComponent)this.intPresicionPanel, TypeUtilities.INT);
        this.realPresicionPanel = new RealPrecisionPanel(this, this.precisionMediator);
        this.add((UiComponent)this.realPresicionPanel, TypeUtilities.REAL);
        this.timePrecisionPanel = new TimePrecisionPanel(this, this.precisionMediator);
        this.add((UiComponent)this.timePrecisionPanel, TypeUtilities.TIME);
        this.add((UiComponent)new NoPrecisionPanel(this, this.precisionMediator), DEFAULT);
    }
}

