/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.precision;

import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentStructureValidValuesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.TypePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.DefaultValuePanel;

public class PrecisionMediator {
    DefaultValuePanel defaultValuePanel;
    TypePanel typePanel;
    ComponentStructureValidValuesPanel validValuesPanel;
    private boolean precisionChanging = false;
    private static final int DOES_NOT_APPLY = -1;

    private PrecisionMediator() {
    }

    public static PrecisionMediator create() {
        return new PrecisionMediator();
    }

    public void setPanelToManage(DefaultValuePanel defaultValuePanel) {
        this.defaultValuePanel = defaultValuePanel;
    }

    public void setPanelToManage(TypePanel typePanel) {
        this.typePanel = typePanel;
    }

    public void setPanelToManage(ComponentStructureValidValuesPanel validValuesPanel) {
        this.validValuesPanel = validValuesPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decimalPrecisionChanged(int scale, int length) {
        this.setPrecisionChanging(true);
        try {
            this.typePanel.reloadTypeScaleAndLength(scale, length);
            this.defaultValuePanel.precisionChanged(scale, length, -1);
        }
        finally {
            this.setPrecisionChanging(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stringPrecisionChanged(int length) {
        this.setPrecisionChanging(true);
        try {
            this.typePanel.realoadStringLength(length);
            this.defaultValuePanel.precisionChanged(-1, length, -1);
            if (this.validValuesPanel != null) {
                this.validValuesPanel.restrictPresition(length);
            }
        }
        finally {
            this.setPrecisionChanging(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timePrecisionChanged(int precision) {
        this.setPrecisionChanging(true);
        try {
            this.typePanel.reloadTimePrecision(precision);
            if (this.defaultValuePanel != null) {
                this.defaultValuePanel.precisionChanged(-1, -1, precision);
                this.defaultValuePanel.revalidate();
            }
            if (this.validValuesPanel != null && this.validValuesPanel.hasStaticValidValues()) {
                this.validValuesPanel.restrictPresition(precision);
            }
        }
        finally {
            this.setPrecisionChanging(false);
        }
    }

    public boolean isPrecisionChanging() {
        return this.precisionChanging;
    }

    public void realPrecisionChanged(int precision) {
        this.intPrecisionChanged(precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intPrecisionChanged(int precision) {
        this.setPrecisionChanging(true);
        try {
            this.typePanel.reloadTypeLength(precision);
            if (this.defaultValuePanel != null) {
                this.defaultValuePanel.precisionChanged(-1, -1, precision);
                this.defaultValuePanel.revalidate();
            }
            if (this.validValuesPanel != null && this.validValuesPanel.hasStaticValidValues()) {
                this.validValuesPanel.restrictPresition(precision);
            }
        }
        finally {
            this.setPrecisionChanging(false);
        }
    }

    private void setPrecisionChanging(boolean precisionChanging) {
        this.precisionChanging = precisionChanging;
    }
}

