/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues;

import oracle.bpm.designer.catalog.bpmobjects.TypeUtilities;
import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentEditorProvider;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.AbstractValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.BooleanValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.DecimalValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.IntValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.IntervalValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.NoDefaultValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.RealPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.StringValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.TimeValuePanel;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.TimeField;

class ValuePanelContainer
extends Panel {
    private BooleanValuePanel booleanValuePanel;
    private CardLayout cardLayout = new CardLayout();
    private DecimalValuePanel decimalValuePanel;
    private IntervalValuePanel intervalValuePanel;
    private IntValuePanel intValuePanel;
    private NoDefaultValuePanel noDefaultValuePanel;
    private RealPanel realValuePanel;
    private StringValuePanel stringValuePanel;
    private TimeValuePanel timeValuePanel;
    private String type;
    private static final String DEFAULT = "default";
    private static final int DOES_NOT_APPLY = -1;

    public ValuePanelContainer(UiContainer parent) {
        super(parent);
        this.setLayout((Layout)this.cardLayout);
        this.timeValuePanel = new TimeValuePanel((UiContainer)this);
        this.add((UiComponent)this.timeValuePanel, TypeUtilities.TIME);
        this.stringValuePanel = new StringValuePanel((UiContainer)this);
        this.add((UiComponent)this.stringValuePanel, TypeUtilities.STRING);
        this.decimalValuePanel = new DecimalValuePanel((UiContainer)this);
        this.add((UiComponent)this.decimalValuePanel, TypeUtilities.DECIMAL);
        this.realValuePanel = new RealPanel((UiContainer)this);
        this.add((UiComponent)this.realValuePanel, TypeUtilities.REAL);
        this.intValuePanel = new IntValuePanel((UiContainer)this);
        this.add((UiComponent)this.intValuePanel, TypeUtilities.INT);
        this.booleanValuePanel = new BooleanValuePanel((UiContainer)this);
        this.add((UiComponent)this.booleanValuePanel, TypeUtilities.BOOLEAN);
        this.intervalValuePanel = new IntervalValuePanel((UiContainer)this);
        this.add((UiComponent)this.intervalValuePanel, TypeUtilities.INTERVAL);
        this.noDefaultValuePanel = new NoDefaultValuePanel((UiContainer)this);
        this.add((UiComponent)this.noDefaultValuePanel, DEFAULT);
    }

    public String getDefaultValue(String type) {
        boolean isComplex = TypeUtilities.isComplexType(type);
        if (isComplex || type.equals(TypeUtilities.ANY) || type.equals(TypeUtilities.BINARY)) {
            type = DEFAULT;
        }
        return ((AbstractValuePanel)this.cardLayout.getComponent(type)).getDefaultValue();
    }

    public void setEnabled(boolean enabled) {
        AbstractValuePanel valuePanel;
        super.setEnabled(enabled);
        if (this.typeIsSet() && (valuePanel = this.getCurrentValuePanel()) != null) {
            valuePanel.setEnabled(enabled);
        }
    }

    public void addChangeListener(FuegoObjectAttributePropertiesPanel panel) {
        this.stringValuePanel.addChangeListener(panel);
        this.booleanValuePanel.addChangeListener(panel);
        this.timeValuePanel.addChangeListener(panel);
        this.intervalValuePanel.addChangeListener(panel);
        this.decimalValuePanel.addChangeListener(panel);
        this.intValuePanel.addChangeListener(panel);
        this.realValuePanel.addChangeListener(panel);
    }

    public void clearContent() {
        if (this.type != null) {
            this.getCurrentValuePanel().clear();
        }
    }

    public void loadDefaultValue(MethodTypeDescription attribute) {
        String defaultValue = attribute.asAttribute().getDefaultValue();
        if (defaultValue != null) {
            this.getCurrentValuePanel().loadAttribute(attribute);
        }
    }

    public void precisionChanged(int scale, int length, int timePrecision) {
        if (this.type != null && TypeUtilities.hasPrecision(this.type)) {
            this.getCurrentValuePanel().precisionChanged(scale, length, timePrecision);
        }
    }

    public void showDefaultValuePanelForType(MethodTypeDescription attribute, boolean enable) {
        String type = TypeUtilities.getNonLanguageDependantTypeAsString(attribute);
        boolean isComplex = TypeUtilities.isComplexType(attribute);
        if (isComplex || type.equals(TypeUtilities.ANY) || type.equals(TypeUtilities.BINARY)) {
            type = DEFAULT;
        }
        this.type = type;
        boolean disable = type.equals(TypeUtilities.BINARY) || type.equals(TypeUtilities.ANY);
        this.cardLayout.show((UiContainer)this, type);
        int formatType = attribute.getResultType().getKind();
        if (formatType == 5 || formatType == 3) {
            int scale = attribute.getResultType().getScale();
            int length = attribute.getResultType().getLength();
            if (length != -1 || scale != -1) {
                this.getCurrentValuePanel().precisionChanged(scale, length, -1);
            }
        }
        if (formatType == 6) {
            int precision = attribute.asAttribute().getPrecision();
            TimeField.Style style = ComponentEditorProvider.getStyle(precision);
            this.timeValuePanel.getTimeField().setStyle(style);
        }
        this.setEnabled(!disable && enable);
        AbstractValuePanel valuePanel = this.getCurrentValuePanel();
        if (valuePanel != null) {
            valuePanel.clear();
        }
    }

    public boolean typeIsSet() {
        return this.type != null;
    }

    AbstractValuePanel getCurrentValuePanel() {
        return (AbstractValuePanel)this.cardLayout.getComponent(this.type);
    }
}

