/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues;

import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.ValuePanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.xobject.util.XObjectValueResolver;

class StringValuePanel
extends ValuePanel {
    protected TextField valueTextField;

    public StringValuePanel(UiContainer parent) {
        super(parent);
    }

    @Override
    public void highLight(boolean hightlight) {
        String tooltip = DesignerMsg.DEFAULT_VALUE_TOOLTIP.getString();
        this.valueTextField.setToolTipText(tooltip);
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        String defaultValue = attribute.asAttribute().getDefaultValue();
        defaultValue = defaultValue == null ? "" : defaultValue;
        XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)5);
        defaultValue = (String)setter.getValueFromString(defaultValue);
        this.valueTextField.setText(defaultValue);
    }

    @Override
    public void addChangeListener(FuegoObjectAttributePropertiesPanel panel) {
        panel.addListener(this.valueTextField);
    }

    @Override
    public String getDefaultValue() {
        String defaultValue = this.valueTextField.getText();
        if (defaultValue.equals("") && this.isTakeEmptyStringAsNullValue()) {
            defaultValue = null;
        }
        return defaultValue;
    }

    public void selectText(int start, int end) {
        this.valueTextField.setSelectionStart(start);
        this.valueTextField.setSelectionEnd(end);
    }

    public void selectText() {
        int start = 0;
        int end = this.valueTextField.getText().length();
        this.selectText(start, end);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.valueTextField.setEnabled(enabled);
    }

    @Override
    protected void initGui() {
        this.valueTextField = new TextField((UiContainer)this);
        this.setToolTipText(DesignerMsg.DEFAULT_VALUE_TOOLTIP.getString());
        this.add((UiComponent)this.valueTextField);
        this.highlighter.setComponentToHightlight((UiComponent)this.valueTextField);
        this.valueTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                StringValuePanel.this.selectText();
            }

            public void focusLost(FocusEvent e) {
                StringValuePanel.this.deselectText();
            }
        });
    }

    private void deselectText() {
        this.selectText(0, 0);
    }
}

