/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues;

import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.AbstractHighlightableValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.highlighters.IntervalFieldHighlighter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.util.XObjectValueResolver;

class IntervalValuePanel
extends AbstractHighlightableValuePanel {
    private IntervalField intervalValue;

    public IntervalValuePanel(UiContainer parent) {
        super(parent);
        this.initGui();
    }

    @Override
    public String getDefaultValue() {
        Interval interval = this.intervalValue.getInterval();
        return interval != null ? ConversionUtilities.convertToString((Object)interval) : null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.intervalValue.setEnabled(enabled);
    }

    public void addChangeListener(FuegoObjectAttributePropertiesPanel panel) {
        panel.addListener((UiComponent)this.intervalValue);
    }

    @Override
    public void clear() {
        this.intervalValue.setInterval(new Interval());
    }

    @Override
    public void loadAttribute(MethodTypeDescription attribute) {
        String defaultValue = attribute.asAttribute().getDefaultValue();
        XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)7);
        this.intervalValue.setInterval((Interval)setter.getValueFromString(defaultValue));
    }

    private void initGui() {
        this.intervalValue = new IntervalField((UiContainer)this);
        this.setPreferredSize(Dimension.valueOf(255, 25));
        this.intervalValue.setInterval(new Interval());
        this.intervalValue.setToolTipText(DesignerMsg.DEFAULT_VALUE_TOOLTIP.getString());
        this.highlighter = new IntervalFieldHighlighter();
        this.highlighter.setComponentToHightlight((UiComponent)this.intervalValue);
        this.add((UiComponent)this.intervalValue);
    }
}

