/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues;

import oracle.bpm.designer.catalog.bpmobjects.attributes.AttributePropertiesEditor;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.ValuePanelContainer;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class DefaultValuePanel
extends Panel {
    private RadioButton defaultRadio;
    private ValuePanelContainer defaultValuePanel;
    private RadioButton nullRadio;
    private RadioButton unselectRadiosRadio;

    public DefaultValuePanel(UiContainer parent, boolean isReadOnly) {
        super(parent);
        this.initGui();
        this.setEnabled(!isReadOnly);
    }

    public boolean isDefaultSelected() {
        return this.defaultRadio.isSelected();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nullRadio.setEnabled(enabled);
        this.defaultRadio.setEnabled(enabled);
        if (this.defaultValuePanel.isEnabled()) {
            this.defaultValuePanel.setEnabled(enabled);
        }
    }

    public void setNullEnabled(boolean enableNull) {
        this.nullRadio.setEnabled(enableNull);
    }

    public String getValue(String type) {
        String value = null;
        if (this.defaultRadio.isSelected()) {
            value = this.defaultValuePanel.getDefaultValue(type);
        }
        return value;
    }

    public void addChangeListener(AttributePropertiesEditor panel) {
    }

    public void allowNullValue(boolean nullValueAllowed) {
        if (!nullValueAllowed) {
            this.nullRadio.setSelected(false);
        }
    }

    public void loadDefaultValue(MethodTypeDescription attribute) {
        this.defaultValuePanel.loadDefaultValue(attribute);
    }

    public void precisionChanged(int scale, int length, int timePrecision) {
        this.defaultValuePanel.precisionChanged(scale, length, timePrecision);
    }

    public void selectDefaultValue(boolean selected) {
        this.defaultRadio.setSelected(selected);
    }

    public void selectNull(boolean selected) {
        this.nullRadio.setSelected(selected);
        this.defaultValuePanel.setEnabled(!selected);
    }

    public void showDefaultValuePanelForType(MethodTypeDescription attribute, boolean nullUnselected) {
        String defaultValue = attribute.asAttribute().getDefaultValue();
        if (defaultValue == null && !nullUnselected) {
            this.nullRadio.setSelected(true);
        }
        boolean enabled = !this.nullRadio.isSelected();
        this.defaultValuePanel.showDefaultValuePanelForType(attribute, enabled);
    }

    public void unselectAllRadios() {
        this.unselectRadiosRadio.setSelected(true);
    }

    private void buildDefaultValuePanel(UiContainer parent, boolean oldLayout) {
        this.defaultValuePanel = new ValuePanelContainer(parent);
    }

    private void buildDefaultValueRadio(UiContainer parent, boolean oldLayout) {
        this.defaultRadio = oldLayout ? new RadioButton(parent) : new RadioButton(parent, DesignerMsg.DEFINED);
        this.defaultRadio.setBackground(Color.WHITE);
        this.defaultRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.isStateSelected();
                DefaultValuePanel.this.defaultValuePanel.setEnabled(enabled);
                if (!enabled) {
                    DefaultValuePanel.this.defaultValuePanel.clearContent();
                }
            }
        });
    }

    private void buildNullRadioButton(UiContainer parent) {
        this.nullRadio = new RadioButton(parent, DesignerMsg.NULL);
        this.nullRadio.setBackground(Color.WHITE);
        this.selectNull(true);
        this.nullRadio.setToolTipText(DesignerMsg.NULL_TOOLTIP.getString());
    }

    private void initGui() {
        String rows;
        String cols;
        boolean expanded = false;
        if (expanded) {
            cols = "2dlu, pref, 2dlu, left:pref, 24dlu, pref, fill:2dlu:grow";
            rows = "2dlu, pref, 3dlu, 25dlu, 1dlu";
        } else {
            cols = "2dlu, max(80px;pref), 5dlu, pref,20dlu,pref,2dlu,pref,2dlu:grow";
            rows = "0dlu, pref,1dlu,pref,0dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.buildDefaultValueRadio((UiContainer)this, expanded);
        this.buildDefaultValuePanel((UiContainer)this, expanded);
        this.buildNullRadioButton((UiContainer)this);
        this.unselectRadiosRadio = new RadioButton((UiContainer)this);
        this.unselectRadiosRadio.setVisible(false);
        if (expanded) {
            builder.add((UiComponent)new SeparatorPanel((UiContainer)this, ProjectMsg.DEFAULT_VALUE), cc.xywh(2, 2, 6, 1));
            builder.add((UiComponent)this.defaultRadio, cc.xy(2, 4));
            builder.add((UiComponent)this.defaultValuePanel, cc.xy(4, 4));
            builder.add((UiComponent)this.nullRadio, cc.xy(6, 4));
            builder.add((UiComponent)this.unselectRadiosRadio, cc.xy(7, 4));
        } else {
            builder.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectMsg.DEFAULT_VALUE), cc.xy(2, 2));
            builder.add((UiComponent)this.defaultRadio, cc.xy(4, 2));
            builder.add((UiComponent)this.defaultValuePanel, cc.xy(8, 2));
            builder.add((UiComponent)this.nullRadio, cc.xy(4, 4));
            builder.add((UiComponent)this.unselectRadiosRadio, cc.xy(6, 4));
        }
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.nullRadio);
        group.add((AbstractButton)this.defaultRadio);
        group.add((AbstractButton)this.unselectRadiosRadio);
    }
}

