/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.designer.action.ChangeAttributeVirtualAction;
import oracle.bpm.designer.catalog.bpmobjects.attributes.AttributePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class StorageAndConstraintsPanel
extends Panel {
    private boolean enableEvents;
    private CheckBox notNull;
    private AttributePropertiesEditor parentPanel;
    private CheckBox primaryKey;
    private boolean readOnly;
    private CheckBox virtual;
    private List<VirtualPropertyListener> virtualListeners = CollectionFactory.createList();

    public StorageAndConstraintsPanel(UiContainer parent, boolean isReadOnly, AttributePropertiesEditor parentPanel) {
        super(parent);
        this.readOnly = isReadOnly;
        this.parentPanel = parentPanel;
        this.initGui();
        this.setEnabled(!this.readOnly);
    }

    public void setAttribute(MethodTypeDescription attribute) {
        AttributeTypeDescription attributeTypeDescription = attribute.asAttribute();
        boolean isPrimaryKey = attributeTypeDescription.isPrimaryKey();
        StorageAndConstraintsPanel.set(this.primaryKey, isPrimaryKey);
        StorageAndConstraintsPanel.set(this.notNull, attributeTypeDescription.isRequired());
        StorageAndConstraintsPanel.set(this.virtual, attributeTypeDescription.isVirtual());
    }

    public void setEnabled(boolean enable) {
        StorageAndConstraintsPanel.enable(this.primaryKey, enable);
        this.enableNotNull(enable);
        StorageAndConstraintsPanel.enable(this.virtual, enable);
    }

    public boolean isNotNullSelected() {
        return this.notNull.isSelected();
    }

    public AttributePropertiesEditor getParentPanel() {
        return this.parentPanel;
    }

    public boolean isPrimaryKeySelected() {
        return this.primaryKey != null && this.primaryKey.isSelected();
    }

    public boolean isVirtualSelected() {
        return this.virtual != null && this.virtual.isSelected();
    }

    public void enableNotNull(boolean enable, boolean selected) {
        this.notNull.setSelected(selected);
        this.enableNotNull(enable);
    }

    public void enableNotNull(boolean enable) {
        this.notNull.setEnabled(enable);
    }

    public void enablePrimaryKey(boolean enable, boolean selected) {
        StorageAndConstraintsPanel.set(this.primaryKey, selected);
        this.enablePrimaryKey(enable);
    }

    public void enablePrimaryKey(boolean enable) {
        StorageAndConstraintsPanel.enable(this.primaryKey, enable);
    }

    public void addNotNullListener(ActionListener listener) {
        this.notNull.addActionListener(listener);
    }

    public void removeNotNullListener(ActionListener listener) {
        this.notNull.removeActionListener(listener);
    }

    public void addVirtualListener(VirtualPropertyListener listener) {
        this.virtualListeners.add(listener);
    }

    private static void set(CheckBox checkBox, boolean selected) {
        if (checkBox != null) {
            checkBox.setSelected(selected);
        }
    }

    private static void enable(CheckBox checkBox, boolean selected) {
        if (checkBox != null) {
            checkBox.setEnabled(selected);
        }
    }

    private CheckBox buildNotNullCheckBox(UiContainer parent, boolean includeText) {
        this.notNull = includeText ? CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.NOT_NULL) : CheckBox.create((UiContainer)parent);
        this.notNull.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StorageAndConstraintsPanel.this.getParentPanel().notNullChanged(StorageAndConstraintsPanel.this.notNull.isSelected());
                AttributePropertiesEditor parentPanel = StorageAndConstraintsPanel.this.getParentPanel();
                parentPanel.changed();
                StorageAndConstraintsPanel.this.enableEvents = false;
                parentPanel.autoSave();
                StorageAndConstraintsPanel.this.enableEvents = true;
            }
        });
        this.notNull.setToolTipText(DesignerMsg.NOT_NULL_TOOLTIP.getString());
        return this.notNull;
    }

    private CheckBox buildPrimaryKeyCheckBox(UiContainer parent) {
        this.primaryKey = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.IS_PK);
        this.primaryKey.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StorageAndConstraintsPanel.this.getParentPanel().changed();
            }
        });
        this.primaryKey.setToolTipText(DesignerMsg.PK_TOOLTIP.getString());
        return this.primaryKey;
    }

    private CheckBox buildVirtualCheckBox(UiContainer parent) {
        this.virtual = CheckBox.create((UiContainer)parent, (Msg)ProjectMsg.VIRTUAL);
        this.virtual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StorageAndConstraintsPanel.this.getParentPanel().autoSave();
                new ChangeAttributeVirtualAction(StorageAndConstraintsPanel.this.getParentPanel().getAttribute().asAttribute(), StorageAndConstraintsPanel.this.virtual.isSelected()).doIt();
                StorageAndConstraintsPanel.this.virtualChanged(StorageAndConstraintsPanel.this.virtual.isSelected());
            }
        });
        this.virtual.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (StorageAndConstraintsPanel.this.enableEvents) {
                    AttributePropertiesEditor parentPanel = StorageAndConstraintsPanel.this.getParentPanel();
                    parentPanel.changed();
                    StorageAndConstraintsPanel.this.enableEvents = false;
                    parentPanel.autoSave();
                    StorageAndConstraintsPanel.this.enableEvents = true;
                }
            }
        });
        this.virtual.setToolTipText(DesignerMsg.VIRTUAL_TOOLTIP.getString());
        return this.virtual;
    }

    private void initGui() {
        String rows;
        String cols;
        boolean expanded = false;
        if (expanded) {
            cols = "2dlu, max(60px;pref), 40dlu, max(101px;pref), 40dlu, max(67px;pref), fill:6dlu:grow";
            rows = "2dlu, pref, 3dlu, pref, 2dlu";
        } else {
            cols = "2dlu, max(80px;pref), 5dlu, pref";
            rows = "0dlu, pref,0dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        if (expanded) {
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
        }
        CellConstraints cc = layout.createCellConstraints();
        if (expanded) {
            builder.add((UiComponent)new SeparatorPanel((UiContainer)this, DesignerMsg.STORAGE_AND_CONSTRAINTS), cc.xywh(2, 2, 6, 1));
            builder.add((UiComponent)this.buildVirtualCheckBox((UiContainer)this), cc.xy(2, 4));
            builder.add((UiComponent)this.buildPrimaryKeyCheckBox((UiContainer)this), cc.xy(4, 4));
            builder.add((UiComponent)this.buildNotNullCheckBox((UiContainer)this, expanded), cc.xy(6, 4));
        } else {
            builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NOT_NULL), cc.xy(2, 2));
            builder.add((UiComponent)this.buildNotNullCheckBox((UiContainer)this, expanded), cc.xy(4, 2));
        }
    }

    private void virtualChanged(boolean newValue) {
        for (VirtualPropertyListener listener : this.virtualListeners) {
            listener.virtualChanged(newValue);
        }
    }

    public static interface VirtualPropertyListener {
        public void virtualChanged(boolean var1);
    }
}

