/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.cileditor.DesignerEditorSupport;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.CodeEditorFactory;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.editor.EditorSupport;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.Validation;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.text.TextArea;

public class RequireAndCheckPanel
extends TabbedPane {
    private CodeHolder checkEditor;
    private UiComponent checkView;
    private FuegoObjectAttributePropertiesPanel fuegoObjectAttributePropertiesPanel;
    private CodeHolder requireEditor;
    private UiComponent requireView;

    public RequireAndCheckPanel(UiContainer parent, boolean isReadOnly, FuegoObjectAttributePropertiesPanel fuegoObjectAttributePropertiesPanel) {
        super(parent);
        this.fuegoObjectAttributePropertiesPanel = fuegoObjectAttributePropertiesPanel;
        this.initGui();
        this.setEnabled(!isReadOnly);
    }

    public void setAttribute(MethodTypeDescription attribute) {
        MethodTypeDescription checkCode = new MethodTypeDescription(attribute.getName() + "_check");
        String currentLanguage = EditorPreferences.getInstance().getLanguage();
        Validation[] checkCodeMethod = attribute.getCheckCode();
        if (checkCodeMethod.length > 0) {
            checkCode.setCode(checkCodeMethod[0]);
        } else {
            checkCode.setCode("", currentLanguage);
        }
        checkCode.setModifiers(checkCode.getModifiers() | 0x1000000000L | 0x100000000L);
        checkCode.setResultType(TypeFactory.getBool());
        checkCode.setParent(attribute.getParent());
        this.checkEditor.setCode(checkCode);
        this.checkEditor.checkChangeLanguage();
        MethodTypeDescription requireCode = new MethodTypeDescription(attribute.getName() + "_require");
        Validation[] requireCodeMethod = attribute.getRequireCode();
        if (requireCodeMethod.length > 0) {
            requireCode.setCode(requireCodeMethod[0]);
        } else {
            requireCode.setCode("", currentLanguage);
        }
        requireCode.setResultType(TypeFactory.getBool());
        requireCode.setModifiers(requireCode.getModifiers() | 0x1000000000L | 0x100000000L);
        requireCode.setParent(attribute.getParent());
        this.requireEditor.setCode(requireCode);
        this.requireEditor.checkChangeLanguage();
    }

    public String getCheckCode() {
        return this.checkEditor.getText();
    }

    public boolean isCheckCodeEnabled() {
        return this.checkView.isEnabled();
    }

    public String getCheckCodeLanguage() {
        return this.checkEditor.getLanguage().getId();
    }

    public void setCheckEnabled(boolean enable) {
        if (!this.requireEditor.isEnabled() && enable) {
            this.setSelectedComponent(this.checkView);
        }
        this.checkEditor.setEnabled(enable);
        this.setEnabledAt(1, enable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setRequiredEnabled(enabled);
        this.setCheckEnabled(enabled);
    }

    public FuegoObjectAttributePropertiesPanel getParentPanel() {
        return this.fuegoObjectAttributePropertiesPanel;
    }

    public String getRequireCode() {
        return this.requireEditor.getText();
    }

    public boolean isRequireCodeEnabled() {
        return this.requireView.isEnabled();
    }

    public String getRequireLanguage() {
        return this.requireEditor.getLanguage().getId();
    }

    public void setRequiredEnabled(boolean enable) {
        this.requireEditor.setEnabled(enable);
        this.setEnabledAt(0, enable);
        if (enable) {
            this.setSelectedComponent(this.requireView);
        }
    }

    public void checkLanguage() {
        if (this.checkEditor != null) {
            this.checkEditor.checkChangeLanguage();
        }
        if (this.requireEditor != null) {
            this.requireEditor.checkChangeLanguage();
        }
    }

    private void addDocumentListeners() {
        ChangeListener doc = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RequireAndCheckPanel.this.getParentPanel().changed();
            }
        };
        this.checkEditor.addChangeListener(doc);
        this.requireEditor.addChangeListener(doc);
    }

    private CodeHolder createExpressionEditor(UiContainer parent) {
        CodeHolder result;
        String language = EditorPreferences.getInstance().getLanguage();
        if (this.isSwing()) {
            CodeEditor editorPane = CodeEditorFactory.create((UiContainer)parent, (EditorSupport)new DesignerEditorSupport(), (String)language);
            result = new CodeEditorHolder(editorPane);
        } else {
            result = new PlainTextHolder(parent);
        }
        return result;
    }

    private void initGui() {
        this.requireEditor = this.createExpressionEditor((UiContainer)this);
        this.requireView = this.requireEditor.getView();
        this.requireView.setToolTipText(DesignerMsg.REQUIRE_TOOLTIP.getString());
        this.addTab(DesignerMsg.REQUIRE_EXPRESSION, this.requireView);
        this.setToolTipTextAt(0, DesignerMsg.REQUIRE_TOOLTIP.getString());
        this.checkEditor = this.createExpressionEditor((UiContainer)this);
        this.checkView = this.checkEditor.getView();
        this.checkView.setToolTipText(DesignerMsg.CHECK_TOOLTIP.getString());
        this.addTab(DesignerMsg.CHECK_EXPRESSION, this.checkView);
        this.setToolTipTextAt(1, DesignerMsg.CHECK_TOOLTIP.getString());
        this.addDocumentListeners();
    }

    private class PlainTextHolder
    implements CodeHolder {
        private LanguageSpec language;
        private TextArea textHolder;

        public PlainTextHolder(UiContainer parent) {
            this.textHolder = new TextArea(parent);
            this.textHolder.setRows(6);
            this.textHolder.setColumns(20);
        }

        @Override
        public UiComponent getView() {
            return this.textHolder;
        }

        @Override
        public void setCode(MethodTypeDescription requireCode) {
            try {
                this.language = LanguageSpec.getLanguageSpec((String)requireCode.getCodeLanguage());
            }
            catch (InvalidLanguageException e) {
                e.printStackTrace();
            }
            char[] code = requireCode.getCodeText();
            this.textHolder.setText(new String(code));
        }

        @Override
        public void checkChangeLanguage() {
        }

        @Override
        public String getText() {
            return this.textHolder.getText();
        }

        @Override
        public void addChangeListener(ChangeListener doc) {
        }

        @Override
        public LanguageSpec getLanguage() {
            return this.language;
        }

        @Override
        public boolean isEnabled() {
            return this.textHolder.isEnabled();
        }

        @Override
        public void setEnabled(boolean enable) {
            this.textHolder.setEnabled(enable);
        }
    }

    private static class CodeEditorHolder
    implements CodeHolder {
        private CodeEditor editorPane;

        public CodeEditorHolder(CodeEditor editorPane) {
            this.editorPane = editorPane;
            editorPane.setAddToolBar(false);
            editorPane.setExpression(true);
            editorPane.setExpressionRequired(false);
        }

        @Override
        public UiComponent getView() {
            return this.editorPane.getView();
        }

        @Override
        public void setCode(MethodTypeDescription requireCode) {
            this.editorPane.setCode(requireCode);
            this.editorPane.checkChangeLanguage();
        }

        @Override
        public void checkChangeLanguage() {
            this.editorPane.checkChangeLanguage();
        }

        @Override
        public String getText() {
            return this.editorPane.getText();
        }

        @Override
        public void addChangeListener(ChangeListener doc) {
            this.editorPane.addChangeListener(doc);
        }

        @Override
        public LanguageSpec getLanguage() {
            return this.editorPane.getLanguage();
        }

        @Override
        public boolean isEnabled() {
            return this.editorPane.isEnabled();
        }

        @Override
        public void setEnabled(boolean enable) {
            this.editorPane.setEnabled(enable);
        }
    }

    private static interface CodeHolder {
        public UiComponent getView();

        public void addChangeListener(ChangeListener var1);

        public LanguageSpec getLanguage();

        public boolean isEnabled();

        public void setEnabled(boolean var1);

        public String getText();

        public void setCode(MethodTypeDescription var1);

        public void checkChangeLanguage();
    }
}

