/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.ComponentStructureAbstractPanel;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.catalog.bpmobjects.attributes.AttributePropertiesEditor;
import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentStructureValidValuesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FOAttributePropertiesPanelEnabler;
import oracle.bpm.designer.catalog.bpmobjects.attributes.RequireAndCheckPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.StorageAndConstraintsPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.TypePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.DefaultValuePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.precision.PrecisionMediator;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AbstractTypeRef;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.FocusTraversable;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class FuegoObjectAttributePropertiesPanel
extends ComponentStructureAbstractPanel
implements FocusTraversable,
AttributePropertiesEditor {
    protected CatalogObject object;
    protected ObjectPropertyListener propertyObserver;
    private MethodTypeDescription attribute;
    private ObjectPropertyListener attributeNameListener;
    private RequireAndCheckPanel cilPanel;
    private StorageAndConstraintsPanel constraintsPanel;
    private DefaultValuePanel defaultValuePanel;
    private boolean isLoading;
    private boolean loading;
    private PrecisionMediator precisionMediator;
    private TypePanel typePanel;
    private ComponentStructureValidValuesPanel validValuesPanel;
    private static final List<String> IGNOREABLE_CHANGES = Arrays.asList("hasGetter", "hasSetter");

    public FuegoObjectAttributePropertiesPanel(UiContainer parent, MethodTypeDescription attribute) {
        super(parent, CatalogObjectImpl.get((TypeRef)attribute.getParent()).asObject());
        this.attribute = attribute;
        this.init();
        this.object = CatalogObjectImpl.create((Project)this.getProject(), (TypeRef)attribute);
        this.propertyObserver = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                if (!FuegoObjectAttributePropertiesPanel.this.isUpdating() && !IGNOREABLE_CHANGES.contains(propertyName)) {
                    FuegoObjectAttributePropertiesPanel.this.internalObjectToEditor();
                }
            }
        };
        attribute.addPropertyObserver(AbstractTypeRef.ANY_PROPERTY, this.propertyObserver);
    }

    public static String getName(MethodTypeDescription mtd) {
        String path = "";
        for (TypeDescription mtdParent = mtd.getParent(); mtdParent != null && mtdParent.isInnerType(); mtdParent = mtdParent.getParent()) {
            path = mtdParent.getName() + "." + path;
        }
        path = path + mtd.getName();
        return path;
    }

    @Override
    public void disposeEditor() {
        super.disposeEditor();
        this.attribute.removePropertyObserver(AbstractTypeRef.ANY_PROPERTY, this.propertyObserver);
        this.attribute.removePropertyObserver("name", this.attributeNameListener);
    }

    public void updateAttribute(MethodTypeDescription attribute) {
        this.disableEvents();
        this.loadType();
        this.enableEvents();
    }

    public TypeDescription getCurrentType() {
        TypeDescription result = TypeFactory.getVoid();
        if (this.getAttribute() != null) {
            return this.getAttribute().getResultType();
        }
        return result;
    }

    @Override
    public UiComponent getDefaultComponent() {
        return this.getFirstComponent();
    }

    @Override
    public UiComponent getFirstComponent() {
        return this.typePanel.getFirstComponent();
    }

    public Object getObject() {
        return this.getAttribute();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.typePanel != null) {
            this.typePanel.setEnabled(!this.isReadOnly());
            this.constraintsPanel.setEnabled(!this.isReadOnly());
            this.defaultValuePanel.setEnabled(!this.isReadOnly());
            this.cilPanel.setEnabled(!this.isReadOnly());
            this.validValuesPanel.setEnabled(!this.isReadOnly());
        }
    }

    public int getRestrictions() {
        int restrictions = -1;
        if (this.typePanel.isPrecisionSet()) {
            restrictions = this.typePanel.getPrecision();
        }
        return restrictions;
    }

    @Override
    public boolean accept(UiComponent component) {
        return true;
    }

    public boolean accept() {
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        super.addChangeListener(changeListener);
        this.typePanel.addChangeListener(this);
        this.defaultValuePanel.addChangeListener(this);
        this.cilPanel.addChangeListener(changeListener);
    }

    public void addListener(UiComponent component) {
    }

    @Override
    public void autoSave() {
    }

    public void checkLanguage() {
        this.cilPanel.checkLanguage();
    }

    public void loadType(MethodTypeDescription attribute) {
        boolean nullValue;
        this.isLoading = true;
        if (attribute == null) {
            System.err.println("AN ERROR HAS OCURRED");
            System.err.println("Please report this error to %(BPM_OBJECTS) team together with the trace below. Thank you.");
            Thread.dumpStack();
            this.isLoading = false;
            return;
        }
        this.typePanel.setAttribute(attribute);
        this.constraintsPanel.setAttribute(attribute);
        this.cilPanel.setAttribute(attribute);
        boolean nullUnselected = this.constraintsPanel.isNotNullSelected();
        this.defaultValuePanel.showDefaultValuePanelForType(attribute, nullUnselected);
        this.defaultValuePanel.loadDefaultValue(attribute);
        boolean bl = nullValue = attribute.asAttribute().getDefaultValue() == null;
        if (nullValue) {
            this.defaultValuePanel.selectNull(true);
        } else {
            this.defaultValuePanel.selectDefaultValue(true);
        }
        TypeDescription resultType = attribute.getResultType();
        boolean disableValidValues = resultType.equals(TypeFactory.getBinary()) || resultType.equals(TypeFactory.getAny());
        this.validValuesPanel.setEnabled(!disableValidValues);
        if (!disableValidValues) {
            this.validValuesPanel.setAttribute(attribute, attribute.getParent().asObject());
        }
        this.cilPanel.setAttribute(attribute);
        this.enablePanels();
        if (this.constraintsPanel.isNotNullSelected()) {
            this.defaultValuePanel.selectDefaultValue(true);
            this.defaultValuePanel.allowNullValue(false);
        }
        this.isLoading = false;
    }

    public void loadTypeWithoutEventsBeingFired(MethodTypeDescription attribute) {
        this.disableEvents();
        this.loadType(attribute);
        this.enableEvents();
    }

    @Override
    public void reloadPrecision(MethodTypeDescription attribute) {
        this.fireMemberChanged();
    }

    @Override
    public void reloadType(MethodTypeDescription attribute, boolean typeChanged) {
        StringList validValues;
        this.loading = true;
        this.constraintsPanel.setAttribute(attribute);
        this.cilPanel.setAttribute(attribute);
        boolean nullUnselected = this.constraintsPanel.isNotNullSelected();
        this.defaultValuePanel.showDefaultValuePanelForType(attribute, nullUnselected);
        boolean disableValidValues = attribute.getResultType().equals(TypeFactory.getBinary()) || attribute.getResultType().equals(TypeFactory.getAny());
        this.validValuesPanel.setEnabled(!disableValidValues);
        if (typeChanged && (validValues = attribute.asAttribute().getValidValues()) != null) {
            validValues.clear();
        }
        if (!disableValidValues) {
            this.validValuesPanel.setAttribute(attribute, attribute.getParent().asObject());
        }
        this.cilPanel.setAttribute(attribute);
        this.enablePanels();
        if (this.constraintsPanel.isNotNullSelected()) {
            this.defaultValuePanel.selectDefaultValue(true);
        }
        this.loading = false;
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.ATTRIBUTE;
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public void store() {
    }

    @Override
    public Image getIcon() {
        return IconFactory.getIconFor(this.getAttribute());
    }

    @Override
    public Object getInput() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getAttribute() == null ? "" : FuegoObjectAttributePropertiesPanel.getName(this.getAttribute());
    }

    public boolean isEditing(AttributeTypeDescription attribute) {
        return this.getAttribute() == attribute;
    }

    public void refreshStructure() {
    }

    @Override
    public MethodTypeDescription getAttribute() {
        return this.attribute;
    }

    public void setAttribute(MethodTypeDescription attribute) {
        this.attribute = attribute;
    }

    @Override
    public void notNullChanged(boolean notNullChecked) {
        this.getAttribute().asAttribute().setRequired(notNullChecked);
        this.enablePanels();
        if (notNullChecked) {
            this.defaultValuePanel.selectDefaultValue(notNullChecked);
        }
        this.defaultValuePanel.allowNullValue(!notNullChecked);
    }

    @Override
    protected void replaceObject() {
    }

    @Override
    protected void editorToObject() {
        if (this.getAttribute().getParent() == null) {
            return;
        }
        if (!this.loading) {
            String code;
            this.setDirty(false);
            if (this.isLoading || this.getAttribute() == null) {
                return;
            }
            if (this.cilPanel.isCheckCodeEnabled()) {
                this.getAttribute().clearCheckCode();
                code = this.cilPanel.getCheckCode();
                if (code.trim().length() > 0) {
                    this.getAttribute().addCheckCode(code, this.cilPanel.getCheckCodeLanguage());
                }
            }
            if (this.cilPanel.isRequireCodeEnabled()) {
                this.getAttribute().clearRequireCode();
                code = this.cilPanel.getRequireCode();
                if (code.trim().length() > 0) {
                    this.getAttribute().addRequireCode(code, this.cilPanel.getRequireLanguage());
                }
            }
            AttributeTypeDescription attributeTypeDescription = this.getAttribute().asAttribute();
            attributeTypeDescription.setRequired(this.constraintsPanel.isNotNullSelected());
            attributeTypeDescription.setResultType(this.getAttribute().getResultType().setReferenceType(true));
            attributeTypeDescription.setPrimaryKey(this.constraintsPanel.isPrimaryKeySelected());
            attributeTypeDescription.setVirtual(this.constraintsPanel.isVirtualSelected());
            if (!attributeTypeDescription.isVirtual()) {
                String typeString = attributeTypeDescription.getResultType().getName();
                String value = this.defaultValuePanel.getValue(typeString);
                attributeTypeDescription.setDefaultValue(value);
            }
            this.validValuesPanel.refreshAttribute(this.getAttribute());
        }
    }

    @Override
    protected void buildUI(UiContainer parent) {
        this.disableEvents();
        this.precisionMediator = PrecisionMediator.create();
        ObjectTypeDescription otd = this.getAttribute().getParent().asObject();
        this.typePanel = new TypePanel(parent, otd, this.isReadOnly(), this.precisionMediator, this);
        this.constraintsPanel = new StorageAndConstraintsPanel(parent, this.isReadOnly(), this);
        this.defaultValuePanel = new DefaultValuePanel(parent, this.isReadOnly());
        this.constraintsPanel.addVirtualListener(new StorageAndConstraintsPanel.VirtualPropertyListener(){

            @Override
            public void virtualChanged(boolean virtual) {
                FOAttributePropertiesPanelEnabler enabler = new FOAttributePropertiesPanelEnabler(FuegoObjectAttributePropertiesPanel.this.getAttribute());
                enabler.enable(FuegoObjectAttributePropertiesPanel.this.defaultValuePanel);
                enabler.enable(FuegoObjectAttributePropertiesPanel.this.constraintsPanel);
            }
        });
        this.cilPanel = new RequireAndCheckPanel(parent, this.isReadOnly(), this);
        final Label cilComment = Label.create((UiContainer)parent, (Msg)DesignerMsg.BPMOBJECT_ATTRIBUTE_CIL_COMMENT(this.getAttribute().getName()));
        this.attributeNameListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                cilComment.setText(DesignerMsg.BPMOBJECT_ATTRIBUTE_CIL_COMMENT(FuegoObjectAttributePropertiesPanel.this.getAttribute().getName()));
            }
        };
        this.getAttribute().addPropertyObserver("name", this.attributeNameListener);
        this.validValuesPanel = new ComponentStructureValidValuesPanel(parent, this, this.getAttribute(), otd);
        this.setUpPrecisionMeditator();
        this.addChangeListener();
        String cols = "6dlu, pref, 6dlu";
        String rows = "7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, 80dlu, 1dlu, pref, 12dlu, pref, 7dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = new PanelBuilder(layout, parent);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.typePanel, cc.xy(2, 2));
        builder.add((UiComponent)this.constraintsPanel, cc.xy(2, 4));
        builder.add((UiComponent)this.defaultValuePanel, cc.xy(2, 6));
        builder.add((UiComponent)this.cilPanel, cc.xy(2, 8));
        builder.add((UiComponent)cilComment, cc.xy(2, 10));
        builder.add((UiComponent)this.validValuesPanel, cc.xy(2, 12));
        this.enableEvents();
    }

    @Override
    protected void objectToEditor() {
        if (!this.isDisposed() && this.getAttribute().getParent() != null) {
            this.updateAttribute(this.getAttribute());
        }
    }

    MethodTypeDescription getEditedAttribute() {
        return this.getAttribute();
    }

    void checkIsIncludeInCheck(boolean checkIncluded) {
        this.getAttribute().asAttribute().setIncludeInCheck(checkIncluded);
    }

    private void fireMemberChanged() {
    }

    private void setUpPrecisionMeditator() {
        this.precisionMediator.setPanelToManage(this.typePanel);
        this.precisionMediator.setPanelToManage(this.defaultValuePanel);
        this.precisionMediator.setPanelToManage(this.validValuesPanel);
    }

    private void addChangeListener() {
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (FuegoObjectAttributePropertiesPanel.this.isReceiveEvents()) {
                    FuegoObjectAttributePropertiesPanel.this.setDirty(true);
                }
            }
        });
    }

    private void enablePanels() {
        FOAttributePropertiesPanelEnabler enabler = new FOAttributePropertiesPanelEnabler(this.getAttribute());
        enabler.setReadOnly(this.isReadOnly());
        enabler.enable(this.typePanel);
        enabler.enable(this.constraintsPanel);
        enabler.enable(this.defaultValuePanel);
        enabler.enable(this.cilPanel);
        enabler.enable(this.validValuesPanel);
    }

    private void loadType() {
        this.loadType(this.getAttribute());
    }
}

