/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import oracle.bpm.designer.catalog.bpmobjects.TypeUtilities;
import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentStructureValidValuesPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.RequireAndCheckPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.StorageAndConstraintsPanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.TypePanel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.defaultvalues.DefaultValuePanel;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.type.TypeFactory;
import org.jetbrains.annotations.NotNull;

public class FOAttributePropertiesPanelEnabler {
    private AttributeTypeDescription attribute;
    private boolean isComplexType;
    private boolean isNotGroupAttribute;
    private boolean readOnly;
    private TypeDescription type;

    public FOAttributePropertiesPanelEnabler(@NotNull MethodTypeDescription member) {
        this(member.asAttribute());
    }

    public FOAttributePropertiesPanelEnabler(@NotNull CatalogMember member) {
        this(member.getMemberType().asAttribute());
    }

    private FOAttributePropertiesPanelEnabler(AttributeTypeDescription attribute) {
        this.attribute = attribute;
        this.isNotGroupAttribute = !TypeUtilities.isGroupAttribute(attribute);
        this.isComplexType = TypeUtilities.isComplexType(attribute);
        this.type = attribute.getResultType();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isTypeChangeAllowed() {
        return this.isNotGroupAttribute;
    }

    public boolean canChangePrimaryKey() {
        return this.type.isAtomic() && !this.type.isBinary() && this.hasGetter();
    }

    public boolean canChangeVirtual() {
        return this.isNotGroupAttribute;
    }

    public boolean canSetDefaultValue() {
        return this.isNotGroupAttribute && !this.type.equals(TypeFactory.getAny()) && !this.type.isBinary() && !this.attribute.isVirtual() && !this.isComplexType;
    }

    public boolean canSetNotNull() {
        return this.isNotGroupAttribute && !this.type.equals(TypeFactory.getAny()) && !this.type.isBinary() && !this.attribute.isVirtual();
    }

    public void enable(TypePanel panel) {
        panel.setEnabled(this.isTypeChangeAllowed() && !this.isReadOnly());
    }

    public void enable(DefaultValuePanel panel) {
        boolean enable = this.canSetDefaultValue() && !this.isReadOnly();
        panel.setEnabled(enable);
        if (enable) {
            boolean enableNull = !this.attribute.isVirtual() && !this.attribute.isRequired();
            panel.setNullEnabled(enableNull);
        }
        if (this.attribute.isVirtual()) {
            panel.unselectAllRadios();
        }
    }

    public void enable(StorageAndConstraintsPanel panel) {
        panel.setEnabled(this.isNotGroupAttribute && !this.isReadOnly());
        boolean enableNotNull = this.canSetNotNull();
        if (!enableNotNull) {
            panel.enableNotNull(enableNotNull, false);
        } else {
            panel.enableNotNull(enableNotNull);
        }
        boolean enablePrimaryKey = this.canChangePrimaryKey();
        if (enablePrimaryKey) {
            panel.enablePrimaryKey(enablePrimaryKey);
        } else {
            panel.enablePrimaryKey(enablePrimaryKey, false);
        }
        if (this.isReadOnly()) {
            panel.setEnabled(false);
        }
    }

    public void enable(RequireAndCheckPanel panel) {
        boolean doEnable = this.isNotGroupAttribute && !this.isReadOnly();
        panel.setEnabled(doEnable);
        if (doEnable) {
            boolean virtualRequireEnable = !this.attribute.isVirtual() || this.hasSetter();
            panel.setRequiredEnabled(virtualRequireEnable);
            boolean virtualCheckEnable = !this.attribute.isVirtual() || this.hasGetter();
            panel.setCheckEnabled(virtualCheckEnable);
        }
    }

    public void enable(ComponentStructureValidValuesPanel panel) {
        boolean virtualEnable = !this.attribute.isVirtual() || this.hasSetter();
        panel.setEnabled(this.isNotGroupAttribute && virtualEnable && TypeUtilities.isPrimitive(this.attribute) && !this.isComplexType && !this.isReadOnly());
    }

    private boolean hasGetter() {
        return Modifier.hasGetter(this.attribute.getModifiers());
    }

    private boolean hasSetter() {
        return Modifier.hasSetter(this.attribute.getModifiers());
    }
}

