/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects.attributes;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.CatalogObjectModelListenerAdapter;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.NewValidValueMethodForAttributeAction;
import oracle.bpm.designer.catalog.bpmobjects.attributes.AttributeValidValuesTableModel;
import oracle.bpm.designer.catalog.bpmobjects.attributes.ComponentEditorProvider;
import oracle.bpm.designer.catalog.bpmobjects.attributes.FuegoObjectAttributePropertiesPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioTabbedPane;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.util.StringTokenizer;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.util.XObjectValueResolver;
import org.jetbrains.annotations.NotNull;

public class ComponentStructureValidValuesPanel
extends Panel {
    private CatalogObjectModelListenerAdapter catalogObjectModelAdapter;
    private Panel comboPanel;
    private FuegoObjectAttributePropertiesPanel componentStructureAttributePropertiesPanel;
    private boolean creatingMethod = false;
    private CheckBox descriptionCheckBox;
    private ComboBox<MethodTypeDescription> descriptionMethodCombo;
    private Button descriptionMethodCreationButton;
    private ComboBox<MethodTypeDescription> methodCombo;
    private Button methodCreationButton;
    private Label methodSignatureLabel;
    private Label methodSignatureLabelWithDesc;
    private ObjectTypeDescription otd;
    private CheckBox staticVValuesDescToggle;
    private RadioTabbedPane tabbedPane;
    private Table table;
    private ProviderTableModel<StaticListValue<?>> tableModel;
    private ValueLabelProvider valueLabelProvider;
    private static final String METHOD_COMBO = "methodCombo";
    private static final String DESCRIPTION_METHOD_COMBO = "descriptionMethodCombo";
    private static final int none_index = 0;
    private static final int list_index = 1;
    private static final int method_index = 2;
    @NotNull
    private static final MethodTypeDescription DUMMY_METHOD = new MethodTypeDescription(DesignerMsg.CHOOSE_AN_OPTION.getString());

    public ComponentStructureValidValuesPanel(UiContainer parent, FuegoObjectAttributePropertiesPanel componentStructureAttributePropertiesPanel, MethodTypeDescription methodTypeDescription, ObjectTypeDescription otd) {
        super(parent);
        this.otd = otd;
        this.componentStructureAttributePropertiesPanel = componentStructureAttributePropertiesPanel;
        this.setLayout((Layout)new BorderLayout());
        this.add((UiComponent)new SeparatorPanel((UiContainer)this, DesignerMsg.VALID_VALUES), "North");
        this.tabbedPane = new RadioTabbedPane((UiContainer)this);
        Panel emptyPanel = this.createExplanationPanel(this.tabbedPane.getAddPoint());
        this.tabbedPane.addTab(DesignerMsg.ALL, (UiComponent)emptyPanel);
        Panel listPanel = this.createListPanel(this.tabbedPane.getAddPoint());
        this.tabbedPane.addTab(DesignerMsg.LIST_VALID_VALUES, (UiComponent)listPanel);
        Panel methodPanel = this.createMethodPanel(this.tabbedPane.getAddPoint());
        this.tabbedPane.addTab(DesignerMsg.METHOD_VALID_VALUES, (UiComponent)methodPanel);
        this.add((UiComponent)this.tabbedPane, "Center");
        this.setToolTipText(DesignerMsg.VALID_VALUES_TOOLTIP.getString());
        this.setEnabled(!componentStructureAttributePropertiesPanel.isReadOnly());
        this.setAttribute(methodTypeDescription, otd);
    }

    public static boolean isSuitableValidValuesProvider(MethodTypeDescription member) {
        boolean result = false;
        boolean isAttribute = member.isAttribute();
        if (isAttribute) {
            long modifiers = member.getModifiers();
            boolean hasGetter = Modifier.hasGetter(modifiers) && member.asAttribute().getCode() != null;
            result = !member.asAttribute().isVirtual() || hasGetter;
        }
        return result;
    }

    public void setAttribute(MethodTypeDescription att, ObjectTypeDescription otd) {
        if (!this.creatingMethod) {
            this.doSetAttribute(att, otd);
        } else {
            this.otd = otd;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.tabbedPane.setEnabled(enabled);
    }

    public boolean hasStaticValidValues() {
        return this.tabbedPane.getSelectedIndex() == 0 && this.tableModel.getRowCount() > 0;
    }

    public void reset() {
    }

    public void restrictPresition(int precision) {
        if (this.tableModel.getRowCount() > 0) {
            int type = this.componentStructureAttributePropertiesPanel.getCurrentType().getKind();
            boolean hasDescription = this.staticVValuesDescToggle.isSelected();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                StaticListValue validValue = (StaticListValue)this.tableModel.getRow(i);
                String value = validValue.value.toString();
                switch (type) {
                    case 3: {
                        int dot;
                        if (precision <= -1 || (dot = value.indexOf(46)) < 0 || value.length() - dot <= precision) break;
                        value = value.substring(0, value.length() - (value.length() - dot - precision));
                        validValue.value = XObjectValueResolver.getValueResolver((int)3).getValueFromString(value);
                        break;
                    }
                    case 5: {
                        if (precision <= -1 || value.length() <= precision) break;
                        value = value.substring(0, precision);
                        validValue.value = value;
                        break;
                    }
                    case 6: {
                        validValue.value = ComponentEditorProvider.formatPresition(precision, (Time)validValue.value);
                        break;
                    }
                }
                validValue.description = hasDescription ? validValue.description : value;
            }
            this.table.tableChanged(new TableModelEvent(this.table.getModel()));
        }
    }

    void refreshAttribute(MethodTypeDescription method) {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        AttributeTypeDescription attr = method.asAttribute();
        boolean removeValidValues = false;
        switch (this.tabbedPane.getSelectedIndex()) {
            case 1: {
                if (!this.isValidValuesEmpty()) {
                    XObjectTypeDescriptionHelper.setValidValuesDefinition((AttributeTypeDescription)attr, (int)1, this.asTuples(this.tableModel.getData()), null, (boolean)this.staticVValuesDescToggle.isSelected());
                    this.addValidValueMethod(attr);
                    break;
                }
                removeValidValues = true;
                break;
            }
            case 0: {
                removeValidValues = true;
                break;
            }
            case 2: {
                boolean hasDescription;
                MethodTypeDescription validValuesMethod;
                StringList validValues = attr.getValidValues();
                if (validValues != null) {
                    validValues.clear();
                }
                if (this.descriptionCheckBox.isSelected()) {
                    MethodTypeDescription selectedItem = (MethodTypeDescription)this.descriptionMethodCombo.getSelectedItem();
                    validValuesMethod = selectedItem == DUMMY_METHOD ? null : selectedItem;
                    hasDescription = true;
                } else {
                    MethodTypeDescription selectedItem = (MethodTypeDescription)this.methodCombo.getSelectedItem();
                    validValuesMethod = selectedItem == DUMMY_METHOD ? null : selectedItem;
                    hasDescription = false;
                }
                if (validValuesMethod != null) {
                    XObjectTypeDescriptionHelper.setValidValuesDefinition((AttributeTypeDescription)attr, (int)2, null, (MethodTypeDescription)validValuesMethod, (boolean)hasDescription);
                    this.addValidValueMethod(attr);
                    break;
                }
                removeValidValues = true;
            }
        }
        if (removeValidValues) {
            XObjectTypeDescriptionHelper.setValidValuesDefinition((AttributeTypeDescription)attr, (int)this.tabbedPane.getSelectedIndex(), new ArrayList(), (MethodTypeDescription)new MethodTypeDescription(""), (boolean)false);
        }
    }

    private boolean isValidValuesEmpty() {
        boolean hasAnyRow;
        boolean bl = hasAnyRow = this.tableModel.getRowCount() > 0;
        if (!hasAnyRow) {
            return true;
        }
        boolean hasAnyValue = false;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            StaticListValue validValue = (StaticListValue)this.tableModel.getRow(i);
            hasAnyValue |= validValue.value != null && !Str.isEmpty(validValue.value.toString());
        }
        return !hasAnyValue;
    }

    private void doSetAttribute(MethodTypeDescription att, ObjectTypeDescription otd) {
        this.methodCombo.removeAllItems();
        this.descriptionMethodCombo.removeAllItems();
        this.tableModel.removeAllElements();
        int kind = att.asAttribute().getResultType().getKind();
        Class clazz = XObjectValueResolver.classForKind((int)kind);
        this.tableModel = AttributeValidValuesTableModel.getTableModelForClass(clazz);
        this.table.setModel(this.tableModel);
        this.setTableProperties();
        if (this.table != null) {
            this.table.tableChanged(new TableModelEvent(this.table.getModel()));
            this.componentStructureAttributePropertiesPanel.setAttribute(att);
            this.table.getColumn(0).setLabelProvider((LabelProvider)this.valueLabelProvider);
        }
        this.otd = otd;
        CatalogType currentType = CatalogObjectImpl.get((TypeRef)this.componentStructureAttributePropertiesPanel.getCurrentType());
        CatalogType mapResultType = CatalogType.Default.getMap((CatalogType)CatalogType.Default.getString(), (CatalogType)currentType);
        CatalogType arrayResultType = CatalogType.Default.getArray((CatalogType)currentType);
        this.descriptionMethodCombo.setToolTipText(DesignerMsg.VALID_VALUE_METHOD_FILTER(mapResultType.getText()).getString());
        this.methodCombo.setToolTipText(DesignerMsg.VALID_VALUE_METHOD_FILTER(arrayResultType.getText()).getString());
        String methodSignatureWithoutDescription = "   " + DesignerMsg.VALID_VALUE_METHOD_FILTER(mapResultType.getText()).getString();
        this.methodSignatureLabel.setText(methodSignatureWithoutDescription);
        String methodSignatureWithDescription = "   " + DesignerMsg.VALID_VALUE_METHOD_FILTER(arrayResultType.getText()).getString();
        this.methodSignatureLabelWithDesc.setText(methodSignatureWithDescription);
        AttributeTypeDescription attribute = att.asAttribute();
        EmptyActionForNewValidValuesMethod methodCreationAction = (EmptyActionForNewValidValuesMethod)this.methodCreationButton.getAction();
        methodCreationAction.fill(arrayResultType, otd, attribute);
        EmptyActionForNewValidValuesMethod descriptionMethodCreationAction = (EmptyActionForNewValidValuesMethod)this.descriptionMethodCreationButton.getAction();
        descriptionMethodCreationAction.fill(mapResultType, otd, attribute);
        this.fillCombos();
        String methdodSig = attribute.getValidValuesMethod();
        MethodTypeDescription methodTd = methdodSig != null ? otd.getMember(methdodSig, -1) : null;
        StringList validValuesList = attribute.getValidValues();
        String validValuesDescList = attribute.getProperty("validValuesDescriptionList");
        if (validValuesList != null) {
            this.tabbedPane.setSelectedIndex(1);
            StringList descriptionList = null;
            if (validValuesDescList != null) {
                descriptionList = StringList.create();
                StringTokenizer tok = new StringTokenizer(validValuesDescList, ",");
                while (tok.hasMoreTokens()) {
                    descriptionList.add(tok.nextToken());
                }
            }
            Iterator desc = descriptionList == null ? null : descriptionList.iterator();
            for (String validValue : validValuesList) {
                String description = desc == null || !desc.hasNext() ? "" : (String)desc.next();
                this.tableModel.addRow(StaticListValue.fromStringValue(validValue, description, currentType.getKind()));
            }
            boolean isDecriptionActivated = descriptionList != null;
            this.staticVValuesDescToggle.setSelected(isDecriptionActivated);
            if (isDecriptionActivated) {
                this.table.showColumn(1);
            }
        } else if (methodTd != null) {
            this.tabbedPane.setSelectedIndex(2);
            if (arrayResultType.isAssignableFrom(CatalogObjectImpl.get((TypeRef)methodTd.getResultType()))) {
                this.methodCombo.setSelectedItem((Object)methodTd);
                this.descriptionCheckBox.setSelected(false);
                ((CardLayout)this.comboPanel.getLayout()).show((UiContainer)this.comboPanel, METHOD_COMBO);
            } else if (mapResultType.isAssignableFrom(CatalogObjectImpl.get((TypeRef)methodTd.getResultType()))) {
                this.descriptionMethodCombo.setSelectedItem((Object)methodTd);
                this.descriptionCheckBox.setSelected(true);
                ((CardLayout)this.comboPanel.getLayout()).show((UiContainer)this.comboPanel, DESCRIPTION_METHOD_COMBO);
            } else {
                this.tabbedPane.setSelectedIndex(0);
                this.tabbedPane.revalidate();
            }
        } else if (methdodSig != null) {
            this.tabbedPane.setSelectedIndex(2);
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
        if (this.table != null) {
            this.table.tableChanged(new TableModelEvent(this.table.getModel()));
        }
    }

    private void setTableProperties() {
        this.table.setCellSelectionEnabled(false);
        this.table.setRelativeSizes(new double[]{0.5, 0.5});
        this.table.hideColumn(1);
        TableColumn valueColumn = this.table.getColumn(0);
        valueColumn.setCellEditor((TableCellEditor)new TypeEditor());
        this.valueLabelProvider = new ValueLabelProvider();
        valueColumn.setLabelProvider((LabelProvider)this.valueLabelProvider);
        this.table.setPreferredRows(15);
    }

    private List<Tuple<String, String>> asTuples(List<StaticListValue<?>> data) {
        ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
        for (StaticListValue<?> staticListValue : data) {
            result.add(Tuple.create(this.convertToString(staticListValue), staticListValue.description));
        }
        return result;
    }

    private String convertToString(StaticListValue staticListValue) {
        return ConversionUtilities.convertToString(staticListValue.value);
    }

    private void addCatalogObjectModelListener() {
        if (this.catalogObjectModelAdapter == null) {
            this.catalogObjectModelAdapter = new CatalogObjectModelListenerAdapter(){

                @Override
                public void accessorMethodRemovedFrom(AttributeTypeDescription attribute) {
                    if (attribute != null) {
                        ComponentStructureValidValuesPanel.this.methodCombo.removeItem((Object)attribute);
                        ComponentStructureValidValuesPanel.this.descriptionMethodCombo.removeItem((Object)attribute);
                    }
                }

                @Override
                public void attributeRemoved(AttributeTypeDescription attribute) {
                    ComponentStructureValidValuesPanel.this.methodCombo.removeItem((Object)attribute);
                    ComponentStructureValidValuesPanel.this.descriptionMethodCombo.removeItem((Object)attribute);
                }

                @Override
                public void attributeAdded(AttributeTypeDescription attribute) {
                    ComponentStructureValidValuesPanel.this.addMemberToValidValuesProvidersCombo(attribute);
                }
            };
        }
    }

    private void addMemberToValidValuesProvidersCombo(MethodTypeDescription member) {
        String autogeneratedSuffix = "ValidValues";
        boolean isAutogenerated = member.getName().endsWith(autogeneratedSuffix);
        if (!member.isConstructor() && !isAutogenerated) {
            boolean allowedAttribute = ComponentStructureValidValuesPanel.isSuitableValidValuesProvider(member);
            TypeDescription mapResultType = TypeFactory.getMap(TypeFactory.getString(), this.componentStructureAttributePropertiesPanel.getCurrentType());
            ArrayTypeDescription arrayResultType = TypeFactory.getArray(this.componentStructureAttributePropertiesPanel.getCurrentType());
            if (!member.isAttribute() && member.getArgumentCount() == 0 || allowedAttribute) {
                if (mapResultType.isAssignableFrom(member.getResultType())) {
                    this.descriptionMethodCombo.addItem((Object)member);
                } else if ((!member.isAttribute() || allowedAttribute) && arrayResultType.isAssignableFrom(member.getResultType())) {
                    this.methodCombo.addItem((Object)member);
                }
            }
        }
    }

    private void addValidValueMethod(AttributeTypeDescription attr) {
    }

    private Panel createExplanationPanel(UiContainer parent) {
        Panel emptyPanel = new Panel(parent, UIMsg.TO_MSG((String)""));
        emptyPanel.setLayout((Layout)new BorderLayout());
        LabelMultiline allValidValuesExplanation = new LabelMultiline((UiContainer)emptyPanel, DesignerMsg.ALL_VALID_VALUES);
        emptyPanel.add((UiComponent)allValidValuesExplanation, (Object)"Center");
        return emptyPanel;
    }

    private Panel createListPanel(UiContainer parent) {
        return new ListPanel(parent);
    }

    private Panel createMethodPanel(UiContainer parent) {
        Panel methodMainPanel = new Panel(parent);
        this.comboPanel = new Panel((UiContainer)methodMainPanel);
        CardLayout comboCardLayout = new CardLayout();
        this.comboPanel.setLayout((Layout)comboCardLayout);
        Panel methodWithSignaturePanel = new Panel((UiContainer)this.comboPanel, DesignerMsg.VALID_VALUES_METHOD_WITHOUT_DESCRIPTION);
        methodWithSignaturePanel.setLayout((Layout)new GridLayout(2, 1, 1, 1));
        Panel methodPanel = new Panel((UiContainer)methodWithSignaturePanel);
        methodPanel.setLayout((Layout)new FlowLayout(0));
        Panel descWithSignaturePanel = new Panel((UiContainer)this.comboPanel, DesignerMsg.VALID_VALUES_METHOD_WITH_DESCRIPTION);
        descWithSignaturePanel.setLayout((Layout)new GridLayout(2, 1, 1, 1));
        Panel descPanel = new Panel((UiContainer)descWithSignaturePanel);
        descPanel.setLayout((Layout)new FlowLayout(0));
        String cols = "5dlu, pref, 2dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(methodMainPanel);
        LabelProvider.Default<MethodTypeDescription> labelProvider = new LabelProvider.Default<MethodTypeDescription>(){

            public String getText(MethodTypeDescription element) {
                String result = element.getName();
                return result;
            }
        };
        this.methodCombo = UiFactory.createComboBox((UiContainer)methodPanel);
        this.methodCombo.setBackground(Color.WHITE);
        this.methodCombo.setLabelProvider((LabelProvider)labelProvider);
        this.methodCombo.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        EmptyActionForNewValidValuesMethod methodCreationAction = new EmptyActionForNewValidValuesMethod(false);
        this.methodCreationButton = new Button((UiContainer)methodPanel, (BaseAction)methodCreationAction);
        this.descriptionMethodCombo = UiFactory.createComboBox((UiContainer)descPanel);
        this.descriptionMethodCombo.setBackground(Color.WHITE);
        this.descriptionMethodCombo.setLabelProvider((LabelProvider)labelProvider);
        this.descriptionMethodCombo.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        EmptyActionForNewValidValuesMethod descriptionMethodCreationAction = new EmptyActionForNewValidValuesMethod(true);
        this.descriptionMethodCreationButton = new Button((UiContainer)descPanel, (BaseAction)descriptionMethodCreationAction);
        Panel descriptionCheckBoxPanel = new Panel((UiContainer)methodMainPanel);
        descriptionCheckBoxPanel.setLayout((Layout)new FlowLayout(0));
        this.descriptionCheckBox = CheckBox.create((UiContainer)descriptionCheckBoxPanel, (Msg)DesignerMsg.VALID_VALUES_METHOD_USE_DESCRIPTION);
        this.descriptionCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ((CardLayout)ComponentStructureValidValuesPanel.this.comboPanel.getLayout()).next((UiContainer)ComponentStructureValidValuesPanel.this.comboPanel);
            }
        });
        descriptionCheckBoxPanel.add((UiComponent)this.descriptionCheckBox);
        methodPanel.add(this.methodCombo);
        methodPanel.add((UiComponent)this.methodCreationButton);
        methodWithSignaturePanel.add((UiComponent)methodPanel);
        this.methodSignatureLabelWithDesc = Label.create((UiContainer)methodWithSignaturePanel);
        methodWithSignaturePanel.add((UiComponent)this.methodSignatureLabelWithDesc);
        this.comboPanel.add((UiComponent)methodWithSignaturePanel, (Object)METHOD_COMBO);
        descPanel.add(this.descriptionMethodCombo);
        descPanel.add((UiComponent)this.descriptionMethodCreationButton);
        descWithSignaturePanel.add((UiComponent)descPanel);
        this.methodSignatureLabel = Label.create((UiContainer)descWithSignaturePanel);
        descWithSignaturePanel.add((UiComponent)this.methodSignatureLabel);
        this.comboPanel.add((UiComponent)descWithSignaturePanel, (Object)DESCRIPTION_METHOD_COMBO);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)descriptionCheckBoxPanel, cc.xywh(2, 2, 3, 1));
        builder.add((UiComponent)this.comboPanel, cc.xy(4, 4));
        this.descriptionCheckBox.setEnabled(true);
        this.descriptionCheckBox.setSelected(false);
        return methodMainPanel;
    }

    private void fillCombos() {
        for (int i = 0; i < this.otd.getMemberCount(); ++i) {
            MethodTypeDescription member = this.otd.getMember(i);
            this.addMemberToValidValuesProvidersCombo(member);
        }
        this.methodCombo.addItem((Object)DUMMY_METHOD);
        this.methodCombo.setSelectedItem((Object)DUMMY_METHOD);
        this.descriptionMethodCombo.addItem((Object)DUMMY_METHOD);
        this.descriptionMethodCombo.setSelectedItem((Object)DUMMY_METHOD);
        this.addCatalogObjectModelListener();
    }

    private void stopEditing() {
        TableCellEditor editor;
        int row = this.table.getEditingRow();
        int column = this.table.getEditingColumn();
        if (row >= 0 && column >= 0 && (editor = this.table.getCellEditor(row, column)) != null) {
            editor.stopCellEditing();
        }
    }

    private class TypeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private UiComponent editor;
        private int editorRow;

        private TypeEditor() {
        }

        public Object getCellEditorValue() {
            return this.getValue(this.editor);
        }

        public UiComponent getTableCellEditor(Table table, Object value, boolean isSelected, int row, int column) {
            this.editorRow = row;
            return this.createEditor((UiContainer)table, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.editor = this.getEditorComponent(parent, value);
            return this.editor;
        }

        private UiComponent getEditorComponent(UiContainer parent, Object value) {
            return ComponentEditorProvider.getEditor(parent, ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.getCurrentType().getKind(), ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.getRestrictions(), value);
        }

        private Object getValue(UiComponent current) {
            if (current instanceof TextField) {
                TextField textField = (TextField)current;
                if (textField instanceof NumericField) {
                    return ((NumericField)textField).getValue();
                }
                return textField.getText();
            }
            if (current instanceof TimeField) {
                return ((TimeField)current).getTime();
            }
            if (current instanceof ComboBox) {
                return ((ComboBox)current).getSelectedItem();
            }
            if (current instanceof IntervalField) {
                return ((IntervalField)current).getInterval();
            }
            return null;
        }
    }

    private final class NewValidValuesMethodAction
    extends NewValidValueMethodForAttributeAction {
        boolean withDescription;
        static final long serialVersionUID = -5782281606434915676L;
        static final long serialCheck = 2097206718485232686L;

        public NewValidValuesMethodAction(CatalogType returnType, ObjectTypeDescription otd, AttributeTypeDescription attr, boolean withDescription) {
            super(returnType, otd, attr);
            this.withDescription = withDescription;
        }

        @Override
        public boolean doIt() {
            ComponentStructureValidValuesPanel.this.creatingMethod = true;
            boolean result = super.doIt();
            if (result) {
                MethodTypeDescription attribute = ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.getEditedAttribute();
                XObjectTypeDescriptionHelper.setValidValuesDefinition((AttributeTypeDescription)attribute.asAttribute(), (int)2, null, (MethodTypeDescription)this.getNewMethod().getMemberType(), (boolean)this.withDescription);
                ComponentStructureValidValuesPanel.this.addValidValueMethod(attribute.asAttribute());
                ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.autoSave();
            }
            if (result) {
                MethodTypeDescription newMethod = this.getNewMethod().getMemberType();
                if (this.withDescription) {
                    ComponentStructureValidValuesPanel.this.descriptionMethodCombo.addItem((Object)newMethod);
                    ComponentStructureValidValuesPanel.this.descriptionMethodCombo.setSelectedItem((Object)newMethod);
                } else {
                    ComponentStructureValidValuesPanel.this.methodCombo.addItem((Object)newMethod);
                    ComponentStructureValidValuesPanel.this.methodCombo.setSelectedItem((Object)newMethod);
                }
                ComponentStructureValidValuesPanel.this.comboPanel.revalidate();
            }
            ComponentStructureValidValuesPanel.this.creatingMethod = false;
            return result;
        }
    }

    private class ListPanel
    extends Panel {
        private BaseAction addAction;
        private BaseAction deleteAction;
        private BaseAction downAction;
        private BaseAction upAction;
        private static final int VALUE_COLUMN = 0;
        private static final int DESCRIPTION_COLUMN = 1;

        public ListPanel(UiContainer parent) {
            super(parent);
            this.setLayout((Layout)new BorderLayout());
            this.init();
        }

        void buildActions() {
            this.addAction = new BaseAction(UIMsg.ADD){

                public void run() {
                    ListPanel.this.internalStopCellEditing();
                    ComponentStructureValidValuesPanel.this.tableModel.addRow(StaticListValue.nextValidValue(ComponentStructureValidValuesPanel.this.tableModel.getData(), ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.getCurrentType().getKind()));
                    ComponentStructureValidValuesPanel.this.table.requestFocus();
                    ComponentStructureValidValuesPanel.this.table.editCellAt(ComponentStructureValidValuesPanel.this.tableModel.getRowCount() - 1, 0);
                }
            };
            this.deleteAction = new BaseAction(UIMsg.REMOVE){

                public void run() {
                    ListPanel.this.internalStopCellEditing();
                    int row = ComponentStructureValidValuesPanel.this.table.getSelectedRow();
                    if (row >= 0) {
                        ComponentStructureValidValuesPanel.this.stopEditing();
                        ComponentStructureValidValuesPanel.this.tableModel.removeRow(row);
                    }
                }
            };
            this.upAction = new BaseAction(UIMsg.MOVE_UP){

                public void run() {
                    ListPanel.this.internalStopCellEditing();
                    int row = ComponentStructureValidValuesPanel.this.table.getSelectedRow();
                    if (row > 0) {
                        StaticListValue upRowValue = (StaticListValue)ComponentStructureValidValuesPanel.this.tableModel.getRow(row - 1);
                        Object tempValue = upRowValue.value;
                        String tempDescription = upRowValue.description;
                        StaticListValue current = (StaticListValue)ComponentStructureValidValuesPanel.this.tableModel.getRow(row);
                        upRowValue.value = current.value;
                        upRowValue.description = current.description;
                        current.value = tempValue;
                        current.description = tempDescription;
                        ComponentStructureValidValuesPanel.this.table.tableChanged(new TableModelEvent(ComponentStructureValidValuesPanel.this.table.getModel()));
                        ComponentStructureValidValuesPanel.this.table.setSelectionInterval(row - 1, row - 1);
                    }
                }
            };
            this.downAction = new BaseAction(UIMsg.MOVE_DOWN){

                public void run() {
                    ListPanel.this.internalStopCellEditing();
                    int row = ComponentStructureValidValuesPanel.this.table.getSelectedRow();
                    if (row > -1 && row < ComponentStructureValidValuesPanel.this.tableModel.getRowCount() - 1) {
                        StaticListValue upRowValue = (StaticListValue)ComponentStructureValidValuesPanel.this.tableModel.getRow(row + 1);
                        Object tempValue = upRowValue.value;
                        String tempDescription = upRowValue.description;
                        StaticListValue current = (StaticListValue)ComponentStructureValidValuesPanel.this.tableModel.getRow(row);
                        upRowValue.value = current.value;
                        upRowValue.description = current.description;
                        current.value = tempValue;
                        current.description = tempDescription;
                        ComponentStructureValidValuesPanel.this.table.tableChanged(new TableModelEvent(ComponentStructureValidValuesPanel.this.table.getModel()));
                        ComponentStructureValidValuesPanel.this.table.setSelectionInterval(row - 1, row - 1);
                        ComponentStructureValidValuesPanel.this.table.setSelectionInterval(row + 1, row + 1);
                    }
                }
            };
        }

        private void internalStopCellEditing() {
            if (ComponentStructureValidValuesPanel.this.table.isEditing()) {
                ComponentStructureValidValuesPanel.this.table.getCellEditor().stopCellEditing();
            }
        }

        private void buildPanel() {
            this.add((UiComponent)this.buildStaticValidValuesPanel((UiContainer)this), "Center");
        }

        private Panel buildStaticValidValuesPanel(UiContainer parent) {
            ComponentStructureValidValuesPanel.this.tableModel = (ProviderTableModel)Cast.force(new AttributeValidValuesTableModel());
            Panel tablePanel = new Panel(parent);
            tablePanel.setLayout((Layout)new BorderLayout());
            ComponentStructureValidValuesPanel.this.table = new Table((UiContainer)tablePanel, (TableModel)ComponentStructureValidValuesPanel.this.tableModel, ListSelectionMode.SINGLE_SELECTION);
            ComponentStructureValidValuesPanel.this.setTableProperties();
            tablePanel.add((UiComponent)this.createControls((UiContainer)tablePanel), (Object)"North");
            tablePanel.add((UiComponent)ComponentStructureValidValuesPanel.this.table, (Object)"Center");
            return tablePanel;
        }

        private UiContainer createControls(UiContainer parent) {
            ToolBar toolBar = new ToolBar(parent);
            toolBar.add(this.addAction);
            toolBar.add(this.deleteAction);
            toolBar.addSeparator();
            toolBar.add(this.upAction);
            toolBar.add(this.downAction);
            ComponentStructureValidValuesPanel.this.staticVValuesDescToggle = CheckBox.create((UiContainer)toolBar, (Msg)DesignerMsg.LIST_VALID_VALUES_DESCRIPTION);
            ComponentStructureValidValuesPanel.this.staticVValuesDescToggle.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
            ComponentStructureValidValuesPanel.this.staticVValuesDescToggle.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean selected = e.isStateSelected();
                    boolean isVisible = ComponentStructureValidValuesPanel.this.table.isColumnVisible(1);
                    if (selected) {
                        if (!isVisible) {
                            ComponentStructureValidValuesPanel.this.table.showColumn(1);
                        }
                    } else if (isVisible) {
                        ComponentStructureValidValuesPanel.this.table.hideColumn(1);
                    }
                }
            });
            toolBar.addSeparator();
            toolBar.add((UiComponent)ComponentStructureValidValuesPanel.this.staticVValuesDescToggle);
            return toolBar;
        }

        private void init() {
            this.buildActions();
            this.buildPanel();
        }
    }

    private final class EmptyActionForNewValidValuesMethod
    extends FuegoObjectAction {
        private AttributeTypeDescription attribute;
        private boolean filled;
        private ObjectTypeDescription otd;
        private CatalogType resultType;
        private final boolean withDescription;

        public EmptyActionForNewValidValuesMethod(boolean withDescription) {
            super(DesignerMsg.NEW);
            this.withDescription = withDescription;
            this.filled = false;
        }

        @Override
        public void run() {
            if (this.filled) {
                new NewValidValuesMethodAction(this.resultType, this.otd, this.attribute, this.withDescription).run();
            }
        }

        private void fill(CatalogType resultType, ObjectTypeDescription otd, AttributeTypeDescription attribute) {
            this.resultType = resultType;
            this.otd = otd;
            this.attribute = attribute;
            this.filled = true;
        }
    }

    static class StaticListValue<E> {
        String description;
        E value;

        public StaticListValue(E value, String description) {
            this.value = value;
            this.description = description;
        }

        public static <T> StaticListValue<T> fromStringValue(String validValue, String description, int kind) {
            XObjectValueResolver.ValueResolver valueResolver = XObjectValueResolver.getValueResolver((int)kind);
            Object value = valueResolver.getValueFromString(validValue);
            return new StaticListValue<Object>(value, description);
        }

        public static <T> StaticListValue<T> nextValidValue(List<StaticListValue<?>> staticListValues, int kind) {
            List<T> list = StaticListValue.getValuesOnly(staticListValues);
            XObjectValueResolver.ValueResolver setter = XObjectValueResolver.getValueResolver((int)kind);
            Object value = setter.getNextValidValueFromList(list);
            return new StaticListValue<Object>(value, "");
        }

        private static <T> List<T> getValuesOnly(List<StaticListValue<?>> staticListValues) {
            ArrayList list = new ArrayList(staticListValues.size());
            for (StaticListValue<?> validValue : staticListValues) {
                Object t = validValue.value;
                list.add(t);
            }
            return list;
        }
    }

    public class ValueLabelProvider
    extends LabelProvider.Default {
        public String getText(Object element) {
            TypeDescription currentType = ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.getCurrentType();
            String result = String.valueOf(element);
            if (element != null) {
                int kind = currentType.getKind();
                if (kind == 6) {
                    Locale locale = Locale.getDefault();
                    int restrictions = ComponentStructureValidValuesPanel.this.componentStructureAttributePropertiesPanel.getRestrictions();
                    TimeField.Style style = ComponentEditorProvider.getStyle(restrictions);
                    DateFormat dateFormat = TimeField.getDateFormat((TimeField.Style)style, (TimeField.Format)TimeField.Format.DEFAULT, (Locale)locale);
                    result = ((Time)element).format(dateFormat);
                } else if (kind == 7) {
                    result = IntervalFormat.getInstance().format((Interval)element);
                }
            }
            return result;
        }
    }
}

