/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog.bpmobjects;

import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;

public class TypeUtilities {
    public static final String STRING = TypeFactory.getString().getName();
    public static final String DECIMAL = TypeFactory.getDecimal().getName();
    public static final String TIME = TypeFactory.getTime().getName();
    public static final String BOOLEAN = TypeFactory.getBool().getName();
    public static final String BINARY = TypeFactory.getBinary().getName();
    public static final String ANY = TypeFactory.getAny().getName();
    public static final String INTERVAL = TypeFactory.getInterval().getName();
    public static final String REAL = TypeFactory.getReal().getName();
    public static final String INT = TypeFactory.getInt().getName();

    public static boolean isComplexType(MethodTypeDescription type) {
        int kind = type.getResultType().getKind();
        return kind != 10 && kind != 8 && kind != 1 && kind != 3 && kind != 2 && kind != 7 && kind != 4 && kind != 5 && kind != 6;
    }

    public static boolean isComplexType(String type) {
        return !type.equals(TypeFactory.getAny().getName()) && !type.equals(TypeFactory.getBinary().getName()) && !type.equals(TypeFactory.getBool().getName()) && !type.equals(TypeFactory.getDecimal().getName()) && !type.equals(TypeFactory.getInt().getName()) && !type.equals(TypeFactory.getInterval().getName()) && !type.equals(TypeFactory.getReal().getName()) && !type.equals(TypeFactory.getString().getName()) && !type.equals(TypeFactory.getTime().getName());
    }

    public static boolean isGroupAttribute(AttributeTypeDescription attribute) {
        boolean isGroupAttribute = false;
        if (attribute.getParent() instanceof XObjectTypeDescription) {
            XObjectTypeDescription xotd = (XObjectTypeDescription)attribute.getParent();
            isGroupAttribute = xotd.isGroupAttribute(attribute.getName());
        }
        return isGroupAttribute;
    }

    public static boolean isGroupAttribute(MethodTypeDescription attribute) {
        return TypeUtilities.isGroupAttribute(attribute.asAttribute());
    }

    public static String getNonLanguageDependantTypeAsString(MethodTypeDescription attribute) {
        String result = "";
        if (attribute != null) {
            result = attribute.getResultType().getName();
        }
        return result;
    }

    public static boolean isPrimitive(AttributeTypeDescription attribute) {
        TypeRef result = attribute.getResultType().getRef();
        TypeDescription resultType = result != null ? result.get() : null;
        boolean isPrimitive = resultType != null && resultType.isPredefined() && resultType.getKind() != 8 && !resultType.isAny() && resultType.getKind() != 15;
        return isPrimitive;
    }

    public static String getTypeAsString(MethodTypeDescription attribute) {
        String result = "";
        if (attribute != null) {
            TypeDescription type = attribute.getResultType();
            TypeRenderer renderer = EditorPreferences.getInstance().getLanguageSpec().getTypeRenderer();
            if (type != null) {
                result = renderer.render((TypeRef)type);
            }
        }
        return result;
    }

    public static String getTypeAsString(TypeRef type) {
        String result = "";
        if (type != null) {
            TypeRenderer renderer = EditorPreferences.getInstance().getLanguageSpec().getTypeRenderer();
            result = renderer.render((TypeRef)type.get());
        }
        return result;
    }

    public static boolean hasPrecision(String type) {
        return type.equals(TIME) || type.equals(DECIMAL) || type.equals(STRING) || type.equals(INT) || type.equals(REAL);
    }

    public static TypeRef parseType(String typeText) {
        return TypeUtilities.parseType(typeText, null);
    }

    public static TypeRef parseType(String typeText, TypeDescription context) {
        return EditorPreferences.getInstance().getLanguageSpec().getTypeParser().parse(typeText, context.getCatalog(), context);
    }
}

