/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.InputValidatorImpl;
import oracle.bpm.util.Identifier;

public class ModuleNameInputValidator
extends InputValidatorImpl {
    private TypeRef type;
    private static final int IDENTIFIER_MAX_LENGTH = 100;

    public ModuleNameInputValidator(TypeRef type) {
        this.type = type.getRef();
    }

    public static void validateUnique(TypeRef type, String name) throws InputValidationException {
        InputValidationException.assertFalse(type.get().asObject().hasInnerType(name), DesignerMsg.MODULE_EXISTS);
    }

    public void validate(String name) throws InputValidationException {
        InputValidationException.assertTrue(Identifier.isValid(name), DesignerMsg.INVALID_IDENTIFIER);
        InputValidationException.assertTrue(name.trim().length() <= 100, DesignerMsg.IDENTIFIER_TOO_LONG(100));
        ModuleNameInputValidator.validateUnique(this.type, name);
        char firstChar = name.charAt(0);
        if (ModuleNameInputValidator.isUpperCaseValidationEnabled((char)firstChar)) {
            InputValidationException.assertTrue(Character.isUpperCase(firstChar), DesignerMsg.MODULE_NAME_SHOULD_START_IN_UPPER);
        }
    }
}

