/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.catalog;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.util.Identifier;

public class BPMObjectNameInputValidator
implements InputValidator {
    private TypeRef type;
    private static final int IDENTIFIER_MAX_LENGTH = 100;

    public BPMObjectNameInputValidator(TypeRef type) {
        this.type = type.getRef();
    }

    public static void validateUnique(TypeRef type, String name) throws InputValidationException {
        InputValidationException.assertFalse(type.get().asObject().hasInnerType(name), DesignerMsg.BPM_OBJECT_NAME_EXISTS);
    }

    @Override
    public void validate(String name) throws InputValidationException {
        InputValidationException.assertTrue(Identifier.isValid(name), DesignerMsg.INVALID_IDENTIFIER);
        InputValidationException.assertTrue(name.trim().length() <= 100, DesignerMsg.IDENTIFIER_TOO_LONG(100));
        BPMObjectNameInputValidator.validateUnique(this.type, name);
        char firstChar = name.charAt(0);
        if (BPMObjectNameInputValidator.isUpperCaseValidationEnabled(firstChar)) {
            InputValidationException.assertTrue(Character.isUpperCase(firstChar), DesignerMsg.BPM_OBJECT_NAME_SHOULD_START_IN_UPPER);
        }
    }

    private static boolean isUpperCaseValidationEnabled(char firstChar) {
        return Character.toLowerCase(firstChar) != Character.toUpperCase(firstChar);
    }
}

