/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.target;

import oracle.bpm.designer.capability.target.TargetCapability;
import oracle.bpm.designer.capability.target.TargetFeedback;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class TargetFlowNodeFeedback<T extends FlowNode>
extends TargetCapability<T> {
    private TargetFlowNodeFeedback(@NotNull FlowNodeController<T> controller) {
        super(controller);
    }

    public static <T extends FlowNode> TargetFlowNodeFeedback create(@NotNull FlowNodeController<T> controller) {
        return new TargetFlowNodeFeedback<T>(controller);
    }

    @Override
    void showTargetFeedback(@NotNull TargetFeedback<T> feedback, @NotNull FlowElementController<?> source) {
        boolean accepted = false;
        if (source.getModelObject() instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)source.getModelObject();
            if (flowNode.isEvent() && ((Event)flowNode.asAnyNode(Event.class)).isCatchEvent() && ((FlowNode)this.getModelObject()).isActivity()) {
                accepted = true;
            }
        } else if (source.getModelObject() instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)source.getModelObject();
            accepted = true;
        }
        feedback.setAccepted(accepted);
    }

    @Override
    @NotNull
    TargetFeedback<T> createFeedback(@NotNull FlowElementController<?> source) {
        final boolean isSubprocess = ModelUtils.isSubprocess((FlowNode)((FlowNode)this.getModelObject()));
        return new TargetFeedback.BoundedTargetFeedback<T>(this.getDrawableContainer(), this.getController()){

            @Override
            protected boolean fillInside() {
                return !isSubprocess;
            }
        };
    }
}

