/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.capability.target;

import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

abstract class TargetFeedback<T extends FlowElement>
extends DrawableFeedback<T> {
    private boolean accepted;
    private FlowElementController<T> target;

    TargetFeedback(DrawableNodeContainer<?> container, @NotNull FlowElementController<T> target) {
        super((Drawable<?>)container, target.getModelObject(), DesignerLayer.TARGET_CAPABILITY);
        this.target = target;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public void draw(@NotNull DrawContext context) {
        if (this.isAccepted()) {
            this.drawAccepted(context);
        } else {
            this.drawRejected(context);
        }
    }

    protected abstract void drawAccepted(DrawContext var1);

    protected abstract void drawRejected(DrawContext var1);

    FlowElementController<T> getTarget() {
        return this.target;
    }

    static class BoundedTargetFeedback<T extends FlowElement>
    extends TargetFeedback<T> {
        private Rectangle feedbackBounds;
        private static final int ARC_SIZE = 10;
        private static final int GLOW_WIDTH = 10;

        BoundedTargetFeedback(DrawableNodeContainer<?> container, @NotNull FlowElementController<T> target) {
            super(container, target);
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            return this.getFeedbackRectangle(context);
        }

        public int getWidth(@NotNull DrawContext context) {
            return this.getFeedbackRectangle(context).getWidth();
        }

        public int getHeight(@NotNull DrawContext context) {
            return this.getFeedbackRectangle(context).getHeight();
        }

        @Override
        public void drawAccepted(@NotNull DrawContext context) {
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            Stroke stroke = graphics.getStroke();
            AntialiasingMode mode = graphics.getAntialiasing();
            graphics.setForeground(Color.LIGHT_GRAY);
            Rectangle bounds = context.scaleRectangle(this.getFeedbackRectangle(context));
            int scaledArc = context.scale(10);
            Rectangle shrinked = bounds.shrink(context.scale(10));
            graphics.setAntialiasing(AntialiasingMode.ON);
            if (this.fillInside()) {
                graphics.fillRoundRect(shrinked.getX(), shrinked.getY(), shrinked.getWidth(), shrinked.getHeight(), scaledArc, scaledArc);
            }
            this.drawStokeGlow(graphics, Color.LIGHT_GRAY, shrinked, scaledArc, context.scale(10) / 2);
            graphics.setForeground(original);
            graphics.setStroke(stroke);
            graphics.setAntialiasing(mode);
        }

        @Override
        protected void drawRejected(DrawContext context) {
        }

        protected boolean fillInside() {
            return true;
        }

        private void drawStokeGlow(@NotNull Graphics graphics, @NotNull Color foreground, @NotNull Rectangle bounds, int arc, int glowSteps) {
            int glowWidth = glowSteps * 2;
            for (int i = glowWidth - 2; i >= 2; i -= 2) {
                float pct = (float)(glowWidth - i) / (float)(glowWidth - 1);
                Color color = Color.valueOf((Color)foreground, (int)((int)(pct * 255.0f)));
                graphics.setForeground(color);
                graphics.setStroke(new Stroke(i));
                graphics.drawRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), arc, arc);
            }
        }

        private Rectangle getFeedbackRectangle(@NotNull DrawContext context) {
            if (this.feedbackBounds == null) {
                Rectangle rectangle = this.getTarget().getDrawableObject().getBounds(context);
                this.feedbackBounds = rectangle.expand(10);
            }
            return this.feedbackBounds;
        }
    }
}

